<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.RelationshipRole StructType
 * @subpackage Structs
 */
class Crm_RelationshipRole extends DistributableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsExclusive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExclusive;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ReciprocationRoles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReciprocationRoles
     */
    public $ReciprocationRoles;
    /**
     * The RelationshipTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeId;
    /**
     * The RoleAndTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleAndTypeName;
    /**
     * The RolePlayer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RolePlayer;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Crm.RelationshipRole
     * @uses Crm_RelationshipRole::setDescription()
     * @uses Crm_RelationshipRole::setIsActive()
     * @uses Crm_RelationshipRole::setIsExclusive()
     * @uses Crm_RelationshipRole::setIsSystem()
     * @uses Crm_RelationshipRole::setName()
     * @uses Crm_RelationshipRole::setOrganizationUnitId()
     * @uses Crm_RelationshipRole::setReciprocationRoles()
     * @uses Crm_RelationshipRole::setRelationshipTypeId()
     * @uses Crm_RelationshipRole::setRoleAndTypeName()
     * @uses Crm_RelationshipRole::setRolePlayer()
     * @uses Crm_RelationshipRole::setVisibleBySubordinates()
     * @param string $description
     * @param bool $isActive
     * @param bool $isExclusive
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\ReciprocationRoles $reciprocationRoles
     * @param string $relationshipTypeId
     * @param string $roleAndTypeName
     * @param string $rolePlayer
     * @param bool $visibleBySubordinates
     */
    public function __construct($description = null, $isActive = null, $isExclusive = null, $isSystem = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\ReciprocationRoles $reciprocationRoles = null, $relationshipTypeId = null, $roleAndTypeName = null, $rolePlayer = null, $visibleBySubordinates = null)
    {
        $this
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsExclusive($isExclusive)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setReciprocationRoles($reciprocationRoles)
            ->setRelationshipTypeId($relationshipTypeId)
            ->setRoleAndTypeName($roleAndTypeName)
            ->setRolePlayer($rolePlayer)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsExclusive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExclusive()
    {
        return isset($this->IsExclusive) ? $this->IsExclusive : null;
    }
    /**
     * Set IsExclusive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExclusive
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setIsExclusive($isExclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExclusive) && !is_bool($isExclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExclusive, true), gettype($isExclusive)), __LINE__);
        }
        if (is_null($isExclusive) || (is_array($isExclusive) && empty($isExclusive))) {
            unset($this->IsExclusive);
        } else {
            $this->IsExclusive = $isExclusive;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ReciprocationRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReciprocationRoles|null
     */
    public function getReciprocationRoles()
    {
        return isset($this->ReciprocationRoles) ? $this->ReciprocationRoles : null;
    }
    /**
     * Set ReciprocationRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ReciprocationRoles $reciprocationRoles
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setReciprocationRoles(\patest\StructType\ReciprocationRoles $reciprocationRoles = null)
    {
        if (is_null($reciprocationRoles) || (is_array($reciprocationRoles) && empty($reciprocationRoles))) {
            unset($this->ReciprocationRoles);
        } else {
            $this->ReciprocationRoles = $reciprocationRoles;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeId()
    {
        return isset($this->RelationshipTypeId) ? $this->RelationshipTypeId : null;
    }
    /**
     * Set RelationshipTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeId
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setRelationshipTypeId($relationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeId) && !is_string($relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeId, true), gettype($relationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeId, true)), __LINE__);
        }
        if (is_null($relationshipTypeId) || (is_array($relationshipTypeId) && empty($relationshipTypeId))) {
            unset($this->RelationshipTypeId);
        } else {
            $this->RelationshipTypeId = $relationshipTypeId;
        }
        return $this;
    }
    /**
     * Get RoleAndTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleAndTypeName()
    {
        return isset($this->RoleAndTypeName) ? $this->RoleAndTypeName : null;
    }
    /**
     * Set RoleAndTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleAndTypeName
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setRoleAndTypeName($roleAndTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roleAndTypeName) && !is_string($roleAndTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleAndTypeName, true), gettype($roleAndTypeName)), __LINE__);
        }
        if (is_null($roleAndTypeName) || (is_array($roleAndTypeName) && empty($roleAndTypeName))) {
            unset($this->RoleAndTypeName);
        } else {
            $this->RoleAndTypeName = $roleAndTypeName;
        }
        return $this;
    }
    /**
     * Get RolePlayer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRolePlayer()
    {
        return isset($this->RolePlayer) ? $this->RolePlayer : null;
    }
    /**
     * Set RolePlayer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RolePlayerKind::valueIsValid()
     * @uses \patest\EnumType\RolePlayerKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rolePlayer
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setRolePlayer($rolePlayer = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RolePlayerKind::valueIsValid($rolePlayer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RolePlayerKind', is_array($rolePlayer) ? implode(', ', $rolePlayer) : var_export($rolePlayer, true), implode(', ', \patest\EnumType\RolePlayerKind::getValidValues())), __LINE__);
        }
        if (is_null($rolePlayer) || (is_array($rolePlayer) && empty($rolePlayer))) {
            unset($this->RolePlayer);
        } else {
            $this->RolePlayer = $rolePlayer;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Crm_RelationshipRole
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
