<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.RelationshipDetail StructType
 * @subpackage Structs
 */
class Crm_RelationshipDetail extends PersistableEntity
{
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DisplayRelationAndRightRole
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayRelationAndRightRole;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmed;
    /**
     * The IsLeftFavourite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLeftFavourite;
    /**
     * The IsRightFavourite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRightFavourite;
    /**
     * The IsStrong
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStrong;
    /**
     * The LastModifiedAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastModifiedAuditId;
    /**
     * The LastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LeftClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeftClientId;
    /**
     * The LeftClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeftClientRoleId;
    /**
     * The RightClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RightClientId;
    /**
     * The RightClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RightClientRoleId;
    /**
     * The SoftCreditPercentageLeftToRight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoftCreditPercentageLeftToRight;
    /**
     * The SoftCreditPercentageRightToLeft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoftCreditPercentageRightToLeft;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for Crm.RelationshipDetail
     * @uses Crm_RelationshipDetail::setCreationAuditId()
     * @uses Crm_RelationshipDetail::setCreationDate()
     * @uses Crm_RelationshipDetail::setDisplayRelationAndRightRole()
     * @uses Crm_RelationshipDetail::setIsActive()
     * @uses Crm_RelationshipDetail::setIsConfirmed()
     * @uses Crm_RelationshipDetail::setIsLeftFavourite()
     * @uses Crm_RelationshipDetail::setIsRightFavourite()
     * @uses Crm_RelationshipDetail::setIsStrong()
     * @uses Crm_RelationshipDetail::setLastModifiedAuditId()
     * @uses Crm_RelationshipDetail::setLastModifiedDate()
     * @uses Crm_RelationshipDetail::setLeftClientId()
     * @uses Crm_RelationshipDetail::setLeftClientRoleId()
     * @uses Crm_RelationshipDetail::setRightClientId()
     * @uses Crm_RelationshipDetail::setRightClientRoleId()
     * @uses Crm_RelationshipDetail::setSoftCreditPercentageLeftToRight()
     * @uses Crm_RelationshipDetail::setSoftCreditPercentageRightToLeft()
     * @uses Crm_RelationshipDetail::setTypeId()
     * @param int $creationAuditId
     * @param string $creationDate
     * @param string $displayRelationAndRightRole
     * @param bool $isActive
     * @param bool $isConfirmed
     * @param bool $isLeftFavourite
     * @param bool $isRightFavourite
     * @param bool $isStrong
     * @param int $lastModifiedAuditId
     * @param string $lastModifiedDate
     * @param string $leftClientId
     * @param string $leftClientRoleId
     * @param string $rightClientId
     * @param string $rightClientRoleId
     * @param int $softCreditPercentageLeftToRight
     * @param int $softCreditPercentageRightToLeft
     * @param string $typeId
     */
    public function __construct($creationAuditId = null, $creationDate = null, $displayRelationAndRightRole = null, $isActive = null, $isConfirmed = null, $isLeftFavourite = null, $isRightFavourite = null, $isStrong = null, $lastModifiedAuditId = null, $lastModifiedDate = null, $leftClientId = null, $leftClientRoleId = null, $rightClientId = null, $rightClientRoleId = null, $softCreditPercentageLeftToRight = null, $softCreditPercentageRightToLeft = null, $typeId = null)
    {
        $this
            ->setCreationAuditId($creationAuditId)
            ->setCreationDate($creationDate)
            ->setDisplayRelationAndRightRole($displayRelationAndRightRole)
            ->setIsActive($isActive)
            ->setIsConfirmed($isConfirmed)
            ->setIsLeftFavourite($isLeftFavourite)
            ->setIsRightFavourite($isRightFavourite)
            ->setIsStrong($isStrong)
            ->setLastModifiedAuditId($lastModifiedAuditId)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLeftClientId($leftClientId)
            ->setLeftClientRoleId($leftClientRoleId)
            ->setRightClientId($rightClientId)
            ->setRightClientRoleId($rightClientRoleId)
            ->setSoftCreditPercentageLeftToRight($softCreditPercentageLeftToRight)
            ->setSoftCreditPercentageRightToLeft($softCreditPercentageRightToLeft)
            ->setTypeId($typeId);
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DisplayRelationAndRightRole value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayRelationAndRightRole()
    {
        return isset($this->DisplayRelationAndRightRole) ? $this->DisplayRelationAndRightRole : null;
    }
    /**
     * Set DisplayRelationAndRightRole value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayRelationAndRightRole
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setDisplayRelationAndRightRole($displayRelationAndRightRole = null)
    {
        // validation for constraint: string
        if (!is_null($displayRelationAndRightRole) && !is_string($displayRelationAndRightRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayRelationAndRightRole, true), gettype($displayRelationAndRightRole)), __LINE__);
        }
        if (is_null($displayRelationAndRightRole) || (is_array($displayRelationAndRightRole) && empty($displayRelationAndRightRole))) {
            unset($this->DisplayRelationAndRightRole);
        } else {
            $this->DisplayRelationAndRightRole = $displayRelationAndRightRole;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsConfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmed()
    {
        return isset($this->IsConfirmed) ? $this->IsConfirmed : null;
    }
    /**
     * Set IsConfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmed
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setIsConfirmed($isConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmed) && !is_bool($isConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmed, true), gettype($isConfirmed)), __LINE__);
        }
        if (is_null($isConfirmed) || (is_array($isConfirmed) && empty($isConfirmed))) {
            unset($this->IsConfirmed);
        } else {
            $this->IsConfirmed = $isConfirmed;
        }
        return $this;
    }
    /**
     * Get IsLeftFavourite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLeftFavourite()
    {
        return isset($this->IsLeftFavourite) ? $this->IsLeftFavourite : null;
    }
    /**
     * Set IsLeftFavourite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLeftFavourite
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setIsLeftFavourite($isLeftFavourite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLeftFavourite) && !is_bool($isLeftFavourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLeftFavourite, true), gettype($isLeftFavourite)), __LINE__);
        }
        if (is_null($isLeftFavourite) || (is_array($isLeftFavourite) && empty($isLeftFavourite))) {
            unset($this->IsLeftFavourite);
        } else {
            $this->IsLeftFavourite = $isLeftFavourite;
        }
        return $this;
    }
    /**
     * Get IsRightFavourite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRightFavourite()
    {
        return isset($this->IsRightFavourite) ? $this->IsRightFavourite : null;
    }
    /**
     * Set IsRightFavourite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRightFavourite
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setIsRightFavourite($isRightFavourite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRightFavourite) && !is_bool($isRightFavourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRightFavourite, true), gettype($isRightFavourite)), __LINE__);
        }
        if (is_null($isRightFavourite) || (is_array($isRightFavourite) && empty($isRightFavourite))) {
            unset($this->IsRightFavourite);
        } else {
            $this->IsRightFavourite = $isRightFavourite;
        }
        return $this;
    }
    /**
     * Get IsStrong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStrong()
    {
        return isset($this->IsStrong) ? $this->IsStrong : null;
    }
    /**
     * Set IsStrong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStrong
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setIsStrong($isStrong = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStrong) && !is_bool($isStrong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStrong, true), gettype($isStrong)), __LINE__);
        }
        if (is_null($isStrong) || (is_array($isStrong) && empty($isStrong))) {
            unset($this->IsStrong);
        } else {
            $this->IsStrong = $isStrong;
        }
        return $this;
    }
    /**
     * Get LastModifiedAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastModifiedAuditId()
    {
        return isset($this->LastModifiedAuditId) ? $this->LastModifiedAuditId : null;
    }
    /**
     * Set LastModifiedAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastModifiedAuditId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setLastModifiedAuditId($lastModifiedAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastModifiedAuditId) && !(is_int($lastModifiedAuditId) || ctype_digit($lastModifiedAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastModifiedAuditId, true), gettype($lastModifiedAuditId)), __LINE__);
        }
        if (is_null($lastModifiedAuditId) || (is_array($lastModifiedAuditId) && empty($lastModifiedAuditId))) {
            unset($this->LastModifiedAuditId);
        } else {
            $this->LastModifiedAuditId = $lastModifiedAuditId;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LeftClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftClientId()
    {
        return isset($this->LeftClientId) ? $this->LeftClientId : null;
    }
    /**
     * Set LeftClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftClientId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setLeftClientId($leftClientId = null)
    {
        // validation for constraint: string
        if (!is_null($leftClientId) && !is_string($leftClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftClientId, true), gettype($leftClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leftClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leftClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leftClientId, true)), __LINE__);
        }
        if (is_null($leftClientId) || (is_array($leftClientId) && empty($leftClientId))) {
            unset($this->LeftClientId);
        } else {
            $this->LeftClientId = $leftClientId;
        }
        return $this;
    }
    /**
     * Get LeftClientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftClientRoleId()
    {
        return isset($this->LeftClientRoleId) ? $this->LeftClientRoleId : null;
    }
    /**
     * Set LeftClientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftClientRoleId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setLeftClientRoleId($leftClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($leftClientRoleId) && !is_string($leftClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftClientRoleId, true), gettype($leftClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leftClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leftClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leftClientRoleId, true)), __LINE__);
        }
        if (is_null($leftClientRoleId) || (is_array($leftClientRoleId) && empty($leftClientRoleId))) {
            unset($this->LeftClientRoleId);
        } else {
            $this->LeftClientRoleId = $leftClientRoleId;
        }
        return $this;
    }
    /**
     * Get RightClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRightClientId()
    {
        return isset($this->RightClientId) ? $this->RightClientId : null;
    }
    /**
     * Set RightClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rightClientId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setRightClientId($rightClientId = null)
    {
        // validation for constraint: string
        if (!is_null($rightClientId) && !is_string($rightClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightClientId, true), gettype($rightClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rightClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rightClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rightClientId, true)), __LINE__);
        }
        if (is_null($rightClientId) || (is_array($rightClientId) && empty($rightClientId))) {
            unset($this->RightClientId);
        } else {
            $this->RightClientId = $rightClientId;
        }
        return $this;
    }
    /**
     * Get RightClientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRightClientRoleId()
    {
        return isset($this->RightClientRoleId) ? $this->RightClientRoleId : null;
    }
    /**
     * Set RightClientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rightClientRoleId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setRightClientRoleId($rightClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($rightClientRoleId) && !is_string($rightClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightClientRoleId, true), gettype($rightClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rightClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rightClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rightClientRoleId, true)), __LINE__);
        }
        if (is_null($rightClientRoleId) || (is_array($rightClientRoleId) && empty($rightClientRoleId))) {
            unset($this->RightClientRoleId);
        } else {
            $this->RightClientRoleId = $rightClientRoleId;
        }
        return $this;
    }
    /**
     * Get SoftCreditPercentageLeftToRight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoftCreditPercentageLeftToRight()
    {
        return isset($this->SoftCreditPercentageLeftToRight) ? $this->SoftCreditPercentageLeftToRight : null;
    }
    /**
     * Set SoftCreditPercentageLeftToRight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $softCreditPercentageLeftToRight
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setSoftCreditPercentageLeftToRight($softCreditPercentageLeftToRight = null)
    {
        // validation for constraint: int
        if (!is_null($softCreditPercentageLeftToRight) && !(is_int($softCreditPercentageLeftToRight) || ctype_digit($softCreditPercentageLeftToRight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($softCreditPercentageLeftToRight, true), gettype($softCreditPercentageLeftToRight)), __LINE__);
        }
        if (is_null($softCreditPercentageLeftToRight) || (is_array($softCreditPercentageLeftToRight) && empty($softCreditPercentageLeftToRight))) {
            unset($this->SoftCreditPercentageLeftToRight);
        } else {
            $this->SoftCreditPercentageLeftToRight = $softCreditPercentageLeftToRight;
        }
        return $this;
    }
    /**
     * Get SoftCreditPercentageRightToLeft value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoftCreditPercentageRightToLeft()
    {
        return isset($this->SoftCreditPercentageRightToLeft) ? $this->SoftCreditPercentageRightToLeft : null;
    }
    /**
     * Set SoftCreditPercentageRightToLeft value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $softCreditPercentageRightToLeft
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setSoftCreditPercentageRightToLeft($softCreditPercentageRightToLeft = null)
    {
        // validation for constraint: int
        if (!is_null($softCreditPercentageRightToLeft) && !(is_int($softCreditPercentageRightToLeft) || ctype_digit($softCreditPercentageRightToLeft))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($softCreditPercentageRightToLeft, true), gettype($softCreditPercentageRightToLeft)), __LINE__);
        }
        if (is_null($softCreditPercentageRightToLeft) || (is_array($softCreditPercentageRightToLeft) && empty($softCreditPercentageRightToLeft))) {
            unset($this->SoftCreditPercentageRightToLeft);
        } else {
            $this->SoftCreditPercentageRightToLeft = $softCreditPercentageRightToLeft;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_RelationshipDetail
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
