<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ExtendedClientFilter StructType
 * @subpackage Structs
 */
class Crm_ExtendedClientFilter extends FilterEntity
{
    /**
     * The AccountGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountGroupId;
    /**
     * The AccountTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccountTypeIds
     */
    public $AccountTypeIds;
    /**
     * The AccountTypeSearchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountTypeSearchType;
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CityId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The ClientStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientStatus;
    /**
     * The ClientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ClientType;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The ClientTypeSearchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypeSearchType;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CountryId;
    /**
     * The CreditCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardSuffix;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The DateOfBirthFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfBirthFrom;
    /**
     * The DateOfBirthTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfBirthTo;
    /**
     * The DateTimeField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeField1;
    /**
     * The DateTimeField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeField2;
    /**
     * The DraftInvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DraftInvoiceNumber;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The GlobalStringField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalStringField;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdCard;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LastNameFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastNameFilter;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RegionId;
    /**
     * The RepIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RepIds
     */
    public $RepIds;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SGOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SGOrderId;
    /**
     * The StateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StateId;
    /**
     * The StringField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField1;
    /**
     * The StringField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField2;
    /**
     * The StringField3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField3;
    /**
     * The StringField4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField4;
    /**
     * The StringField5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField5;
    /**
     * The StringField6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField6;
    /**
     * The StringField7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField7;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TicketAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketAreaId;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TicketRow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketRow;
    /**
     * The TicketSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketSeat;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransFromDate;
    /**
     * The TransToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransToDate;
    /**
     * The VATRegistrationNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VATRegistrationNo;
    /**
     * The WorkPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPlace;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for Crm.ExtendedClientFilter
     * @uses Crm_ExtendedClientFilter::setAccountGroupId()
     * @uses Crm_ExtendedClientFilter::setAccountTypeIds()
     * @uses Crm_ExtendedClientFilter::setAccountTypeSearchType()
     * @uses Crm_ExtendedClientFilter::setAddressLine1()
     * @uses Crm_ExtendedClientFilter::setAddressLine2()
     * @uses Crm_ExtendedClientFilter::setAddressLine3()
     * @uses Crm_ExtendedClientFilter::setBarcode()
     * @uses Crm_ExtendedClientFilter::setCityId()
     * @uses Crm_ExtendedClientFilter::setClientName()
     * @uses Crm_ExtendedClientFilter::setClientStatus()
     * @uses Crm_ExtendedClientFilter::setClientType()
     * @uses Crm_ExtendedClientFilter::setClientTypeIds()
     * @uses Crm_ExtendedClientFilter::setClientTypeSearchType()
     * @uses Crm_ExtendedClientFilter::setCountryId()
     * @uses Crm_ExtendedClientFilter::setCreditCardSuffix()
     * @uses Crm_ExtendedClientFilter::setCrmId()
     * @uses Crm_ExtendedClientFilter::setDateOfBirthFrom()
     * @uses Crm_ExtendedClientFilter::setDateOfBirthTo()
     * @uses Crm_ExtendedClientFilter::setDateTimeField1()
     * @uses Crm_ExtendedClientFilter::setDateTimeField2()
     * @uses Crm_ExtendedClientFilter::setDraftInvoiceNumber()
     * @uses Crm_ExtendedClientFilter::setEmail()
     * @uses Crm_ExtendedClientFilter::setEventId()
     * @uses Crm_ExtendedClientFilter::setFirstName()
     * @uses Crm_ExtendedClientFilter::setGlobalStringField()
     * @uses Crm_ExtendedClientFilter::setId()
     * @uses Crm_ExtendedClientFilter::setIdCard()
     * @uses Crm_ExtendedClientFilter::setInvoiceNumber()
     * @uses Crm_ExtendedClientFilter::setIsDeceased()
     * @uses Crm_ExtendedClientFilter::setIsHidden()
     * @uses Crm_ExtendedClientFilter::setLastName()
     * @uses Crm_ExtendedClientFilter::setLastNameFilter()
     * @uses Crm_ExtendedClientFilter::setPhone()
     * @uses Crm_ExtendedClientFilter::setQueryId()
     * @uses Crm_ExtendedClientFilter::setRegionId()
     * @uses Crm_ExtendedClientFilter::setRepIds()
     * @uses Crm_ExtendedClientFilter::setSeasonality()
     * @uses Crm_ExtendedClientFilter::setSeasonId()
     * @uses Crm_ExtendedClientFilter::setSeriesId()
     * @uses Crm_ExtendedClientFilter::setSGOrderId()
     * @uses Crm_ExtendedClientFilter::setStateId()
     * @uses Crm_ExtendedClientFilter::setStringField1()
     * @uses Crm_ExtendedClientFilter::setStringField2()
     * @uses Crm_ExtendedClientFilter::setStringField3()
     * @uses Crm_ExtendedClientFilter::setStringField4()
     * @uses Crm_ExtendedClientFilter::setStringField5()
     * @uses Crm_ExtendedClientFilter::setStringField6()
     * @uses Crm_ExtendedClientFilter::setStringField7()
     * @uses Crm_ExtendedClientFilter::setSubscriptionNumber()
     * @uses Crm_ExtendedClientFilter::setTicketAreaId()
     * @uses Crm_ExtendedClientFilter::setTicketNumber()
     * @uses Crm_ExtendedClientFilter::setTicketRow()
     * @uses Crm_ExtendedClientFilter::setTicketSeat()
     * @uses Crm_ExtendedClientFilter::setTransactionNumber()
     * @uses Crm_ExtendedClientFilter::setTransFromDate()
     * @uses Crm_ExtendedClientFilter::setTransToDate()
     * @uses Crm_ExtendedClientFilter::setVATRegistrationNo()
     * @uses Crm_ExtendedClientFilter::setWorkPlace()
     * @uses Crm_ExtendedClientFilter::setZipCode()
     * @param string $accountGroupId
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @param string $accountTypeSearchType
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $barcode
     * @param string $cityId
     * @param string $clientName
     * @param string $clientStatus
     * @param string[] $clientType
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param string $clientTypeSearchType
     * @param string $countryId
     * @param string $creditCardSuffix
     * @param string $crmId
     * @param string $dateOfBirthFrom
     * @param string $dateOfBirthTo
     * @param string $dateTimeField1
     * @param string $dateTimeField2
     * @param int $draftInvoiceNumber
     * @param string $email
     * @param string $eventId
     * @param string $firstName
     * @param \patest\StructType\GlobalString $globalStringField
     * @param string $id
     * @param string $idCard
     * @param int $invoiceNumber
     * @param bool $isDeceased
     * @param bool $isHidden
     * @param string $lastName
     * @param string $lastNameFilter
     * @param string $phone
     * @param string $queryId
     * @param string $regionId
     * @param \patest\StructType\RepIds $repIds
     * @param string $seasonality
     * @param string $seasonId
     * @param string $seriesId
     * @param string $sGOrderId
     * @param string $stateId
     * @param string $stringField1
     * @param string $stringField2
     * @param string $stringField3
     * @param string $stringField4
     * @param string $stringField5
     * @param string $stringField6
     * @param string $stringField7
     * @param string $subscriptionNumber
     * @param string $ticketAreaId
     * @param int $ticketNumber
     * @param string $ticketRow
     * @param string $ticketSeat
     * @param int $transactionNumber
     * @param string $transFromDate
     * @param string $transToDate
     * @param string $vATRegistrationNo
     * @param string $workPlace
     * @param string $zipCode
     */
    public function __construct($accountGroupId = null, \patest\StructType\AccountTypeIds $accountTypeIds = null, $accountTypeSearchType = null, $addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $barcode = null, $cityId = null, $clientName = null, $clientStatus = null, array $clientType = array(), \patest\StructType\ClientTypeIds $clientTypeIds = null, $clientTypeSearchType = null, $countryId = null, $creditCardSuffix = null, $crmId = null, $dateOfBirthFrom = null, $dateOfBirthTo = null, $dateTimeField1 = null, $dateTimeField2 = null, $draftInvoiceNumber = null, $email = null, $eventId = null, $firstName = null, \patest\StructType\GlobalString $globalStringField = null, $id = null, $idCard = null, $invoiceNumber = null, $isDeceased = null, $isHidden = null, $lastName = null, $lastNameFilter = null, $phone = null, $queryId = null, $regionId = null, \patest\StructType\RepIds $repIds = null, $seasonality = null, $seasonId = null, $seriesId = null, $sGOrderId = null, $stateId = null, $stringField1 = null, $stringField2 = null, $stringField3 = null, $stringField4 = null, $stringField5 = null, $stringField6 = null, $stringField7 = null, $subscriptionNumber = null, $ticketAreaId = null, $ticketNumber = null, $ticketRow = null, $ticketSeat = null, $transactionNumber = null, $transFromDate = null, $transToDate = null, $vATRegistrationNo = null, $workPlace = null, $zipCode = null)
    {
        $this
            ->setAccountGroupId($accountGroupId)
            ->setAccountTypeIds($accountTypeIds)
            ->setAccountTypeSearchType($accountTypeSearchType)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setBarcode($barcode)
            ->setCityId($cityId)
            ->setClientName($clientName)
            ->setClientStatus($clientStatus)
            ->setClientType($clientType)
            ->setClientTypeIds($clientTypeIds)
            ->setClientTypeSearchType($clientTypeSearchType)
            ->setCountryId($countryId)
            ->setCreditCardSuffix($creditCardSuffix)
            ->setCrmId($crmId)
            ->setDateOfBirthFrom($dateOfBirthFrom)
            ->setDateOfBirthTo($dateOfBirthTo)
            ->setDateTimeField1($dateTimeField1)
            ->setDateTimeField2($dateTimeField2)
            ->setDraftInvoiceNumber($draftInvoiceNumber)
            ->setEmail($email)
            ->setEventId($eventId)
            ->setFirstName($firstName)
            ->setGlobalStringField($globalStringField)
            ->setId($id)
            ->setIdCard($idCard)
            ->setInvoiceNumber($invoiceNumber)
            ->setIsDeceased($isDeceased)
            ->setIsHidden($isHidden)
            ->setLastName($lastName)
            ->setLastNameFilter($lastNameFilter)
            ->setPhone($phone)
            ->setQueryId($queryId)
            ->setRegionId($regionId)
            ->setRepIds($repIds)
            ->setSeasonality($seasonality)
            ->setSeasonId($seasonId)
            ->setSeriesId($seriesId)
            ->setSGOrderId($sGOrderId)
            ->setStateId($stateId)
            ->setStringField1($stringField1)
            ->setStringField2($stringField2)
            ->setStringField3($stringField3)
            ->setStringField4($stringField4)
            ->setStringField5($stringField5)
            ->setStringField6($stringField6)
            ->setStringField7($stringField7)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTicketAreaId($ticketAreaId)
            ->setTicketNumber($ticketNumber)
            ->setTicketRow($ticketRow)
            ->setTicketSeat($ticketSeat)
            ->setTransactionNumber($transactionNumber)
            ->setTransFromDate($transFromDate)
            ->setTransToDate($transToDate)
            ->setVATRegistrationNo($vATRegistrationNo)
            ->setWorkPlace($workPlace)
            ->setZipCode($zipCode);
    }
    /**
     * Get AccountGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountGroupId()
    {
        return isset($this->AccountGroupId) ? $this->AccountGroupId : null;
    }
    /**
     * Set AccountGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountGroupId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setAccountGroupId($accountGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($accountGroupId) && !is_string($accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountGroupId, true), gettype($accountGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountGroupId, true)), __LINE__);
        }
        if (is_null($accountGroupId) || (is_array($accountGroupId) && empty($accountGroupId))) {
            unset($this->AccountGroupId);
        } else {
            $this->AccountGroupId = $accountGroupId;
        }
        return $this;
    }
    /**
     * Get AccountTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccountTypeIds|null
     */
    public function getAccountTypeIds()
    {
        return isset($this->AccountTypeIds) ? $this->AccountTypeIds : null;
    }
    /**
     * Set AccountTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setAccountTypeIds(\patest\StructType\AccountTypeIds $accountTypeIds = null)
    {
        if (is_null($accountTypeIds) || (is_array($accountTypeIds) && empty($accountTypeIds))) {
            unset($this->AccountTypeIds);
        } else {
            $this->AccountTypeIds = $accountTypeIds;
        }
        return $this;
    }
    /**
     * Get AccountTypeSearchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountTypeSearchType()
    {
        return isset($this->AccountTypeSearchType) ? $this->AccountTypeSearchType : null;
    }
    /**
     * Set AccountTypeSearchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountTypeSearchType
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setAccountTypeSearchType($accountTypeSearchType = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeSearchType) && !is_string($accountTypeSearchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTypeSearchType, true), gettype($accountTypeSearchType)), __LINE__);
        }
        if (is_null($accountTypeSearchType) || (is_array($accountTypeSearchType) && empty($accountTypeSearchType))) {
            unset($this->AccountTypeSearchType);
        } else {
            $this->AccountTypeSearchType = $accountTypeSearchType;
        }
        return $this;
    }
    /**
     * Get AddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine1()
    {
        return isset($this->AddressLine1) ? $this->AddressLine1 : null;
    }
    /**
     * Set AddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine1
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        if (is_null($addressLine1) || (is_array($addressLine1) && empty($addressLine1))) {
            unset($this->AddressLine1);
        } else {
            $this->AddressLine1 = $addressLine1;
        }
        return $this;
    }
    /**
     * Get AddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine2()
    {
        return isset($this->AddressLine2) ? $this->AddressLine2 : null;
    }
    /**
     * Set AddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine2
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        if (is_null($addressLine2) || (is_array($addressLine2) && empty($addressLine2))) {
            unset($this->AddressLine2);
        } else {
            $this->AddressLine2 = $addressLine2;
        }
        return $this;
    }
    /**
     * Get AddressLine3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine3()
    {
        return isset($this->AddressLine3) ? $this->AddressLine3 : null;
    }
    /**
     * Set AddressLine3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine3
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        if (is_null($addressLine3) || (is_array($addressLine3) && empty($addressLine3))) {
            unset($this->AddressLine3);
        } else {
            $this->AddressLine3 = $addressLine3;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityId()
    {
        return isset($this->CityId) ? $this->CityId : null;
    }
    /**
     * Set CityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: string
        if (!is_null($cityId) && !is_string($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cityId, true)), __LINE__);
        }
        if (is_null($cityId) || (is_array($cityId) && empty($cityId))) {
            unset($this->CityId);
        } else {
            $this->CityId = $cityId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get ClientStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientStatus()
    {
        return isset($this->ClientStatus) ? $this->ClientStatus : null;
    }
    /**
     * Set ClientStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientStatusKind::valueIsValid()
     * @uses \patest\EnumType\ClientStatusKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientStatus
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setClientStatus($clientStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientStatusKind::valueIsValid($clientStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientStatusKind', is_array($clientStatus) ? implode(', ', $clientStatus) : var_export($clientStatus, true), implode(', ', \patest\EnumType\ClientStatusKind::getValidValues())), __LINE__);
        }
        if (is_null($clientStatus) || (is_array($clientStatus) && empty($clientStatus))) {
            unset($this->ClientStatus);
        } else {
            $this->ClientStatus = $clientStatus;
        }
        return $this;
    }
    /**
     * Get ClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getClientType()
    {
        return isset($this->ClientType) ? $this->ClientType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClientType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientTypeForArrayConstraintsFromSetClientType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_ExtendedClientFilterClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_ExtendedClientFilterClientTypeItem)) {
                $invalidValues[] = is_object($crm_ExtendedClientFilterClientTypeItem) ? get_class($crm_ExtendedClientFilterClientTypeItem) : sprintf('%s(%s)', gettype($crm_ExtendedClientFilterClientTypeItem), var_export($crm_ExtendedClientFilterClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $clientType
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setClientType(array $clientType = array())
    {
        // validation for constraint: list
        if ('' !== ($clientTypeArrayErrorMessage = self::validateClientTypeForArrayConstraintsFromSetClientType($clientType))) {
            throw new \InvalidArgumentException($clientTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($clientType) || (is_array($clientType) && empty($clientType))) {
            unset($this->ClientType);
        } else {
            $this->ClientType = is_array($clientType) ? implode(' ', $clientType) : null;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get ClientTypeSearchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeSearchType()
    {
        return isset($this->ClientTypeSearchType) ? $this->ClientTypeSearchType : null;
    }
    /**
     * Set ClientTypeSearchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeSearchType
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setClientTypeSearchType($clientTypeSearchType = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeSearchType) && !is_string($clientTypeSearchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeSearchType, true), gettype($clientTypeSearchType)), __LINE__);
        }
        if (is_null($clientTypeSearchType) || (is_array($clientTypeSearchType) && empty($clientTypeSearchType))) {
            unset($this->ClientTypeSearchType);
        } else {
            $this->ClientTypeSearchType = $clientTypeSearchType;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryId()
    {
        return isset($this->CountryId) ? $this->CountryId : null;
    }
    /**
     * Set CountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($countryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($countryId, true)), __LINE__);
        }
        if (is_null($countryId) || (is_array($countryId) && empty($countryId))) {
            unset($this->CountryId);
        } else {
            $this->CountryId = $countryId;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardSuffix()
    {
        return isset($this->CreditCardSuffix) ? $this->CreditCardSuffix : null;
    }
    /**
     * Set CreditCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardSuffix
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setCreditCardSuffix($creditCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardSuffix) && !is_string($creditCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardSuffix, true), gettype($creditCardSuffix)), __LINE__);
        }
        if (is_null($creditCardSuffix) || (is_array($creditCardSuffix) && empty($creditCardSuffix))) {
            unset($this->CreditCardSuffix);
        } else {
            $this->CreditCardSuffix = $creditCardSuffix;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get DateOfBirthFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfBirthFrom()
    {
        return isset($this->DateOfBirthFrom) ? $this->DateOfBirthFrom : null;
    }
    /**
     * Set DateOfBirthFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfBirthFrom
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setDateOfBirthFrom($dateOfBirthFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirthFrom) && !is_string($dateOfBirthFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirthFrom, true), gettype($dateOfBirthFrom)), __LINE__);
        }
        if (is_null($dateOfBirthFrom) || (is_array($dateOfBirthFrom) && empty($dateOfBirthFrom))) {
            unset($this->DateOfBirthFrom);
        } else {
            $this->DateOfBirthFrom = $dateOfBirthFrom;
        }
        return $this;
    }
    /**
     * Get DateOfBirthTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfBirthTo()
    {
        return isset($this->DateOfBirthTo) ? $this->DateOfBirthTo : null;
    }
    /**
     * Set DateOfBirthTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfBirthTo
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setDateOfBirthTo($dateOfBirthTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirthTo) && !is_string($dateOfBirthTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirthTo, true), gettype($dateOfBirthTo)), __LINE__);
        }
        if (is_null($dateOfBirthTo) || (is_array($dateOfBirthTo) && empty($dateOfBirthTo))) {
            unset($this->DateOfBirthTo);
        } else {
            $this->DateOfBirthTo = $dateOfBirthTo;
        }
        return $this;
    }
    /**
     * Get DateTimeField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeField1()
    {
        return isset($this->DateTimeField1) ? $this->DateTimeField1 : null;
    }
    /**
     * Set DateTimeField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeField1
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setDateTimeField1($dateTimeField1 = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField1) && !is_string($dateTimeField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField1, true), gettype($dateTimeField1)), __LINE__);
        }
        if (is_null($dateTimeField1) || (is_array($dateTimeField1) && empty($dateTimeField1))) {
            unset($this->DateTimeField1);
        } else {
            $this->DateTimeField1 = $dateTimeField1;
        }
        return $this;
    }
    /**
     * Get DateTimeField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeField2()
    {
        return isset($this->DateTimeField2) ? $this->DateTimeField2 : null;
    }
    /**
     * Set DateTimeField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeField2
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setDateTimeField2($dateTimeField2 = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField2) && !is_string($dateTimeField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField2, true), gettype($dateTimeField2)), __LINE__);
        }
        if (is_null($dateTimeField2) || (is_array($dateTimeField2) && empty($dateTimeField2))) {
            unset($this->DateTimeField2);
        } else {
            $this->DateTimeField2 = $dateTimeField2;
        }
        return $this;
    }
    /**
     * Get DraftInvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDraftInvoiceNumber()
    {
        return isset($this->DraftInvoiceNumber) ? $this->DraftInvoiceNumber : null;
    }
    /**
     * Set DraftInvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $draftInvoiceNumber
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setDraftInvoiceNumber($draftInvoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($draftInvoiceNumber) && !(is_int($draftInvoiceNumber) || ctype_digit($draftInvoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($draftInvoiceNumber, true), gettype($draftInvoiceNumber)), __LINE__);
        }
        if (is_null($draftInvoiceNumber) || (is_array($draftInvoiceNumber) && empty($draftInvoiceNumber))) {
            unset($this->DraftInvoiceNumber);
        } else {
            $this->DraftInvoiceNumber = $draftInvoiceNumber;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get GlobalStringField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalStringField()
    {
        return isset($this->GlobalStringField) ? $this->GlobalStringField : null;
    }
    /**
     * Set GlobalStringField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalStringField
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setGlobalStringField(\patest\StructType\GlobalString $globalStringField = null)
    {
        if (is_null($globalStringField) || (is_array($globalStringField) && empty($globalStringField))) {
            unset($this->GlobalStringField);
        } else {
            $this->GlobalStringField = $globalStringField;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IdCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCard()
    {
        return isset($this->IdCard) ? $this->IdCard : null;
    }
    /**
     * Set IdCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCard
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setIdCard($idCard = null)
    {
        // validation for constraint: string
        if (!is_null($idCard) && !is_string($idCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idCard, true), gettype($idCard)), __LINE__);
        }
        if (is_null($idCard) || (is_array($idCard) && empty($idCard))) {
            unset($this->IdCard);
        } else {
            $this->IdCard = $idCard;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LastNameFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastNameFilter()
    {
        return isset($this->LastNameFilter) ? $this->LastNameFilter : null;
    }
    /**
     * Set LastNameFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LastnameFilterOperator::valueIsValid()
     * @uses \patest\EnumType\LastnameFilterOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lastNameFilter
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setLastNameFilter($lastNameFilter = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LastnameFilterOperator::valueIsValid($lastNameFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LastnameFilterOperator', is_array($lastNameFilter) ? implode(', ', $lastNameFilter) : var_export($lastNameFilter, true), implode(', ', \patest\EnumType\LastnameFilterOperator::getValidValues())), __LINE__);
        }
        if (is_null($lastNameFilter) || (is_array($lastNameFilter) && empty($lastNameFilter))) {
            unset($this->LastNameFilter);
        } else {
            $this->LastNameFilter = $lastNameFilter;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get RegionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionId()
    {
        return isset($this->RegionId) ? $this->RegionId : null;
    }
    /**
     * Set RegionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($regionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($regionId, true)), __LINE__);
        }
        if (is_null($regionId) || (is_array($regionId) && empty($regionId))) {
            unset($this->RegionId);
        } else {
            $this->RegionId = $regionId;
        }
        return $this;
    }
    /**
     * Get RepIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RepIds|null
     */
    public function getRepIds()
    {
        return isset($this->RepIds) ? $this->RepIds : null;
    }
    /**
     * Set RepIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RepIds $repIds
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setRepIds(\patest\StructType\RepIds $repIds = null)
    {
        if (is_null($repIds) || (is_array($repIds) && empty($repIds))) {
            unset($this->RepIds);
        } else {
            $this->RepIds = $repIds;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SGOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSGOrderId()
    {
        return isset($this->SGOrderId) ? $this->SGOrderId : null;
    }
    /**
     * Set SGOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sGOrderId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setSGOrderId($sGOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sGOrderId) && !is_string($sGOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sGOrderId, true), gettype($sGOrderId)), __LINE__);
        }
        if (is_null($sGOrderId) || (is_array($sGOrderId) && empty($sGOrderId))) {
            unset($this->SGOrderId);
        } else {
            $this->SGOrderId = $sGOrderId;
        }
        return $this;
    }
    /**
     * Get StateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateId()
    {
        return isset($this->StateId) ? $this->StateId : null;
    }
    /**
     * Set StateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: string
        if (!is_null($stateId) && !is_string($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateId, true), gettype($stateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stateId, true)), __LINE__);
        }
        if (is_null($stateId) || (is_array($stateId) && empty($stateId))) {
            unset($this->StateId);
        } else {
            $this->StateId = $stateId;
        }
        return $this;
    }
    /**
     * Get StringField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField1()
    {
        return isset($this->StringField1) ? $this->StringField1 : null;
    }
    /**
     * Set StringField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField1
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField1($stringField1 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField1) && !is_string($stringField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField1, true), gettype($stringField1)), __LINE__);
        }
        if (is_null($stringField1) || (is_array($stringField1) && empty($stringField1))) {
            unset($this->StringField1);
        } else {
            $this->StringField1 = $stringField1;
        }
        return $this;
    }
    /**
     * Get StringField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField2()
    {
        return isset($this->StringField2) ? $this->StringField2 : null;
    }
    /**
     * Set StringField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField2
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField2($stringField2 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField2) && !is_string($stringField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField2, true), gettype($stringField2)), __LINE__);
        }
        if (is_null($stringField2) || (is_array($stringField2) && empty($stringField2))) {
            unset($this->StringField2);
        } else {
            $this->StringField2 = $stringField2;
        }
        return $this;
    }
    /**
     * Get StringField3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField3()
    {
        return isset($this->StringField3) ? $this->StringField3 : null;
    }
    /**
     * Set StringField3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField3
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField3($stringField3 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField3) && !is_string($stringField3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField3, true), gettype($stringField3)), __LINE__);
        }
        if (is_null($stringField3) || (is_array($stringField3) && empty($stringField3))) {
            unset($this->StringField3);
        } else {
            $this->StringField3 = $stringField3;
        }
        return $this;
    }
    /**
     * Get StringField4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField4()
    {
        return isset($this->StringField4) ? $this->StringField4 : null;
    }
    /**
     * Set StringField4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField4
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField4($stringField4 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField4) && !is_string($stringField4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField4, true), gettype($stringField4)), __LINE__);
        }
        if (is_null($stringField4) || (is_array($stringField4) && empty($stringField4))) {
            unset($this->StringField4);
        } else {
            $this->StringField4 = $stringField4;
        }
        return $this;
    }
    /**
     * Get StringField5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField5()
    {
        return isset($this->StringField5) ? $this->StringField5 : null;
    }
    /**
     * Set StringField5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField5
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField5($stringField5 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField5) && !is_string($stringField5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField5, true), gettype($stringField5)), __LINE__);
        }
        if (is_null($stringField5) || (is_array($stringField5) && empty($stringField5))) {
            unset($this->StringField5);
        } else {
            $this->StringField5 = $stringField5;
        }
        return $this;
    }
    /**
     * Get StringField6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField6()
    {
        return isset($this->StringField6) ? $this->StringField6 : null;
    }
    /**
     * Set StringField6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField6
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField6($stringField6 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField6) && !is_string($stringField6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField6, true), gettype($stringField6)), __LINE__);
        }
        if (is_null($stringField6) || (is_array($stringField6) && empty($stringField6))) {
            unset($this->StringField6);
        } else {
            $this->StringField6 = $stringField6;
        }
        return $this;
    }
    /**
     * Get StringField7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField7()
    {
        return isset($this->StringField7) ? $this->StringField7 : null;
    }
    /**
     * Set StringField7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField7
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setStringField7($stringField7 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField7) && !is_string($stringField7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField7, true), gettype($stringField7)), __LINE__);
        }
        if (is_null($stringField7) || (is_array($stringField7) && empty($stringField7))) {
            unset($this->StringField7);
        } else {
            $this->StringField7 = $stringField7;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TicketAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketAreaId()
    {
        return isset($this->TicketAreaId) ? $this->TicketAreaId : null;
    }
    /**
     * Set TicketAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketAreaId
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTicketAreaId($ticketAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketAreaId) && !is_string($ticketAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketAreaId, true), gettype($ticketAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketAreaId, true)), __LINE__);
        }
        if (is_null($ticketAreaId) || (is_array($ticketAreaId) && empty($ticketAreaId))) {
            unset($this->TicketAreaId);
        } else {
            $this->TicketAreaId = $ticketAreaId;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TicketRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketRow()
    {
        return isset($this->TicketRow) ? $this->TicketRow : null;
    }
    /**
     * Set TicketRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketRow
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTicketRow($ticketRow = null)
    {
        // validation for constraint: string
        if (!is_null($ticketRow) && !is_string($ticketRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketRow, true), gettype($ticketRow)), __LINE__);
        }
        if (is_null($ticketRow) || (is_array($ticketRow) && empty($ticketRow))) {
            unset($this->TicketRow);
        } else {
            $this->TicketRow = $ticketRow;
        }
        return $this;
    }
    /**
     * Get TicketSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSeat()
    {
        return isset($this->TicketSeat) ? $this->TicketSeat : null;
    }
    /**
     * Set TicketSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSeat
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTicketSeat($ticketSeat = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSeat) && !is_string($ticketSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSeat, true), gettype($ticketSeat)), __LINE__);
        }
        if (is_null($ticketSeat) || (is_array($ticketSeat) && empty($ticketSeat))) {
            unset($this->TicketSeat);
        } else {
            $this->TicketSeat = $ticketSeat;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransFromDate()
    {
        return isset($this->TransFromDate) ? $this->TransFromDate : null;
    }
    /**
     * Set TransFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transFromDate
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTransFromDate($transFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($transFromDate) && !is_string($transFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transFromDate, true), gettype($transFromDate)), __LINE__);
        }
        if (is_null($transFromDate) || (is_array($transFromDate) && empty($transFromDate))) {
            unset($this->TransFromDate);
        } else {
            $this->TransFromDate = $transFromDate;
        }
        return $this;
    }
    /**
     * Get TransToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransToDate()
    {
        return isset($this->TransToDate) ? $this->TransToDate : null;
    }
    /**
     * Set TransToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transToDate
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setTransToDate($transToDate = null)
    {
        // validation for constraint: string
        if (!is_null($transToDate) && !is_string($transToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transToDate, true), gettype($transToDate)), __LINE__);
        }
        if (is_null($transToDate) || (is_array($transToDate) && empty($transToDate))) {
            unset($this->TransToDate);
        } else {
            $this->TransToDate = $transToDate;
        }
        return $this;
    }
    /**
     * Get VATRegistrationNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVATRegistrationNo()
    {
        return isset($this->VATRegistrationNo) ? $this->VATRegistrationNo : null;
    }
    /**
     * Set VATRegistrationNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vATRegistrationNo
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setVATRegistrationNo($vATRegistrationNo = null)
    {
        // validation for constraint: string
        if (!is_null($vATRegistrationNo) && !is_string($vATRegistrationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vATRegistrationNo, true), gettype($vATRegistrationNo)), __LINE__);
        }
        if (is_null($vATRegistrationNo) || (is_array($vATRegistrationNo) && empty($vATRegistrationNo))) {
            unset($this->VATRegistrationNo);
        } else {
            $this->VATRegistrationNo = $vATRegistrationNo;
        }
        return $this;
    }
    /**
     * Get WorkPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPlace()
    {
        return isset($this->WorkPlace) ? $this->WorkPlace : null;
    }
    /**
     * Set WorkPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPlace
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setWorkPlace($workPlace = null)
    {
        // validation for constraint: string
        if (!is_null($workPlace) && !is_string($workPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPlace, true), gettype($workPlace)), __LINE__);
        }
        if (is_null($workPlace) || (is_array($workPlace) && empty($workPlace))) {
            unset($this->WorkPlace);
        } else {
            $this->WorkPlace = $workPlace;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \patest\StructType\Crm_ExtendedClientFilter
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
}
