<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.DuplicationCheckRule StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm.DuplicationCheckRule
 * @subpackage Structs
 */
class Crm_DuplicationCheckRule extends DistributableEntity
{
    /**
     * The CrmClientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CrmClientType;
    /**
     * The RuleRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_DuplicationCheckRuleRecord
     */
    public $RuleRecords;
    /**
     * The RuleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleType;
    /**
     * Constructor method for Crm.DuplicationCheckRule
     * @uses Crm_DuplicationCheckRule::setCrmClientType()
     * @uses Crm_DuplicationCheckRule::setRuleRecords()
     * @uses Crm_DuplicationCheckRule::setRuleType()
     * @param string[] $crmClientType
     * @param \patest\StructType\RecordSetOfCrm_DuplicationCheckRuleRecord $ruleRecords
     * @param string $ruleType
     */
    public function __construct(array $crmClientType = array(), \patest\StructType\RecordSetOfCrm_DuplicationCheckRuleRecord $ruleRecords = null, $ruleType = null)
    {
        $this
            ->setCrmClientType($crmClientType)
            ->setRuleRecords($ruleRecords)
            ->setRuleType($ruleType);
    }
    /**
     * Get CrmClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCrmClientType()
    {
        return isset($this->CrmClientType) ? $this->CrmClientType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCrmClientType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCrmClientType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCrmClientTypeForArrayConstraintsFromSetCrmClientType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_DuplicationCheckRuleCrmClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_DuplicationCheckRuleCrmClientTypeItem)) {
                $invalidValues[] = is_object($crm_DuplicationCheckRuleCrmClientTypeItem) ? get_class($crm_DuplicationCheckRuleCrmClientTypeItem) : sprintf('%s(%s)', gettype($crm_DuplicationCheckRuleCrmClientTypeItem), var_export($crm_DuplicationCheckRuleCrmClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CrmClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $crmClientType
     * @return \patest\StructType\Crm_DuplicationCheckRule
     */
    public function setCrmClientType(array $crmClientType = array())
    {
        // validation for constraint: list
        if ('' !== ($crmClientTypeArrayErrorMessage = self::validateCrmClientTypeForArrayConstraintsFromSetCrmClientType($crmClientType))) {
            throw new \InvalidArgumentException($crmClientTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($crmClientType) || (is_array($crmClientType) && empty($crmClientType))) {
            unset($this->CrmClientType);
        } else {
            $this->CrmClientType = is_array($crmClientType) ? implode(' ', $crmClientType) : null;
        }
        return $this;
    }
    /**
     * Get RuleRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_DuplicationCheckRuleRecord|null
     */
    public function getRuleRecords()
    {
        return isset($this->RuleRecords) ? $this->RuleRecords : null;
    }
    /**
     * Set RuleRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_DuplicationCheckRuleRecord $ruleRecords
     * @return \patest\StructType\Crm_DuplicationCheckRule
     */
    public function setRuleRecords(\patest\StructType\RecordSetOfCrm_DuplicationCheckRuleRecord $ruleRecords = null)
    {
        if (is_null($ruleRecords) || (is_array($ruleRecords) && empty($ruleRecords))) {
            unset($this->RuleRecords);
        } else {
            $this->RuleRecords = $ruleRecords;
        }
        return $this;
    }
    /**
     * Get RuleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleType()
    {
        return isset($this->RuleType) ? $this->RuleType : null;
    }
    /**
     * Set RuleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DuplicationCheckRuleKind::valueIsValid()
     * @uses \patest\EnumType\DuplicationCheckRuleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ruleType
     * @return \patest\StructType\Crm_DuplicationCheckRule
     */
    public function setRuleType($ruleType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DuplicationCheckRuleKind::valueIsValid($ruleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DuplicationCheckRuleKind', is_array($ruleType) ? implode(', ', $ruleType) : var_export($ruleType, true), implode(', ', \patest\EnumType\DuplicationCheckRuleKind::getValidValues())), __LINE__);
        }
        if (is_null($ruleType) || (is_array($ruleType) && empty($ruleType))) {
            unset($this->RuleType);
        } else {
            $this->RuleType = $ruleType;
        }
        return $this;
    }
}
