<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.DuplicationCheckLengthParameter StructType
 * @subpackage Structs
 */
class Crm_DuplicationCheckLengthParameter extends DistributableEntity
{
    /**
     * The FieldSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldSystemName;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Length;
    /**
     * Constructor method for Crm.DuplicationCheckLengthParameter
     * @uses Crm_DuplicationCheckLengthParameter::setFieldSystemName()
     * @uses Crm_DuplicationCheckLengthParameter::setLength()
     * @param string $fieldSystemName
     * @param int $length
     */
    public function __construct($fieldSystemName = null, $length = null)
    {
        $this
            ->setFieldSystemName($fieldSystemName)
            ->setLength($length);
    }
    /**
     * Get FieldSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldSystemName()
    {
        return isset($this->FieldSystemName) ? $this->FieldSystemName : null;
    }
    /**
     * Set FieldSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldSystemName
     * @return \patest\StructType\Crm_DuplicationCheckLengthParameter
     */
    public function setFieldSystemName($fieldSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldSystemName) && !is_string($fieldSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldSystemName, true), gettype($fieldSystemName)), __LINE__);
        }
        if (is_null($fieldSystemName) || (is_array($fieldSystemName) && empty($fieldSystemName))) {
            unset($this->FieldSystemName);
        } else {
            $this->FieldSystemName = $fieldSystemName;
        }
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $length
     * @return \patest\StructType\Crm_DuplicationCheckLengthParameter
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
}
