<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.DataProtectionDetail StructType
 * @subpackage Structs
 */
class Crm_DataProtectionDetail extends DistributableEntity
{
    /**
     * The Answer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Answer;
    /**
     * The AnsweredDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnsweredDate;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DataProtectionQuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataProtectionQuestionId;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The IsDynamic
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDynamic;
    /**
     * The MapToCrmSyncEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MapToCrmSyncEntity;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * Constructor method for Crm.DataProtectionDetail
     * @uses Crm_DataProtectionDetail::setAnswer()
     * @uses Crm_DataProtectionDetail::setAnsweredDate()
     * @uses Crm_DataProtectionDetail::setClientId()
     * @uses Crm_DataProtectionDetail::setDataProtectionQuestionId()
     * @uses Crm_DataProtectionDetail::setExpirationDate()
     * @uses Crm_DataProtectionDetail::setIsDynamic()
     * @uses Crm_DataProtectionDetail::setMapToCrmSyncEntity()
     * @uses Crm_DataProtectionDetail::setOrganizationUnitId()
     * @param string $answer
     * @param string $answeredDate
     * @param string $clientId
     * @param string $dataProtectionQuestionId
     * @param string $expirationDate
     * @param bool $isDynamic
     * @param int $mapToCrmSyncEntity
     * @param string $organizationUnitId
     */
    public function __construct($answer = null, $answeredDate = null, $clientId = null, $dataProtectionQuestionId = null, $expirationDate = null, $isDynamic = null, $mapToCrmSyncEntity = null, $organizationUnitId = null)
    {
        $this
            ->setAnswer($answer)
            ->setAnsweredDate($answeredDate)
            ->setClientId($clientId)
            ->setDataProtectionQuestionId($dataProtectionQuestionId)
            ->setExpirationDate($expirationDate)
            ->setIsDynamic($isDynamic)
            ->setMapToCrmSyncEntity($mapToCrmSyncEntity)
            ->setOrganizationUnitId($organizationUnitId);
    }
    /**
     * Get Answer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnswer()
    {
        return isset($this->Answer) ? $this->Answer : null;
    }
    /**
     * Set Answer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DataProtectionAnswerKind::valueIsValid()
     * @uses \patest\EnumType\DataProtectionAnswerKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answer
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DataProtectionAnswerKind::valueIsValid($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DataProtectionAnswerKind', is_array($answer) ? implode(', ', $answer) : var_export($answer, true), implode(', ', \patest\EnumType\DataProtectionAnswerKind::getValidValues())), __LINE__);
        }
        if (is_null($answer) || (is_array($answer) && empty($answer))) {
            unset($this->Answer);
        } else {
            $this->Answer = $answer;
        }
        return $this;
    }
    /**
     * Get AnsweredDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnsweredDate()
    {
        return isset($this->AnsweredDate) ? $this->AnsweredDate : null;
    }
    /**
     * Set AnsweredDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $answeredDate
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setAnsweredDate($answeredDate = null)
    {
        // validation for constraint: string
        if (!is_null($answeredDate) && !is_string($answeredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answeredDate, true), gettype($answeredDate)), __LINE__);
        }
        if (is_null($answeredDate) || (is_array($answeredDate) && empty($answeredDate))) {
            unset($this->AnsweredDate);
        } else {
            $this->AnsweredDate = $answeredDate;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DataProtectionQuestionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtectionQuestionId()
    {
        return isset($this->DataProtectionQuestionId) ? $this->DataProtectionQuestionId : null;
    }
    /**
     * Set DataProtectionQuestionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtectionQuestionId
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setDataProtectionQuestionId($dataProtectionQuestionId = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtectionQuestionId) && !is_string($dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtectionQuestionId, true), gettype($dataProtectionQuestionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataProtectionQuestionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataProtectionQuestionId, true)), __LINE__);
        }
        if (is_null($dataProtectionQuestionId) || (is_array($dataProtectionQuestionId) && empty($dataProtectionQuestionId))) {
            unset($this->DataProtectionQuestionId);
        } else {
            $this->DataProtectionQuestionId = $dataProtectionQuestionId;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get IsDynamic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDynamic()
    {
        return isset($this->IsDynamic) ? $this->IsDynamic : null;
    }
    /**
     * Set IsDynamic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDynamic
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setIsDynamic($isDynamic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDynamic) && !is_bool($isDynamic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDynamic, true), gettype($isDynamic)), __LINE__);
        }
        if (is_null($isDynamic) || (is_array($isDynamic) && empty($isDynamic))) {
            unset($this->IsDynamic);
        } else {
            $this->IsDynamic = $isDynamic;
        }
        return $this;
    }
    /**
     * Get MapToCrmSyncEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMapToCrmSyncEntity()
    {
        return isset($this->MapToCrmSyncEntity) ? $this->MapToCrmSyncEntity : null;
    }
    /**
     * Set MapToCrmSyncEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mapToCrmSyncEntity
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setMapToCrmSyncEntity($mapToCrmSyncEntity = null)
    {
        // validation for constraint: int
        if (!is_null($mapToCrmSyncEntity) && !(is_int($mapToCrmSyncEntity) || ctype_digit($mapToCrmSyncEntity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mapToCrmSyncEntity, true), gettype($mapToCrmSyncEntity)), __LINE__);
        }
        if (is_null($mapToCrmSyncEntity) || (is_array($mapToCrmSyncEntity) && empty($mapToCrmSyncEntity))) {
            unset($this->MapToCrmSyncEntity);
        } else {
            $this->MapToCrmSyncEntity = $mapToCrmSyncEntity;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_DataProtectionDetail
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
}
