<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientSummaryData StructType
 * @subpackage Structs
 */
class Crm_ClientSummaryData extends AnyEntity
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The ClientImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientImageUrl;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The OrderedPhones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderedPhones;
    /**
     * The RelatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedClients;
    /**
     * The Types
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Types;
    /**
     * Constructor method for Crm.ClientSummaryData
     * @uses Crm_ClientSummaryData::setAddress()
     * @uses Crm_ClientSummaryData::setClientImageUrl()
     * @uses Crm_ClientSummaryData::setDisplayName()
     * @uses Crm_ClientSummaryData::setEmail()
     * @uses Crm_ClientSummaryData::setId()
     * @uses Crm_ClientSummaryData::setIsSelected()
     * @uses Crm_ClientSummaryData::setOrderedPhones()
     * @uses Crm_ClientSummaryData::setRelatedClients()
     * @uses Crm_ClientSummaryData::setTypes()
     * @param string $address
     * @param string $clientImageUrl
     * @param string $displayName
     * @param string $email
     * @param string $id
     * @param bool $isSelected
     * @param string $orderedPhones
     * @param string $relatedClients
     * @param string $types
     */
    public function __construct($address = null, $clientImageUrl = null, $displayName = null, $email = null, $id = null, $isSelected = null, $orderedPhones = null, $relatedClients = null, $types = null)
    {
        $this
            ->setAddress($address)
            ->setClientImageUrl($clientImageUrl)
            ->setDisplayName($displayName)
            ->setEmail($email)
            ->setId($id)
            ->setIsSelected($isSelected)
            ->setOrderedPhones($orderedPhones)
            ->setRelatedClients($relatedClients)
            ->setTypes($types);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get ClientImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientImageUrl()
    {
        return isset($this->ClientImageUrl) ? $this->ClientImageUrl : null;
    }
    /**
     * Set ClientImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientImageUrl
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setClientImageUrl($clientImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($clientImageUrl) && !is_string($clientImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientImageUrl, true), gettype($clientImageUrl)), __LINE__);
        }
        if (is_null($clientImageUrl) || (is_array($clientImageUrl) && empty($clientImageUrl))) {
            unset($this->ClientImageUrl);
        } else {
            $this->ClientImageUrl = $clientImageUrl;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get OrderedPhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderedPhones()
    {
        return isset($this->OrderedPhones) ? $this->OrderedPhones : null;
    }
    /**
     * Set OrderedPhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderedPhones
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setOrderedPhones($orderedPhones = null)
    {
        // validation for constraint: string
        if (!is_null($orderedPhones) && !is_string($orderedPhones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderedPhones, true), gettype($orderedPhones)), __LINE__);
        }
        if (is_null($orderedPhones) || (is_array($orderedPhones) && empty($orderedPhones))) {
            unset($this->OrderedPhones);
        } else {
            $this->OrderedPhones = $orderedPhones;
        }
        return $this;
    }
    /**
     * Get RelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedClients()
    {
        return isset($this->RelatedClients) ? $this->RelatedClients : null;
    }
    /**
     * Set RelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedClients
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setRelatedClients($relatedClients = null)
    {
        // validation for constraint: string
        if (!is_null($relatedClients) && !is_string($relatedClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedClients, true), gettype($relatedClients)), __LINE__);
        }
        if (is_null($relatedClients) || (is_array($relatedClients) && empty($relatedClients))) {
            unset($this->RelatedClients);
        } else {
            $this->RelatedClients = $relatedClients;
        }
        return $this;
    }
    /**
     * Get Types value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypes()
    {
        return isset($this->Types) ? $this->Types : null;
    }
    /**
     * Set Types value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $types
     * @return \patest\StructType\Crm_ClientSummaryData
     */
    public function setTypes($types = null)
    {
        // validation for constraint: string
        if (!is_null($types) && !is_string($types)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($types, true), gettype($types)), __LINE__);
        }
        if (is_null($types) || (is_array($types) && empty($types))) {
            unset($this->Types);
        } else {
            $this->Types = $types;
        }
        return $this;
    }
}
