<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientStatusDetail StructType
 * @subpackage Structs
 */
class Crm_ClientStatusDetail extends AnyEntity
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The RemoveDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RemoveDateTime;
    /**
     * The RemoveNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RemoveNote;
    /**
     * The RemoverId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RemoverId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_UserAudit
     */
    public $User;
    /**
     * Constructor method for Crm.ClientStatusDetail
     * @uses Crm_ClientStatusDetail::setDateTime()
     * @uses Crm_ClientStatusDetail::setRemoveDateTime()
     * @uses Crm_ClientStatusDetail::setRemoveNote()
     * @uses Crm_ClientStatusDetail::setRemoverId()
     * @uses Crm_ClientStatusDetail::setStatus()
     * @uses Crm_ClientStatusDetail::setUser()
     * @param string $dateTime
     * @param string $removeDateTime
     * @param string $removeNote
     * @param string $removerId
     * @param string $status
     * @param \patest\StructType\Crm_UserAudit $user
     */
    public function __construct($dateTime = null, $removeDateTime = null, $removeNote = null, $removerId = null, $status = null, \patest\StructType\Crm_UserAudit $user = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setRemoveDateTime($removeDateTime)
            ->setRemoveNote($removeNote)
            ->setRemoverId($removerId)
            ->setStatus($status)
            ->setUser($user);
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Crm_ClientStatusDetail
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get RemoveDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemoveDateTime()
    {
        return isset($this->RemoveDateTime) ? $this->RemoveDateTime : null;
    }
    /**
     * Set RemoveDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $removeDateTime
     * @return \patest\StructType\Crm_ClientStatusDetail
     */
    public function setRemoveDateTime($removeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($removeDateTime) && !is_string($removeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($removeDateTime, true), gettype($removeDateTime)), __LINE__);
        }
        if (is_null($removeDateTime) || (is_array($removeDateTime) && empty($removeDateTime))) {
            unset($this->RemoveDateTime);
        } else {
            $this->RemoveDateTime = $removeDateTime;
        }
        return $this;
    }
    /**
     * Get RemoveNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemoveNote()
    {
        return isset($this->RemoveNote) ? $this->RemoveNote : null;
    }
    /**
     * Set RemoveNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $removeNote
     * @return \patest\StructType\Crm_ClientStatusDetail
     */
    public function setRemoveNote($removeNote = null)
    {
        // validation for constraint: string
        if (!is_null($removeNote) && !is_string($removeNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($removeNote, true), gettype($removeNote)), __LINE__);
        }
        if (is_null($removeNote) || (is_array($removeNote) && empty($removeNote))) {
            unset($this->RemoveNote);
        } else {
            $this->RemoveNote = $removeNote;
        }
        return $this;
    }
    /**
     * Get RemoverId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemoverId()
    {
        return isset($this->RemoverId) ? $this->RemoverId : null;
    }
    /**
     * Set RemoverId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $removerId
     * @return \patest\StructType\Crm_ClientStatusDetail
     */
    public function setRemoverId($removerId = null)
    {
        // validation for constraint: string
        if (!is_null($removerId) && !is_string($removerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($removerId, true), gettype($removerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($removerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $removerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($removerId, true)), __LINE__);
        }
        if (is_null($removerId) || (is_array($removerId) && empty($removerId))) {
            unset($this->RemoverId);
        } else {
            $this->RemoverId = $removerId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientStatusKind::valueIsValid()
     * @uses \patest\EnumType\ClientStatusKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Crm_ClientStatusDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientStatusKind::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientStatusKind', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ClientStatusKind::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_UserAudit|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_UserAudit $user
     * @return \patest\StructType\Crm_ClientStatusDetail
     */
    public function setUser(\patest\StructType\Crm_UserAudit $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
}
