<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientFilter StructType
 * @subpackage Structs
 */
class Crm_ClientFilter extends FilterEntity
{
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The BulkOperationExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BulkOperationExternalId;
    /**
     * The CityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CityId;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypes
     */
    public $ClientTypes;
    /**
     * The ClientTypeSearchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypeSearchType;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CountryId;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The DateTimeField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeField1;
    /**
     * The DateTimeField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeField2;
    /**
     * The DoubleField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DoubleField1;
    /**
     * The DoubleField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DoubleField2;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The GlobalStringField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalStringField;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginName;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RegionId;
    /**
     * The SalesReps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SalesReps
     */
    public $SalesReps;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesSeasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesSeasonality;
    /**
     * The SeriesSeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesSeasonId;
    /**
     * The ShowAlsoSubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowAlsoSubordinates;
    /**
     * The StateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StateId;
    /**
     * The StringField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField1;
    /**
     * The StringField10
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField10;
    /**
     * The StringField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField2;
    /**
     * The StringField3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField3;
    /**
     * The StringField4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField4;
    /**
     * The StringField5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField5;
    /**
     * The StringField6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField6;
    /**
     * The StringField7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField7;
    /**
     * The StringField8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField8;
    /**
     * The StringField9
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField9;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for Crm.ClientFilter
     * @uses Crm_ClientFilter::setAddressLine1()
     * @uses Crm_ClientFilter::setAddressLine2()
     * @uses Crm_ClientFilter::setAddressLine3()
     * @uses Crm_ClientFilter::setBulkOperationExternalId()
     * @uses Crm_ClientFilter::setCityId()
     * @uses Crm_ClientFilter::setClientTypes()
     * @uses Crm_ClientFilter::setClientTypeSearchType()
     * @uses Crm_ClientFilter::setCountryId()
     * @uses Crm_ClientFilter::setCrmId()
     * @uses Crm_ClientFilter::setDateTimeField1()
     * @uses Crm_ClientFilter::setDateTimeField2()
     * @uses Crm_ClientFilter::setDoubleField1()
     * @uses Crm_ClientFilter::setDoubleField2()
     * @uses Crm_ClientFilter::setEmailAddress()
     * @uses Crm_ClientFilter::setGlobalStringField()
     * @uses Crm_ClientFilter::setIsActive()
     * @uses Crm_ClientFilter::setIsHidden()
     * @uses Crm_ClientFilter::setLoginName()
     * @uses Crm_ClientFilter::setNote()
     * @uses Crm_ClientFilter::setPhone()
     * @uses Crm_ClientFilter::setQueryId()
     * @uses Crm_ClientFilter::setRegionId()
     * @uses Crm_ClientFilter::setSalesReps()
     * @uses Crm_ClientFilter::setSeriesId()
     * @uses Crm_ClientFilter::setSeriesSeasonality()
     * @uses Crm_ClientFilter::setSeriesSeasonId()
     * @uses Crm_ClientFilter::setShowAlsoSubordinates()
     * @uses Crm_ClientFilter::setStateId()
     * @uses Crm_ClientFilter::setStringField1()
     * @uses Crm_ClientFilter::setStringField10()
     * @uses Crm_ClientFilter::setStringField2()
     * @uses Crm_ClientFilter::setStringField3()
     * @uses Crm_ClientFilter::setStringField4()
     * @uses Crm_ClientFilter::setStringField5()
     * @uses Crm_ClientFilter::setStringField6()
     * @uses Crm_ClientFilter::setStringField7()
     * @uses Crm_ClientFilter::setStringField8()
     * @uses Crm_ClientFilter::setStringField9()
     * @uses Crm_ClientFilter::setTransactionNumber()
     * @uses Crm_ClientFilter::setZipCode()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $bulkOperationExternalId
     * @param string $cityId
     * @param \patest\StructType\ClientTypes $clientTypes
     * @param string $clientTypeSearchType
     * @param string $countryId
     * @param string $crmId
     * @param string $dateTimeField1
     * @param string $dateTimeField2
     * @param float $doubleField1
     * @param float $doubleField2
     * @param string $emailAddress
     * @param \patest\StructType\GlobalString $globalStringField
     * @param bool $isActive
     * @param bool $isHidden
     * @param string $loginName
     * @param string $note
     * @param string $phone
     * @param string $queryId
     * @param string $regionId
     * @param \patest\StructType\SalesReps $salesReps
     * @param string $seriesId
     * @param string $seriesSeasonality
     * @param string $seriesSeasonId
     * @param bool $showAlsoSubordinates
     * @param string $stateId
     * @param string $stringField1
     * @param string $stringField10
     * @param string $stringField2
     * @param string $stringField3
     * @param string $stringField4
     * @param string $stringField5
     * @param string $stringField6
     * @param string $stringField7
     * @param string $stringField8
     * @param string $stringField9
     * @param int $transactionNumber
     * @param string $zipCode
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $bulkOperationExternalId = null, $cityId = null, \patest\StructType\ClientTypes $clientTypes = null, $clientTypeSearchType = null, $countryId = null, $crmId = null, $dateTimeField1 = null, $dateTimeField2 = null, $doubleField1 = null, $doubleField2 = null, $emailAddress = null, \patest\StructType\GlobalString $globalStringField = null, $isActive = null, $isHidden = null, $loginName = null, $note = null, $phone = null, $queryId = null, $regionId = null, \patest\StructType\SalesReps $salesReps = null, $seriesId = null, $seriesSeasonality = null, $seriesSeasonId = null, $showAlsoSubordinates = null, $stateId = null, $stringField1 = null, $stringField10 = null, $stringField2 = null, $stringField3 = null, $stringField4 = null, $stringField5 = null, $stringField6 = null, $stringField7 = null, $stringField8 = null, $stringField9 = null, $transactionNumber = null, $zipCode = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setBulkOperationExternalId($bulkOperationExternalId)
            ->setCityId($cityId)
            ->setClientTypes($clientTypes)
            ->setClientTypeSearchType($clientTypeSearchType)
            ->setCountryId($countryId)
            ->setCrmId($crmId)
            ->setDateTimeField1($dateTimeField1)
            ->setDateTimeField2($dateTimeField2)
            ->setDoubleField1($doubleField1)
            ->setDoubleField2($doubleField2)
            ->setEmailAddress($emailAddress)
            ->setGlobalStringField($globalStringField)
            ->setIsActive($isActive)
            ->setIsHidden($isHidden)
            ->setLoginName($loginName)
            ->setNote($note)
            ->setPhone($phone)
            ->setQueryId($queryId)
            ->setRegionId($regionId)
            ->setSalesReps($salesReps)
            ->setSeriesId($seriesId)
            ->setSeriesSeasonality($seriesSeasonality)
            ->setSeriesSeasonId($seriesSeasonId)
            ->setShowAlsoSubordinates($showAlsoSubordinates)
            ->setStateId($stateId)
            ->setStringField1($stringField1)
            ->setStringField10($stringField10)
            ->setStringField2($stringField2)
            ->setStringField3($stringField3)
            ->setStringField4($stringField4)
            ->setStringField5($stringField5)
            ->setStringField6($stringField6)
            ->setStringField7($stringField7)
            ->setStringField8($stringField8)
            ->setStringField9($stringField9)
            ->setTransactionNumber($transactionNumber)
            ->setZipCode($zipCode);
    }
    /**
     * Get AddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine1()
    {
        return isset($this->AddressLine1) ? $this->AddressLine1 : null;
    }
    /**
     * Set AddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine1
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        if (is_null($addressLine1) || (is_array($addressLine1) && empty($addressLine1))) {
            unset($this->AddressLine1);
        } else {
            $this->AddressLine1 = $addressLine1;
        }
        return $this;
    }
    /**
     * Get AddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine2()
    {
        return isset($this->AddressLine2) ? $this->AddressLine2 : null;
    }
    /**
     * Set AddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine2
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        if (is_null($addressLine2) || (is_array($addressLine2) && empty($addressLine2))) {
            unset($this->AddressLine2);
        } else {
            $this->AddressLine2 = $addressLine2;
        }
        return $this;
    }
    /**
     * Get AddressLine3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine3()
    {
        return isset($this->AddressLine3) ? $this->AddressLine3 : null;
    }
    /**
     * Set AddressLine3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine3
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        if (is_null($addressLine3) || (is_array($addressLine3) && empty($addressLine3))) {
            unset($this->AddressLine3);
        } else {
            $this->AddressLine3 = $addressLine3;
        }
        return $this;
    }
    /**
     * Get BulkOperationExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBulkOperationExternalId()
    {
        return isset($this->BulkOperationExternalId) ? $this->BulkOperationExternalId : null;
    }
    /**
     * Set BulkOperationExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bulkOperationExternalId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setBulkOperationExternalId($bulkOperationExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($bulkOperationExternalId) && !is_string($bulkOperationExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkOperationExternalId, true), gettype($bulkOperationExternalId)), __LINE__);
        }
        if (is_null($bulkOperationExternalId) || (is_array($bulkOperationExternalId) && empty($bulkOperationExternalId))) {
            unset($this->BulkOperationExternalId);
        } else {
            $this->BulkOperationExternalId = $bulkOperationExternalId;
        }
        return $this;
    }
    /**
     * Get CityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityId()
    {
        return isset($this->CityId) ? $this->CityId : null;
    }
    /**
     * Set CityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: string
        if (!is_null($cityId) && !is_string($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cityId, true)), __LINE__);
        }
        if (is_null($cityId) || (is_array($cityId) && empty($cityId))) {
            unset($this->CityId);
        } else {
            $this->CityId = $cityId;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypes|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypes $clientTypes
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setClientTypes(\patest\StructType\ClientTypes $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get ClientTypeSearchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeSearchType()
    {
        return isset($this->ClientTypeSearchType) ? $this->ClientTypeSearchType : null;
    }
    /**
     * Set ClientTypeSearchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeSearchType
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setClientTypeSearchType($clientTypeSearchType = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeSearchType) && !is_string($clientTypeSearchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeSearchType, true), gettype($clientTypeSearchType)), __LINE__);
        }
        if (is_null($clientTypeSearchType) || (is_array($clientTypeSearchType) && empty($clientTypeSearchType))) {
            unset($this->ClientTypeSearchType);
        } else {
            $this->ClientTypeSearchType = $clientTypeSearchType;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryId()
    {
        return isset($this->CountryId) ? $this->CountryId : null;
    }
    /**
     * Set CountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($countryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($countryId, true)), __LINE__);
        }
        if (is_null($countryId) || (is_array($countryId) && empty($countryId))) {
            unset($this->CountryId);
        } else {
            $this->CountryId = $countryId;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get DateTimeField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeField1()
    {
        return isset($this->DateTimeField1) ? $this->DateTimeField1 : null;
    }
    /**
     * Set DateTimeField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeField1
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setDateTimeField1($dateTimeField1 = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField1) && !is_string($dateTimeField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField1, true), gettype($dateTimeField1)), __LINE__);
        }
        if (is_null($dateTimeField1) || (is_array($dateTimeField1) && empty($dateTimeField1))) {
            unset($this->DateTimeField1);
        } else {
            $this->DateTimeField1 = $dateTimeField1;
        }
        return $this;
    }
    /**
     * Get DateTimeField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeField2()
    {
        return isset($this->DateTimeField2) ? $this->DateTimeField2 : null;
    }
    /**
     * Set DateTimeField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeField2
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setDateTimeField2($dateTimeField2 = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField2) && !is_string($dateTimeField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField2, true), gettype($dateTimeField2)), __LINE__);
        }
        if (is_null($dateTimeField2) || (is_array($dateTimeField2) && empty($dateTimeField2))) {
            unset($this->DateTimeField2);
        } else {
            $this->DateTimeField2 = $dateTimeField2;
        }
        return $this;
    }
    /**
     * Get DoubleField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDoubleField1()
    {
        return isset($this->DoubleField1) ? $this->DoubleField1 : null;
    }
    /**
     * Set DoubleField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $doubleField1
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setDoubleField1($doubleField1 = null)
    {
        // validation for constraint: float
        if (!is_null($doubleField1) && !(is_float($doubleField1) || is_numeric($doubleField1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($doubleField1, true), gettype($doubleField1)), __LINE__);
        }
        if (is_null($doubleField1) || (is_array($doubleField1) && empty($doubleField1))) {
            unset($this->DoubleField1);
        } else {
            $this->DoubleField1 = $doubleField1;
        }
        return $this;
    }
    /**
     * Get DoubleField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDoubleField2()
    {
        return isset($this->DoubleField2) ? $this->DoubleField2 : null;
    }
    /**
     * Set DoubleField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $doubleField2
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setDoubleField2($doubleField2 = null)
    {
        // validation for constraint: float
        if (!is_null($doubleField2) && !(is_float($doubleField2) || is_numeric($doubleField2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($doubleField2, true), gettype($doubleField2)), __LINE__);
        }
        if (is_null($doubleField2) || (is_array($doubleField2) && empty($doubleField2))) {
            unset($this->DoubleField2);
        } else {
            $this->DoubleField2 = $doubleField2;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get GlobalStringField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalStringField()
    {
        return isset($this->GlobalStringField) ? $this->GlobalStringField : null;
    }
    /**
     * Set GlobalStringField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalStringField
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setGlobalStringField(\patest\StructType\GlobalString $globalStringField = null)
    {
        if (is_null($globalStringField) || (is_array($globalStringField) && empty($globalStringField))) {
            unset($this->GlobalStringField);
        } else {
            $this->GlobalStringField = $globalStringField;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get LoginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->LoginName) ? $this->LoginName : null;
    }
    /**
     * Set LoginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->LoginName);
        } else {
            $this->LoginName = $loginName;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get RegionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionId()
    {
        return isset($this->RegionId) ? $this->RegionId : null;
    }
    /**
     * Set RegionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($regionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($regionId, true)), __LINE__);
        }
        if (is_null($regionId) || (is_array($regionId) && empty($regionId))) {
            unset($this->RegionId);
        } else {
            $this->RegionId = $regionId;
        }
        return $this;
    }
    /**
     * Get SalesReps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SalesReps|null
     */
    public function getSalesReps()
    {
        return isset($this->SalesReps) ? $this->SalesReps : null;
    }
    /**
     * Set SalesReps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SalesReps $salesReps
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setSalesReps(\patest\StructType\SalesReps $salesReps = null)
    {
        if (is_null($salesReps) || (is_array($salesReps) && empty($salesReps))) {
            unset($this->SalesReps);
        } else {
            $this->SalesReps = $salesReps;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesSeasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesSeasonality()
    {
        return isset($this->SeriesSeasonality) ? $this->SeriesSeasonality : null;
    }
    /**
     * Set SeriesSeasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seriesSeasonality
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setSeriesSeasonality($seriesSeasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seriesSeasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seriesSeasonality) ? implode(', ', $seriesSeasonality) : var_export($seriesSeasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seriesSeasonality) || (is_array($seriesSeasonality) && empty($seriesSeasonality))) {
            unset($this->SeriesSeasonality);
        } else {
            $this->SeriesSeasonality = $seriesSeasonality;
        }
        return $this;
    }
    /**
     * Get SeriesSeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesSeasonId()
    {
        return isset($this->SeriesSeasonId) ? $this->SeriesSeasonId : null;
    }
    /**
     * Set SeriesSeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesSeasonId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setSeriesSeasonId($seriesSeasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesSeasonId) && !is_string($seriesSeasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesSeasonId, true), gettype($seriesSeasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesSeasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesSeasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesSeasonId, true)), __LINE__);
        }
        if (is_null($seriesSeasonId) || (is_array($seriesSeasonId) && empty($seriesSeasonId))) {
            unset($this->SeriesSeasonId);
        } else {
            $this->SeriesSeasonId = $seriesSeasonId;
        }
        return $this;
    }
    /**
     * Get ShowAlsoSubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowAlsoSubordinates()
    {
        return isset($this->ShowAlsoSubordinates) ? $this->ShowAlsoSubordinates : null;
    }
    /**
     * Set ShowAlsoSubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showAlsoSubordinates
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setShowAlsoSubordinates($showAlsoSubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAlsoSubordinates) && !is_bool($showAlsoSubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAlsoSubordinates, true), gettype($showAlsoSubordinates)), __LINE__);
        }
        if (is_null($showAlsoSubordinates) || (is_array($showAlsoSubordinates) && empty($showAlsoSubordinates))) {
            unset($this->ShowAlsoSubordinates);
        } else {
            $this->ShowAlsoSubordinates = $showAlsoSubordinates;
        }
        return $this;
    }
    /**
     * Get StateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateId()
    {
        return isset($this->StateId) ? $this->StateId : null;
    }
    /**
     * Set StateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateId
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: string
        if (!is_null($stateId) && !is_string($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateId, true), gettype($stateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stateId, true)), __LINE__);
        }
        if (is_null($stateId) || (is_array($stateId) && empty($stateId))) {
            unset($this->StateId);
        } else {
            $this->StateId = $stateId;
        }
        return $this;
    }
    /**
     * Get StringField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField1()
    {
        return isset($this->StringField1) ? $this->StringField1 : null;
    }
    /**
     * Set StringField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField1
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField1($stringField1 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField1) && !is_string($stringField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField1, true), gettype($stringField1)), __LINE__);
        }
        if (is_null($stringField1) || (is_array($stringField1) && empty($stringField1))) {
            unset($this->StringField1);
        } else {
            $this->StringField1 = $stringField1;
        }
        return $this;
    }
    /**
     * Get StringField10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField10()
    {
        return isset($this->StringField10) ? $this->StringField10 : null;
    }
    /**
     * Set StringField10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField10
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField10($stringField10 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField10) && !is_string($stringField10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField10, true), gettype($stringField10)), __LINE__);
        }
        if (is_null($stringField10) || (is_array($stringField10) && empty($stringField10))) {
            unset($this->StringField10);
        } else {
            $this->StringField10 = $stringField10;
        }
        return $this;
    }
    /**
     * Get StringField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField2()
    {
        return isset($this->StringField2) ? $this->StringField2 : null;
    }
    /**
     * Set StringField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField2
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField2($stringField2 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField2) && !is_string($stringField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField2, true), gettype($stringField2)), __LINE__);
        }
        if (is_null($stringField2) || (is_array($stringField2) && empty($stringField2))) {
            unset($this->StringField2);
        } else {
            $this->StringField2 = $stringField2;
        }
        return $this;
    }
    /**
     * Get StringField3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField3()
    {
        return isset($this->StringField3) ? $this->StringField3 : null;
    }
    /**
     * Set StringField3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField3
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField3($stringField3 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField3) && !is_string($stringField3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField3, true), gettype($stringField3)), __LINE__);
        }
        if (is_null($stringField3) || (is_array($stringField3) && empty($stringField3))) {
            unset($this->StringField3);
        } else {
            $this->StringField3 = $stringField3;
        }
        return $this;
    }
    /**
     * Get StringField4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField4()
    {
        return isset($this->StringField4) ? $this->StringField4 : null;
    }
    /**
     * Set StringField4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField4
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField4($stringField4 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField4) && !is_string($stringField4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField4, true), gettype($stringField4)), __LINE__);
        }
        if (is_null($stringField4) || (is_array($stringField4) && empty($stringField4))) {
            unset($this->StringField4);
        } else {
            $this->StringField4 = $stringField4;
        }
        return $this;
    }
    /**
     * Get StringField5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField5()
    {
        return isset($this->StringField5) ? $this->StringField5 : null;
    }
    /**
     * Set StringField5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField5
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField5($stringField5 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField5) && !is_string($stringField5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField5, true), gettype($stringField5)), __LINE__);
        }
        if (is_null($stringField5) || (is_array($stringField5) && empty($stringField5))) {
            unset($this->StringField5);
        } else {
            $this->StringField5 = $stringField5;
        }
        return $this;
    }
    /**
     * Get StringField6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField6()
    {
        return isset($this->StringField6) ? $this->StringField6 : null;
    }
    /**
     * Set StringField6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField6
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField6($stringField6 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField6) && !is_string($stringField6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField6, true), gettype($stringField6)), __LINE__);
        }
        if (is_null($stringField6) || (is_array($stringField6) && empty($stringField6))) {
            unset($this->StringField6);
        } else {
            $this->StringField6 = $stringField6;
        }
        return $this;
    }
    /**
     * Get StringField7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField7()
    {
        return isset($this->StringField7) ? $this->StringField7 : null;
    }
    /**
     * Set StringField7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField7
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField7($stringField7 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField7) && !is_string($stringField7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField7, true), gettype($stringField7)), __LINE__);
        }
        if (is_null($stringField7) || (is_array($stringField7) && empty($stringField7))) {
            unset($this->StringField7);
        } else {
            $this->StringField7 = $stringField7;
        }
        return $this;
    }
    /**
     * Get StringField8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField8()
    {
        return isset($this->StringField8) ? $this->StringField8 : null;
    }
    /**
     * Set StringField8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField8
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField8($stringField8 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField8) && !is_string($stringField8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField8, true), gettype($stringField8)), __LINE__);
        }
        if (is_null($stringField8) || (is_array($stringField8) && empty($stringField8))) {
            unset($this->StringField8);
        } else {
            $this->StringField8 = $stringField8;
        }
        return $this;
    }
    /**
     * Get StringField9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField9()
    {
        return isset($this->StringField9) ? $this->StringField9 : null;
    }
    /**
     * Set StringField9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField9
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setStringField9($stringField9 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField9) && !is_string($stringField9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField9, true), gettype($stringField9)), __LINE__);
        }
        if (is_null($stringField9) || (is_array($stringField9) && empty($stringField9))) {
            unset($this->StringField9);
        } else {
            $this->StringField9 = $stringField9;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \patest\StructType\Crm_ClientFilter
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
}
