<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.AccountReadOnlyData StructType
 * @subpackage Structs
 */
class Crm_AccountReadOnlyData extends AnyEntity
{
    /**
     * The AccountTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccountTypeIds
     */
    public $AccountTypeIds;
    /**
     * The AccountTypes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_AccountType
     */
    public $AccountTypes;
    /**
     * The Announcement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Announcement;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Customer
     */
    public $ContactPerson;
    /**
     * The ContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactPersonId;
    /**
     * The CreditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CreditLimit;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GroupName;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Interface
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Interface;
    /**
     * The Logo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Logo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SaleOnBehalfUserTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleOnBehalfUserTokenId;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalutationIndividualText;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The TicketNumberGlobalCounterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketNumberGlobalCounterId;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Crm.AccountReadOnlyData
     * @uses Crm_AccountReadOnlyData::setAccountTypeIds()
     * @uses Crm_AccountReadOnlyData::setAccountTypes()
     * @uses Crm_AccountReadOnlyData::setAnnouncement()
     * @uses Crm_AccountReadOnlyData::setContactPerson()
     * @uses Crm_AccountReadOnlyData::setContactPersonId()
     * @uses Crm_AccountReadOnlyData::setCreditLimit()
     * @uses Crm_AccountReadOnlyData::setGroupId()
     * @uses Crm_AccountReadOnlyData::setGroupName()
     * @uses Crm_AccountReadOnlyData::setHolderTenantId()
     * @uses Crm_AccountReadOnlyData::setId()
     * @uses Crm_AccountReadOnlyData::setInterface()
     * @uses Crm_AccountReadOnlyData::setLogo()
     * @uses Crm_AccountReadOnlyData::setName()
     * @uses Crm_AccountReadOnlyData::setSaleOnBehalfUserTokenId()
     * @uses Crm_AccountReadOnlyData::setSalutationIndividualText()
     * @uses Crm_AccountReadOnlyData::setTaxExemptNumber()
     * @uses Crm_AccountReadOnlyData::setTicketNumberGlobalCounterId()
     * @uses Crm_AccountReadOnlyData::setVatRegistrationNumber()
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @param \patest\StructType\RecordSetOfCrm_AccountType $accountTypes
     * @param string $announcement
     * @param \patest\StructType\Crm_Customer $contactPerson
     * @param string $contactPersonId
     * @param \patest\StructType\Money $creditLimit
     * @param string $groupId
     * @param \patest\StructType\GlobalString $groupName
     * @param int $holderTenantId
     * @param string $id
     * @param string $interface
     * @param string $logo
     * @param string $name
     * @param string $saleOnBehalfUserTokenId
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @param string $taxExemptNumber
     * @param string $ticketNumberGlobalCounterId
     * @param string $vatRegistrationNumber
     */
    public function __construct(\patest\StructType\AccountTypeIds $accountTypeIds = null, \patest\StructType\RecordSetOfCrm_AccountType $accountTypes = null, $announcement = null, \patest\StructType\Crm_Customer $contactPerson = null, $contactPersonId = null, \patest\StructType\Money $creditLimit = null, $groupId = null, \patest\StructType\GlobalString $groupName = null, $holderTenantId = null, $id = null, $interface = null, $logo = null, $name = null, $saleOnBehalfUserTokenId = null, \patest\StructType\GlobalString $salutationIndividualText = null, $taxExemptNumber = null, $ticketNumberGlobalCounterId = null, $vatRegistrationNumber = null)
    {
        $this
            ->setAccountTypeIds($accountTypeIds)
            ->setAccountTypes($accountTypes)
            ->setAnnouncement($announcement)
            ->setContactPerson($contactPerson)
            ->setContactPersonId($contactPersonId)
            ->setCreditLimit($creditLimit)
            ->setGroupId($groupId)
            ->setGroupName($groupName)
            ->setHolderTenantId($holderTenantId)
            ->setId($id)
            ->setInterface($interface)
            ->setLogo($logo)
            ->setName($name)
            ->setSaleOnBehalfUserTokenId($saleOnBehalfUserTokenId)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setTicketNumberGlobalCounterId($ticketNumberGlobalCounterId)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get AccountTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccountTypeIds|null
     */
    public function getAccountTypeIds()
    {
        return isset($this->AccountTypeIds) ? $this->AccountTypeIds : null;
    }
    /**
     * Set AccountTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setAccountTypeIds(\patest\StructType\AccountTypeIds $accountTypeIds = null)
    {
        if (is_null($accountTypeIds) || (is_array($accountTypeIds) && empty($accountTypeIds))) {
            unset($this->AccountTypeIds);
        } else {
            $this->AccountTypeIds = $accountTypeIds;
        }
        return $this;
    }
    /**
     * Get AccountTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_AccountType|null
     */
    public function getAccountTypes()
    {
        return isset($this->AccountTypes) ? $this->AccountTypes : null;
    }
    /**
     * Set AccountTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_AccountType $accountTypes
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setAccountTypes(\patest\StructType\RecordSetOfCrm_AccountType $accountTypes = null)
    {
        if (is_null($accountTypes) || (is_array($accountTypes) && empty($accountTypes))) {
            unset($this->AccountTypes);
        } else {
            $this->AccountTypes = $accountTypes;
        }
        return $this;
    }
    /**
     * Get Announcement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnouncement()
    {
        return isset($this->Announcement) ? $this->Announcement : null;
    }
    /**
     * Set Announcement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $announcement
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setAnnouncement($announcement = null)
    {
        // validation for constraint: string
        if (!is_null($announcement) && !is_string($announcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($announcement, true), gettype($announcement)), __LINE__);
        }
        if (is_null($announcement) || (is_array($announcement) && empty($announcement))) {
            unset($this->Announcement);
        } else {
            $this->Announcement = $announcement;
        }
        return $this;
    }
    /**
     * Get ContactPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Customer|null
     */
    public function getContactPerson()
    {
        return isset($this->ContactPerson) ? $this->ContactPerson : null;
    }
    /**
     * Set ContactPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_Customer $contactPerson
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setContactPerson(\patest\StructType\Crm_Customer $contactPerson = null)
    {
        if (is_null($contactPerson) || (is_array($contactPerson) && empty($contactPerson))) {
            unset($this->ContactPerson);
        } else {
            $this->ContactPerson = $contactPerson;
        }
        return $this;
    }
    /**
     * Get ContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPersonId()
    {
        return isset($this->ContactPersonId) ? $this->ContactPersonId : null;
    }
    /**
     * Set ContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPersonId
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setContactPersonId($contactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonId) && !is_string($contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonId, true), gettype($contactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactPersonId, true)), __LINE__);
        }
        if (is_null($contactPersonId) || (is_array($contactPersonId) && empty($contactPersonId))) {
            unset($this->ContactPersonId);
        } else {
            $this->ContactPersonId = $contactPersonId;
        }
        return $this;
    }
    /**
     * Get CreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCreditLimit()
    {
        return isset($this->CreditLimit) ? $this->CreditLimit : null;
    }
    /**
     * Set CreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $creditLimit
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setCreditLimit(\patest\StructType\Money $creditLimit = null)
    {
        if (is_null($creditLimit) || (is_array($creditLimit) && empty($creditLimit))) {
            unset($this->CreditLimit);
        } else {
            $this->CreditLimit = $creditLimit;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $groupName
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setGroupName(\patest\StructType\GlobalString $groupName = null)
    {
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Interface value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInterface()
    {
        return isset($this->Interface) ? $this->Interface : null;
    }
    /**
     * Set Interface value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $interface
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setInterface($interface = null)
    {
        // validation for constraint: string
        if (!is_null($interface) && !is_string($interface)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interface, true), gettype($interface)), __LINE__);
        }
        if (is_null($interface) || (is_array($interface) && empty($interface))) {
            unset($this->Interface);
        } else {
            $this->Interface = $interface;
        }
        return $this;
    }
    /**
     * Get Logo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogo()
    {
        return isset($this->Logo) ? $this->Logo : null;
    }
    /**
     * Set Logo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logo
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setLogo($logo = null)
    {
        // validation for constraint: string
        if (!is_null($logo) && !is_string($logo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logo, true), gettype($logo)), __LINE__);
        }
        if (is_null($logo) || (is_array($logo) && empty($logo))) {
            unset($this->Logo);
        } else {
            $this->Logo = $logo;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SaleOnBehalfUserTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleOnBehalfUserTokenId()
    {
        return isset($this->SaleOnBehalfUserTokenId) ? $this->SaleOnBehalfUserTokenId : null;
    }
    /**
     * Set SaleOnBehalfUserTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleOnBehalfUserTokenId
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setSaleOnBehalfUserTokenId($saleOnBehalfUserTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($saleOnBehalfUserTokenId) && !is_string($saleOnBehalfUserTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOnBehalfUserTokenId, true), gettype($saleOnBehalfUserTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleOnBehalfUserTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleOnBehalfUserTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleOnBehalfUserTokenId, true)), __LINE__);
        }
        if (is_null($saleOnBehalfUserTokenId) || (is_array($saleOnBehalfUserTokenId) && empty($saleOnBehalfUserTokenId))) {
            unset($this->SaleOnBehalfUserTokenId);
        } else {
            $this->SaleOnBehalfUserTokenId = $saleOnBehalfUserTokenId;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setSalutationIndividualText(\patest\StructType\GlobalString $salutationIndividualText = null)
    {
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get TicketNumberGlobalCounterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketNumberGlobalCounterId()
    {
        return isset($this->TicketNumberGlobalCounterId) ? $this->TicketNumberGlobalCounterId : null;
    }
    /**
     * Set TicketNumberGlobalCounterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketNumberGlobalCounterId
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setTicketNumberGlobalCounterId($ticketNumberGlobalCounterId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumberGlobalCounterId) && !is_string($ticketNumberGlobalCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumberGlobalCounterId, true), gettype($ticketNumberGlobalCounterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketNumberGlobalCounterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketNumberGlobalCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketNumberGlobalCounterId, true)), __LINE__);
        }
        if (is_null($ticketNumberGlobalCounterId) || (is_array($ticketNumberGlobalCounterId) && empty($ticketNumberGlobalCounterId))) {
            unset($this->TicketNumberGlobalCounterId);
        } else {
            $this->TicketNumberGlobalCounterId = $ticketNumberGlobalCounterId;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Crm_AccountReadOnlyData
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
