<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.AccountFilter StructType
 * @subpackage Structs
 */
class Crm_AccountFilter extends Crm_ClientFilter
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The BusinessCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BusinessCategories
     */
    public $BusinessCategories;
    /**
     * The BusinessCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessCategory;
    /**
     * The BusinessCategorySearchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessCategorySearchType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Crm.AccountFilter
     * @uses Crm_AccountFilter::setAccountName()
     * @uses Crm_AccountFilter::setBusinessCategories()
     * @uses Crm_AccountFilter::setBusinessCategory()
     * @uses Crm_AccountFilter::setBusinessCategorySearchType()
     * @uses Crm_AccountFilter::setName()
     * @uses Crm_AccountFilter::setVatRegistrationNumber()
     * @param string $accountName
     * @param \patest\StructType\BusinessCategories $businessCategories
     * @param string $businessCategory
     * @param string $businessCategorySearchType
     * @param string $name
     * @param string $vatRegistrationNumber
     */
    public function __construct($accountName = null, \patest\StructType\BusinessCategories $businessCategories = null, $businessCategory = null, $businessCategorySearchType = null, $name = null, $vatRegistrationNumber = null)
    {
        $this
            ->setAccountName($accountName)
            ->setBusinessCategories($businessCategories)
            ->setBusinessCategory($businessCategory)
            ->setBusinessCategorySearchType($businessCategorySearchType)
            ->setName($name)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Crm_AccountFilter
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get BusinessCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BusinessCategories|null
     */
    public function getBusinessCategories()
    {
        return isset($this->BusinessCategories) ? $this->BusinessCategories : null;
    }
    /**
     * Set BusinessCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BusinessCategories $businessCategories
     * @return \patest\StructType\Crm_AccountFilter
     */
    public function setBusinessCategories(\patest\StructType\BusinessCategories $businessCategories = null)
    {
        if (is_null($businessCategories) || (is_array($businessCategories) && empty($businessCategories))) {
            unset($this->BusinessCategories);
        } else {
            $this->BusinessCategories = $businessCategories;
        }
        return $this;
    }
    /**
     * Get BusinessCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessCategory()
    {
        return isset($this->BusinessCategory) ? $this->BusinessCategory : null;
    }
    /**
     * Set BusinessCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessCategory
     * @return \patest\StructType\Crm_AccountFilter
     */
    public function setBusinessCategory($businessCategory = null)
    {
        // validation for constraint: string
        if (!is_null($businessCategory) && !is_string($businessCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCategory, true), gettype($businessCategory)), __LINE__);
        }
        if (is_null($businessCategory) || (is_array($businessCategory) && empty($businessCategory))) {
            unset($this->BusinessCategory);
        } else {
            $this->BusinessCategory = $businessCategory;
        }
        return $this;
    }
    /**
     * Get BusinessCategorySearchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessCategorySearchType()
    {
        return isset($this->BusinessCategorySearchType) ? $this->BusinessCategorySearchType : null;
    }
    /**
     * Set BusinessCategorySearchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessCategorySearchType
     * @return \patest\StructType\Crm_AccountFilter
     */
    public function setBusinessCategorySearchType($businessCategorySearchType = null)
    {
        // validation for constraint: string
        if (!is_null($businessCategorySearchType) && !is_string($businessCategorySearchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCategorySearchType, true), gettype($businessCategorySearchType)), __LINE__);
        }
        if (is_null($businessCategorySearchType) || (is_array($businessCategorySearchType) && empty($businessCategorySearchType))) {
            unset($this->BusinessCategorySearchType);
        } else {
            $this->BusinessCategorySearchType = $businessCategorySearchType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Crm_AccountFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Crm_AccountFilter
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
