<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSingleDraftInvoiceRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateSingleDraftInvoiceRequest
 * @subpackage Structs
 */
class CreateSingleDraftInvoiceRequest extends AbstractStructBase
{
    /**
     * The CalculateCommissionPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalculateCommissionPerTransaction;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The FromSellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromSellDate;
    /**
     * The IncludeActualLiabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeActualLiabilities;
    /**
     * The IncludePendingLiabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludePendingLiabilities;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The SendByEmailData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SendByEmailData
     */
    public $SendByEmailData;
    /**
     * The UntilSellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilSellDate;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ItemIds;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurposeId;
    /**
     * The GroupByFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupByFullPrice;
    /**
     * Constructor method for CreateSingleDraftInvoiceRequest
     * @uses CreateSingleDraftInvoiceRequest::setCalculateCommissionPerTransaction()
     * @uses CreateSingleDraftInvoiceRequest::setClientId()
     * @uses CreateSingleDraftInvoiceRequest::setFromSellDate()
     * @uses CreateSingleDraftInvoiceRequest::setIncludeActualLiabilities()
     * @uses CreateSingleDraftInvoiceRequest::setIncludePendingLiabilities()
     * @uses CreateSingleDraftInvoiceRequest::setRemark()
     * @uses CreateSingleDraftInvoiceRequest::setSendByEmailData()
     * @uses CreateSingleDraftInvoiceRequest::setUntilSellDate()
     * @uses CreateSingleDraftInvoiceRequest::setItemIds()
     * @uses CreateSingleDraftInvoiceRequest::setPurposeId()
     * @uses CreateSingleDraftInvoiceRequest::setGroupByFullPrice()
     * @param bool $calculateCommissionPerTransaction
     * @param string $clientId
     * @param string $fromSellDate
     * @param bool $includeActualLiabilities
     * @param bool $includePendingLiabilities
     * @param string $remark
     * @param \patest\StructType\SendByEmailData $sendByEmailData
     * @param string $untilSellDate
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @param string $purposeId
     * @param bool $groupByFullPrice
     */
    public function __construct($calculateCommissionPerTransaction = null, $clientId = null, $fromSellDate = null, $includeActualLiabilities = null, $includePendingLiabilities = null, $remark = null, \patest\StructType\SendByEmailData $sendByEmailData = null, $untilSellDate = null, \patest\ArrayType\ArrayOfguid $itemIds = null, $purposeId = null, $groupByFullPrice = null)
    {
        $this
            ->setCalculateCommissionPerTransaction($calculateCommissionPerTransaction)
            ->setClientId($clientId)
            ->setFromSellDate($fromSellDate)
            ->setIncludeActualLiabilities($includeActualLiabilities)
            ->setIncludePendingLiabilities($includePendingLiabilities)
            ->setRemark($remark)
            ->setSendByEmailData($sendByEmailData)
            ->setUntilSellDate($untilSellDate)
            ->setItemIds($itemIds)
            ->setPurposeId($purposeId)
            ->setGroupByFullPrice($groupByFullPrice);
    }
    /**
     * Get CalculateCommissionPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalculateCommissionPerTransaction()
    {
        return isset($this->CalculateCommissionPerTransaction) ? $this->CalculateCommissionPerTransaction : null;
    }
    /**
     * Set CalculateCommissionPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calculateCommissionPerTransaction
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setCalculateCommissionPerTransaction($calculateCommissionPerTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateCommissionPerTransaction) && !is_bool($calculateCommissionPerTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateCommissionPerTransaction, true), gettype($calculateCommissionPerTransaction)), __LINE__);
        }
        if (is_null($calculateCommissionPerTransaction) || (is_array($calculateCommissionPerTransaction) && empty($calculateCommissionPerTransaction))) {
            unset($this->CalculateCommissionPerTransaction);
        } else {
            $this->CalculateCommissionPerTransaction = $calculateCommissionPerTransaction;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get FromSellDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromSellDate()
    {
        return isset($this->FromSellDate) ? $this->FromSellDate : null;
    }
    /**
     * Set FromSellDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromSellDate
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setFromSellDate($fromSellDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromSellDate) && !is_string($fromSellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromSellDate, true), gettype($fromSellDate)), __LINE__);
        }
        if (is_null($fromSellDate) || (is_array($fromSellDate) && empty($fromSellDate))) {
            unset($this->FromSellDate);
        } else {
            $this->FromSellDate = $fromSellDate;
        }
        return $this;
    }
    /**
     * Get IncludeActualLiabilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeActualLiabilities()
    {
        return isset($this->IncludeActualLiabilities) ? $this->IncludeActualLiabilities : null;
    }
    /**
     * Set IncludeActualLiabilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeActualLiabilities
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setIncludeActualLiabilities($includeActualLiabilities = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeActualLiabilities) && !is_bool($includeActualLiabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeActualLiabilities, true), gettype($includeActualLiabilities)), __LINE__);
        }
        if (is_null($includeActualLiabilities) || (is_array($includeActualLiabilities) && empty($includeActualLiabilities))) {
            unset($this->IncludeActualLiabilities);
        } else {
            $this->IncludeActualLiabilities = $includeActualLiabilities;
        }
        return $this;
    }
    /**
     * Get IncludePendingLiabilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludePendingLiabilities()
    {
        return isset($this->IncludePendingLiabilities) ? $this->IncludePendingLiabilities : null;
    }
    /**
     * Set IncludePendingLiabilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includePendingLiabilities
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setIncludePendingLiabilities($includePendingLiabilities = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePendingLiabilities) && !is_bool($includePendingLiabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePendingLiabilities, true), gettype($includePendingLiabilities)), __LINE__);
        }
        if (is_null($includePendingLiabilities) || (is_array($includePendingLiabilities) && empty($includePendingLiabilities))) {
            unset($this->IncludePendingLiabilities);
        } else {
            $this->IncludePendingLiabilities = $includePendingLiabilities;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get SendByEmailData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SendByEmailData|null
     */
    public function getSendByEmailData()
    {
        return isset($this->SendByEmailData) ? $this->SendByEmailData : null;
    }
    /**
     * Set SendByEmailData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SendByEmailData $sendByEmailData
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setSendByEmailData(\patest\StructType\SendByEmailData $sendByEmailData = null)
    {
        if (is_null($sendByEmailData) || (is_array($sendByEmailData) && empty($sendByEmailData))) {
            unset($this->SendByEmailData);
        } else {
            $this->SendByEmailData = $sendByEmailData;
        }
        return $this;
    }
    /**
     * Get UntilSellDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilSellDate()
    {
        return isset($this->UntilSellDate) ? $this->UntilSellDate : null;
    }
    /**
     * Set UntilSellDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilSellDate
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setUntilSellDate($untilSellDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilSellDate) && !is_string($untilSellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilSellDate, true), gettype($untilSellDate)), __LINE__);
        }
        if (is_null($untilSellDate) || (is_array($untilSellDate) && empty($untilSellDate))) {
            unset($this->UntilSellDate);
        } else {
            $this->UntilSellDate = $untilSellDate;
        }
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setItemIds(\patest\ArrayType\ArrayOfguid $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposeId
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: string
        if (!is_null($purposeId) && !is_string($purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purposeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purposeId, true)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get GroupByFullPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupByFullPrice()
    {
        return isset($this->GroupByFullPrice) ? $this->GroupByFullPrice : null;
    }
    /**
     * Set GroupByFullPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupByFullPrice
     * @return \patest\StructType\CreateSingleDraftInvoiceRequest
     */
    public function setGroupByFullPrice($groupByFullPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByFullPrice) && !is_bool($groupByFullPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByFullPrice, true), gettype($groupByFullPrice)), __LINE__);
        }
        if (is_null($groupByFullPrice) || (is_array($groupByFullPrice) && empty($groupByFullPrice))) {
            unset($this->GroupByFullPrice);
        } else {
            $this->GroupByFullPrice = $groupByFullPrice;
        }
        return $this;
    }
}
