<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePresaleAsync-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePresaleAsync-Response
 * @subpackage Structs
 */
class CreatePresaleAsync_Response extends AbstractStructBase
{
    /**
     * The AccessCodeJobId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCodeJobId;
    /**
     * The Presale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Presale
     */
    public $Presale;
    /**
     * Constructor method for CreatePresaleAsync-Response
     * @uses CreatePresaleAsync_Response::setAccessCodeJobId()
     * @uses CreatePresaleAsync_Response::setPresale()
     * @param string $accessCodeJobId
     * @param \patest\StructType\Ticketing_Presale $presale
     */
    public function __construct($accessCodeJobId = null, \patest\StructType\Ticketing_Presale $presale = null)
    {
        $this
            ->setAccessCodeJobId($accessCodeJobId)
            ->setPresale($presale);
    }
    /**
     * Get AccessCodeJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeJobId()
    {
        return isset($this->AccessCodeJobId) ? $this->AccessCodeJobId : null;
    }
    /**
     * Set AccessCodeJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeJobId
     * @return \patest\StructType\CreatePresaleAsync_Response
     */
    public function setAccessCodeJobId($accessCodeJobId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeJobId) && !is_string($accessCodeJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeJobId, true), gettype($accessCodeJobId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCodeJobId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCodeJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCodeJobId, true)), __LINE__);
        }
        if (is_null($accessCodeJobId) || (is_array($accessCodeJobId) && empty($accessCodeJobId))) {
            unset($this->AccessCodeJobId);
        } else {
            $this->AccessCodeJobId = $accessCodeJobId;
        }
        return $this;
    }
    /**
     * Get Presale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Presale|null
     */
    public function getPresale()
    {
        return isset($this->Presale) ? $this->Presale : null;
    }
    /**
     * Set Presale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Presale $presale
     * @return \patest\StructType\CreatePresaleAsync_Response
     */
    public function setPresale(\patest\StructType\Ticketing_Presale $presale = null)
    {
        if (is_null($presale) || (is_array($presale) && empty($presale))) {
            unset($this->Presale);
        } else {
            $this->Presale = $presale;
        }
        return $this;
    }
}
