<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentTokenWithoutPaymentRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePaymentTokenWithoutPaymentRequest
 * @subpackage Structs
 */
class CreatePaymentTokenWithoutPaymentRequest extends ExtensibleDataContract
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The PaymentDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AbstractPaymentDescription
     */
    public $PaymentDescription;
    /**
     * Constructor method for CreatePaymentTokenWithoutPaymentRequest
     * @uses CreatePaymentTokenWithoutPaymentRequest::setClientId()
     * @uses CreatePaymentTokenWithoutPaymentRequest::setPaymentDescription()
     * @param string $clientId
     * @param \patest\StructType\AbstractPaymentDescription $paymentDescription
     */
    public function __construct($clientId = null, \patest\StructType\AbstractPaymentDescription $paymentDescription = null)
    {
        $this
            ->setClientId($clientId)
            ->setPaymentDescription($paymentDescription);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\CreatePaymentTokenWithoutPaymentRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get PaymentDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AbstractPaymentDescription|null
     */
    public function getPaymentDescription()
    {
        return isset($this->PaymentDescription) ? $this->PaymentDescription : null;
    }
    /**
     * Set PaymentDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AbstractPaymentDescription $paymentDescription
     * @return \patest\StructType\CreatePaymentTokenWithoutPaymentRequest
     */
    public function setPaymentDescription(\patest\StructType\AbstractPaymentDescription $paymentDescription = null)
    {
        if (is_null($paymentDescription) || (is_array($paymentDescription) && empty($paymentDescription))) {
            unset($this->PaymentDescription);
        } else {
            $this->PaymentDescription = $paymentDescription;
        }
        return $this;
    }
}
