<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePaymentResponse
 * @subpackage Structs
 */
class CreatePaymentResponse extends AbstractStructBase
{
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentId;
    /**
     * Constructor method for CreatePaymentResponse
     * @uses CreatePaymentResponse::setPaymentId()
     * @param string $paymentId
     */
    public function __construct($paymentId = null)
    {
        $this
            ->setPaymentId($paymentId);
    }
    /**
     * Get PaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentId()
    {
        return isset($this->PaymentId) ? $this->PaymentId : null;
    }
    /**
     * Set PaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentId
     * @return \patest\StructType\CreatePaymentResponse
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentId) && !is_string($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        if (is_null($paymentId) || (is_array($paymentId) && empty($paymentId))) {
            unset($this->PaymentId);
        } else {
            $this->PaymentId = $paymentId;
        }
        return $this;
    }
}
