<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrUpdatePriceList-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateOrUpdatePriceList-Response
 * @subpackage Structs
 */
class CreateOrUpdatePriceList_Response extends AbstractStructBase
{
    /**
     * The NumberOfPriceChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfPriceChanges;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * Constructor method for CreateOrUpdatePriceList-Response
     * @uses CreateOrUpdatePriceList_Response::setNumberOfPriceChanges()
     * @uses CreateOrUpdatePriceList_Response::setPriceListId()
     * @param int $numberOfPriceChanges
     * @param string $priceListId
     */
    public function __construct($numberOfPriceChanges = null, $priceListId = null)
    {
        $this
            ->setNumberOfPriceChanges($numberOfPriceChanges)
            ->setPriceListId($priceListId);
    }
    /**
     * Get NumberOfPriceChanges value
     * @return int|null
     */
    public function getNumberOfPriceChanges()
    {
        return $this->NumberOfPriceChanges;
    }
    /**
     * Set NumberOfPriceChanges value
     * @param int $numberOfPriceChanges
     * @return \patest\StructType\CreateOrUpdatePriceList_Response
     */
    public function setNumberOfPriceChanges($numberOfPriceChanges = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPriceChanges) && !(is_int($numberOfPriceChanges) || ctype_digit($numberOfPriceChanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPriceChanges, true), gettype($numberOfPriceChanges)), __LINE__);
        }
        $this->NumberOfPriceChanges = $numberOfPriceChanges;
        return $this;
    }
    /**
     * Get PriceListId value
     * @return string|null
     */
    public function getPriceListId()
    {
        return $this->PriceListId;
    }
    /**
     * Set PriceListId value
     * @param string $priceListId
     * @return \patest\StructType\CreateOrUpdatePriceList_Response
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        $this->PriceListId = $priceListId;
        return $this;
    }
}
