<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAccountRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateAccountRequest
 * @subpackage Structs
 */
class CreateAccountRequest extends AbstractStructBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_SimplifiedAccount
     */
    public $Account;
    /**
     * The RetunStoredAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RetunStoredAccount;
    /**
     * Constructor method for CreateAccountRequest
     * @uses CreateAccountRequest::setAccount()
     * @uses CreateAccountRequest::setRetunStoredAccount()
     * @param \patest\StructType\Crm_SimplifiedAccount $account
     * @param bool $retunStoredAccount
     */
    public function __construct(\patest\StructType\Crm_SimplifiedAccount $account = null, $retunStoredAccount = null)
    {
        $this
            ->setAccount($account)
            ->setRetunStoredAccount($retunStoredAccount);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_SimplifiedAccount|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_SimplifiedAccount $account
     * @return \patest\StructType\CreateAccountRequest
     */
    public function setAccount(\patest\StructType\Crm_SimplifiedAccount $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get RetunStoredAccount value
     * @return bool|null
     */
    public function getRetunStoredAccount()
    {
        return $this->RetunStoredAccount;
    }
    /**
     * Set RetunStoredAccount value
     * @param bool $retunStoredAccount
     * @return \patest\StructType\CreateAccountRequest
     */
    public function setRetunStoredAccount($retunStoredAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($retunStoredAccount) && !is_bool($retunStoredAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retunStoredAccount, true), gettype($retunStoredAccount)), __LINE__);
        }
        $this->RetunStoredAccount = $retunStoredAccount;
        return $this;
    }
}
