<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponRedemptionFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CouponRedemptionFault
 * @subpackage Structs
 */
class CouponRedemptionFault extends BasicFault
{
    /**
     * The FaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultCode;
    /**
     * The FaultDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultDescription;
    /**
     * Constructor method for CouponRedemptionFault
     * @uses CouponRedemptionFault::setFaultCode()
     * @uses CouponRedemptionFault::setFaultDescription()
     * @param string $faultCode
     * @param string $faultDescription
     */
    public function __construct($faultCode = null, $faultDescription = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultDescription($faultDescription);
    }
    /**
     * Get FaultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultCode()
    {
        return isset($this->FaultCode) ? $this->FaultCode : null;
    }
    /**
     * Set FaultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultCode
     * @return \patest\StructType\CouponRedemptionFault
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        if (is_null($faultCode) || (is_array($faultCode) && empty($faultCode))) {
            unset($this->FaultCode);
        } else {
            $this->FaultCode = $faultCode;
        }
        return $this;
    }
    /**
     * Get FaultDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultDescription()
    {
        return isset($this->FaultDescription) ? $this->FaultDescription : null;
    }
    /**
     * Set FaultDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultDescription
     * @return \patest\StructType\CouponRedemptionFault
     */
    public function setFaultDescription($faultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($faultDescription) && !is_string($faultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultDescription, true), gettype($faultDescription)), __LINE__);
        }
        if (is_null($faultDescription) || (is_array($faultDescription) && empty($faultDescription))) {
            unset($this->FaultDescription);
        } else {
            $this->FaultDescription = $faultDescription;
        }
        return $this;
    }
}
