<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CouponDetail
 * @subpackage Structs
 */
class CouponDetail extends AbstractStructBase
{
    /**
     * The CouponId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponId;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The RedemptionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedemptionCount;
    /**
     * The RedemptionQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedemptionQuantity;
    /**
     * The RedemptionQuantityPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedemptionQuantityPerTransaction;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * Constructor method for CouponDetail
     * @uses CouponDetail::setCouponId()
     * @uses CouponDetail::setDefinitionId()
     * @uses CouponDetail::setName()
     * @uses CouponDetail::setNumber()
     * @uses CouponDetail::setRedemptionCount()
     * @uses CouponDetail::setRedemptionQuantity()
     * @uses CouponDetail::setRedemptionQuantityPerTransaction()
     * @uses CouponDetail::setSalesRepId()
     * @param string $couponId
     * @param string $definitionId
     * @param string $name
     * @param string $number
     * @param int $redemptionCount
     * @param int $redemptionQuantity
     * @param int $redemptionQuantityPerTransaction
     * @param string $salesRepId
     */
    public function __construct($couponId = null, $definitionId = null, $name = null, $number = null, $redemptionCount = null, $redemptionQuantity = null, $redemptionQuantityPerTransaction = null, $salesRepId = null)
    {
        $this
            ->setCouponId($couponId)
            ->setDefinitionId($definitionId)
            ->setName($name)
            ->setNumber($number)
            ->setRedemptionCount($redemptionCount)
            ->setRedemptionQuantity($redemptionQuantity)
            ->setRedemptionQuantityPerTransaction($redemptionQuantityPerTransaction)
            ->setSalesRepId($salesRepId);
    }
    /**
     * Get CouponId value
     * @return string|null
     */
    public function getCouponId()
    {
        return $this->CouponId;
    }
    /**
     * Set CouponId value
     * @param string $couponId
     * @return \patest\StructType\CouponDetail
     */
    public function setCouponId($couponId = null)
    {
        // validation for constraint: string
        if (!is_null($couponId) && !is_string($couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponId, true), gettype($couponId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponId, true)), __LINE__);
        }
        $this->CouponId = $couponId;
        return $this;
    }
    /**
     * Get DefinitionId value
     * @return string|null
     */
    public function getDefinitionId()
    {
        return $this->DefinitionId;
    }
    /**
     * Set DefinitionId value
     * @param string $definitionId
     * @return \patest\StructType\CouponDetail
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        $this->DefinitionId = $definitionId;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\CouponDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \patest\StructType\CouponDetail
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get RedemptionCount value
     * @return int|null
     */
    public function getRedemptionCount()
    {
        return $this->RedemptionCount;
    }
    /**
     * Set RedemptionCount value
     * @param int $redemptionCount
     * @return \patest\StructType\CouponDetail
     */
    public function setRedemptionCount($redemptionCount = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionCount) && !(is_int($redemptionCount) || ctype_digit($redemptionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionCount, true), gettype($redemptionCount)), __LINE__);
        }
        $this->RedemptionCount = $redemptionCount;
        return $this;
    }
    /**
     * Get RedemptionQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedemptionQuantity()
    {
        return isset($this->RedemptionQuantity) ? $this->RedemptionQuantity : null;
    }
    /**
     * Set RedemptionQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redemptionQuantity
     * @return \patest\StructType\CouponDetail
     */
    public function setRedemptionQuantity($redemptionQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantity) && !(is_int($redemptionQuantity) || ctype_digit($redemptionQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantity, true), gettype($redemptionQuantity)), __LINE__);
        }
        if (is_null($redemptionQuantity) || (is_array($redemptionQuantity) && empty($redemptionQuantity))) {
            unset($this->RedemptionQuantity);
        } else {
            $this->RedemptionQuantity = $redemptionQuantity;
        }
        return $this;
    }
    /**
     * Get RedemptionQuantityPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedemptionQuantityPerTransaction()
    {
        return isset($this->RedemptionQuantityPerTransaction) ? $this->RedemptionQuantityPerTransaction : null;
    }
    /**
     * Set RedemptionQuantityPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redemptionQuantityPerTransaction
     * @return \patest\StructType\CouponDetail
     */
    public function setRedemptionQuantityPerTransaction($redemptionQuantityPerTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantityPerTransaction) && !(is_int($redemptionQuantityPerTransaction) || ctype_digit($redemptionQuantityPerTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantityPerTransaction, true), gettype($redemptionQuantityPerTransaction)), __LINE__);
        }
        if (is_null($redemptionQuantityPerTransaction) || (is_array($redemptionQuantityPerTransaction) && empty($redemptionQuantityPerTransaction))) {
            unset($this->RedemptionQuantityPerTransaction);
        } else {
            $this->RedemptionQuantityPerTransaction = $redemptionQuantityPerTransaction;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\CouponDetail
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
}
