<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyHallVersionDesign-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CopyHallVersionDesign-Response
 * @subpackage Structs
 */
class CopyHallVersionDesign_Response extends ExtensibleDataContract
{
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * Constructor method for CopyHallVersionDesign-Response
     * @uses CopyHallVersionDesign_Response::setHallVersionId()
     * @param string $hallVersionId
     */
    public function __construct($hallVersionId = null)
    {
        $this
            ->setHallVersionId($hallVersionId);
    }
    /**
     * Get HallVersionId value
     * @return string|null
     */
    public function getHallVersionId()
    {
        return $this->HallVersionId;
    }
    /**
     * Set HallVersionId value
     * @param string $hallVersionId
     * @return \patest\StructType\CopyHallVersionDesign_Response
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        $this->HallVersionId = $hallVersionId;
        return $this;
    }
}
