<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConnectionProperties
 * @subpackage Structs
 */
class ConnectionProperties extends AbstractStructBase
{
    /**
     * The AffiliateAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AffiliateAccountId;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ApplicationChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationChannelId;
    /**
     * The ApplicationChannelLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ApplicationChannelLocalId;
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ApplicationChannelName;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AuditId;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The CompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompanyId;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CompanyName;
    /**
     * The CompanyTimezoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyTimezoneId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CultureId;
    /**
     * The CultureName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureName;
    /**
     * The ExpirationTimeout
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $ExpirationTimeout;
    /**
     * The FallbackCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FallbackCultureId;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HolderTenantId;
    /**
     * The IsMasterOrgUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMasterOrgUnit;
    /**
     * The IsSellerOrgUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSellerOrgUnit;
    /**
     * The IsSupplierOrgUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSupplierOrgUnit;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizationUnitLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganizationUnitLocalId;
    /**
     * The OrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitName;
    /**
     * The OrganizationUnitStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationUnitStatus;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SalePointLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SalePointLocalId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalePointName;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * The SecurityTokenLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SecurityTokenLocalId;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SecurityTokenName;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SiteId;
    /**
     * The SiteLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiteLocalId;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SiteName;
    /**
     * The SiteTimezoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteTimezoneId;
    /**
     * The SystemFallbackCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SystemFallbackCultureId;
    /**
     * The TillGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillGroupId;
    /**
     * The TillGroupLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TillGroupLocalId;
    /**
     * The TillGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TillGroupName;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * The TillLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TillLocalId;
    /**
     * The TillName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TillName;
    /**
     * The UserAllowedToSellNonAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UserAllowedToSellNonAllocated;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UserLocalId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The UserProfileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserProfileId;
    /**
     * The UserProfileLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UserProfileLocalId;
    /**
     * The UserProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $UserProfileName;
    /**
     * The UserRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserRoleId;
    /**
     * The UserRoleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $UserRoleName;
    /**
     * The WebLinkUri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebLinkUri;
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The WorkflowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkflowType;
    /**
     * The IsSgEmailDomain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSgEmailDomain;
    /**
     * The IsOnboardedToUserAdmin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOnboardedToUserAdmin;
    /**
     * The ShouldSkipOnboardingToUserAdmin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldSkipOnboardingToUserAdmin;
    /**
     * Constructor method for ConnectionProperties
     * @uses ConnectionProperties::setAffiliateAccountId()
     * @uses ConnectionProperties::setApplicationChannel()
     * @uses ConnectionProperties::setApplicationChannelId()
     * @uses ConnectionProperties::setApplicationChannelLocalId()
     * @uses ConnectionProperties::setApplicationChannelName()
     * @uses ConnectionProperties::setAuditId()
     * @uses ConnectionProperties::setCompanyCurrencyCode()
     * @uses ConnectionProperties::setCompanyId()
     * @uses ConnectionProperties::setCompanyName()
     * @uses ConnectionProperties::setCompanyTimezoneId()
     * @uses ConnectionProperties::setCultureId()
     * @uses ConnectionProperties::setCultureName()
     * @uses ConnectionProperties::setExpirationTimeout()
     * @uses ConnectionProperties::setFallbackCultureId()
     * @uses ConnectionProperties::setHolderTenantId()
     * @uses ConnectionProperties::setIsMasterOrgUnit()
     * @uses ConnectionProperties::setIsSellerOrgUnit()
     * @uses ConnectionProperties::setIsSupplierOrgUnit()
     * @uses ConnectionProperties::setOnBehalfOfAccountId()
     * @uses ConnectionProperties::setOrganizationUnitId()
     * @uses ConnectionProperties::setOrganizationUnitLocalId()
     * @uses ConnectionProperties::setOrganizationUnitName()
     * @uses ConnectionProperties::setOrganizationUnitStatus()
     * @uses ConnectionProperties::setSalePointId()
     * @uses ConnectionProperties::setSalePointLocalId()
     * @uses ConnectionProperties::setSalePointName()
     * @uses ConnectionProperties::setSecurityTokenId()
     * @uses ConnectionProperties::setSecurityTokenLocalId()
     * @uses ConnectionProperties::setSecurityTokenName()
     * @uses ConnectionProperties::setSiteCurrencyCode()
     * @uses ConnectionProperties::setSiteId()
     * @uses ConnectionProperties::setSiteLocalId()
     * @uses ConnectionProperties::setSiteName()
     * @uses ConnectionProperties::setSiteTimezoneId()
     * @uses ConnectionProperties::setSystemFallbackCultureId()
     * @uses ConnectionProperties::setTillGroupId()
     * @uses ConnectionProperties::setTillGroupLocalId()
     * @uses ConnectionProperties::setTillGroupName()
     * @uses ConnectionProperties::setTillId()
     * @uses ConnectionProperties::setTillLocalId()
     * @uses ConnectionProperties::setTillName()
     * @uses ConnectionProperties::setUserAllowedToSellNonAllocated()
     * @uses ConnectionProperties::setUserId()
     * @uses ConnectionProperties::setUserLocalId()
     * @uses ConnectionProperties::setUserName()
     * @uses ConnectionProperties::setUserProfileId()
     * @uses ConnectionProperties::setUserProfileLocalId()
     * @uses ConnectionProperties::setUserProfileName()
     * @uses ConnectionProperties::setUserRoleId()
     * @uses ConnectionProperties::setUserRoleName()
     * @uses ConnectionProperties::setWebLinkUri()
     * @uses ConnectionProperties::setApplication()
     * @uses ConnectionProperties::setWorkflowType()
     * @uses ConnectionProperties::setIsSgEmailDomain()
     * @uses ConnectionProperties::setIsOnboardedToUserAdmin()
     * @uses ConnectionProperties::setShouldSkipOnboardingToUserAdmin()
     * @param string $affiliateAccountId
     * @param string $applicationChannel
     * @param string $applicationChannelId
     * @param int $applicationChannelLocalId
     * @param \patest\StructType\GlobalString $applicationChannelName
     * @param int $auditId
     * @param string $companyCurrencyCode
     * @param string $companyId
     * @param \patest\StructType\GlobalString $companyName
     * @param string $companyTimezoneId
     * @param int $cultureId
     * @param string $cultureName
     * @param string $expirationTimeout
     * @param int $fallbackCultureId
     * @param int $holderTenantId
     * @param bool $isMasterOrgUnit
     * @param bool $isSellerOrgUnit
     * @param bool $isSupplierOrgUnit
     * @param string $onBehalfOfAccountId
     * @param string $organizationUnitId
     * @param int $organizationUnitLocalId
     * @param string $organizationUnitName
     * @param string $organizationUnitStatus
     * @param string $salePointId
     * @param int $salePointLocalId
     * @param \patest\StructType\GlobalString $salePointName
     * @param string $securityTokenId
     * @param int $securityTokenLocalId
     * @param \patest\StructType\GlobalString $securityTokenName
     * @param string $siteCurrencyCode
     * @param string $siteId
     * @param int $siteLocalId
     * @param \patest\StructType\GlobalString $siteName
     * @param string $siteTimezoneId
     * @param int $systemFallbackCultureId
     * @param string $tillGroupId
     * @param int $tillGroupLocalId
     * @param \patest\StructType\GlobalString $tillGroupName
     * @param string $tillId
     * @param int $tillLocalId
     * @param \patest\StructType\GlobalString $tillName
     * @param bool $userAllowedToSellNonAllocated
     * @param string $userId
     * @param int $userLocalId
     * @param string $userName
     * @param string $userProfileId
     * @param int $userProfileLocalId
     * @param \patest\StructType\GlobalString $userProfileName
     * @param string $userRoleId
     * @param \patest\StructType\GlobalString $userRoleName
     * @param string $webLinkUri
     * @param string $application
     * @param string $workflowType
     * @param bool $isSgEmailDomain
     * @param bool $isOnboardedToUserAdmin
     * @param bool $shouldSkipOnboardingToUserAdmin
     */
    public function __construct($affiliateAccountId = null, $applicationChannel = null, $applicationChannelId = null, $applicationChannelLocalId = null, \patest\StructType\GlobalString $applicationChannelName = null, $auditId = null, $companyCurrencyCode = null, $companyId = null, \patest\StructType\GlobalString $companyName = null, $companyTimezoneId = null, $cultureId = null, $cultureName = null, $expirationTimeout = null, $fallbackCultureId = null, $holderTenantId = null, $isMasterOrgUnit = null, $isSellerOrgUnit = null, $isSupplierOrgUnit = null, $onBehalfOfAccountId = null, $organizationUnitId = null, $organizationUnitLocalId = null, $organizationUnitName = null, $organizationUnitStatus = null, $salePointId = null, $salePointLocalId = null, \patest\StructType\GlobalString $salePointName = null, $securityTokenId = null, $securityTokenLocalId = null, \patest\StructType\GlobalString $securityTokenName = null, $siteCurrencyCode = null, $siteId = null, $siteLocalId = null, \patest\StructType\GlobalString $siteName = null, $siteTimezoneId = null, $systemFallbackCultureId = null, $tillGroupId = null, $tillGroupLocalId = null, \patest\StructType\GlobalString $tillGroupName = null, $tillId = null, $tillLocalId = null, \patest\StructType\GlobalString $tillName = null, $userAllowedToSellNonAllocated = null, $userId = null, $userLocalId = null, $userName = null, $userProfileId = null, $userProfileLocalId = null, \patest\StructType\GlobalString $userProfileName = null, $userRoleId = null, \patest\StructType\GlobalString $userRoleName = null, $webLinkUri = null, $application = null, $workflowType = null, $isSgEmailDomain = null, $isOnboardedToUserAdmin = null, $shouldSkipOnboardingToUserAdmin = null)
    {
        $this
            ->setAffiliateAccountId($affiliateAccountId)
            ->setApplicationChannel($applicationChannel)
            ->setApplicationChannelId($applicationChannelId)
            ->setApplicationChannelLocalId($applicationChannelLocalId)
            ->setApplicationChannelName($applicationChannelName)
            ->setAuditId($auditId)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setCompanyId($companyId)
            ->setCompanyName($companyName)
            ->setCompanyTimezoneId($companyTimezoneId)
            ->setCultureId($cultureId)
            ->setCultureName($cultureName)
            ->setExpirationTimeout($expirationTimeout)
            ->setFallbackCultureId($fallbackCultureId)
            ->setHolderTenantId($holderTenantId)
            ->setIsMasterOrgUnit($isMasterOrgUnit)
            ->setIsSellerOrgUnit($isSellerOrgUnit)
            ->setIsSupplierOrgUnit($isSupplierOrgUnit)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizationUnitLocalId($organizationUnitLocalId)
            ->setOrganizationUnitName($organizationUnitName)
            ->setOrganizationUnitStatus($organizationUnitStatus)
            ->setSalePointId($salePointId)
            ->setSalePointLocalId($salePointLocalId)
            ->setSalePointName($salePointName)
            ->setSecurityTokenId($securityTokenId)
            ->setSecurityTokenLocalId($securityTokenLocalId)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setSiteId($siteId)
            ->setSiteLocalId($siteLocalId)
            ->setSiteName($siteName)
            ->setSiteTimezoneId($siteTimezoneId)
            ->setSystemFallbackCultureId($systemFallbackCultureId)
            ->setTillGroupId($tillGroupId)
            ->setTillGroupLocalId($tillGroupLocalId)
            ->setTillGroupName($tillGroupName)
            ->setTillId($tillId)
            ->setTillLocalId($tillLocalId)
            ->setTillName($tillName)
            ->setUserAllowedToSellNonAllocated($userAllowedToSellNonAllocated)
            ->setUserId($userId)
            ->setUserLocalId($userLocalId)
            ->setUserName($userName)
            ->setUserProfileId($userProfileId)
            ->setUserProfileLocalId($userProfileLocalId)
            ->setUserProfileName($userProfileName)
            ->setUserRoleId($userRoleId)
            ->setUserRoleName($userRoleName)
            ->setWebLinkUri($webLinkUri)
            ->setApplication($application)
            ->setWorkflowType($workflowType)
            ->setIsSgEmailDomain($isSgEmailDomain)
            ->setIsOnboardedToUserAdmin($isOnboardedToUserAdmin)
            ->setShouldSkipOnboardingToUserAdmin($shouldSkipOnboardingToUserAdmin);
    }
    /**
     * Get AffiliateAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAffiliateAccountId()
    {
        return isset($this->AffiliateAccountId) ? $this->AffiliateAccountId : null;
    }
    /**
     * Set AffiliateAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $affiliateAccountId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setAffiliateAccountId($affiliateAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateAccountId) && !is_string($affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateAccountId, true), gettype($affiliateAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($affiliateAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($affiliateAccountId, true)), __LINE__);
        }
        if (is_null($affiliateAccountId) || (is_array($affiliateAccountId) && empty($affiliateAccountId))) {
            unset($this->AffiliateAccountId);
        } else {
            $this->AffiliateAccountId = $affiliateAccountId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\ConnectionProperties
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelId value
     * @return string|null
     */
    public function getApplicationChannelId()
    {
        return $this->ApplicationChannelId;
    }
    /**
     * Set ApplicationChannelId value
     * @param string $applicationChannelId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setApplicationChannelId($applicationChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelId) && !is_string($applicationChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelId, true), gettype($applicationChannelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationChannelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationChannelId, true)), __LINE__);
        }
        $this->ApplicationChannelId = $applicationChannelId;
        return $this;
    }
    /**
     * Get ApplicationChannelLocalId value
     * @return int|null
     */
    public function getApplicationChannelLocalId()
    {
        return $this->ApplicationChannelLocalId;
    }
    /**
     * Set ApplicationChannelLocalId value
     * @param int $applicationChannelLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setApplicationChannelLocalId($applicationChannelLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationChannelLocalId) && !(is_int($applicationChannelLocalId) || ctype_digit($applicationChannelLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationChannelLocalId, true), gettype($applicationChannelLocalId)), __LINE__);
        }
        $this->ApplicationChannelLocalId = $applicationChannelLocalId;
        return $this;
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $applicationChannelName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setApplicationChannelName(\patest\StructType\GlobalString $applicationChannelName = null)
    {
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * @return int|null
     */
    public function getAuditId()
    {
        return $this->AuditId;
    }
    /**
     * Set AuditId value
     * @param int $auditId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        $this->AuditId = $auditId;
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\ConnectionProperties
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get CompanyId value
     * @return string|null
     */
    public function getCompanyId()
    {
        return $this->CompanyId;
    }
    /**
     * Set CompanyId value
     * @param string $companyId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setCompanyId($companyId = null)
    {
        // validation for constraint: string
        if (!is_null($companyId) && !is_string($companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyId, true), gettype($companyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($companyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($companyId, true)), __LINE__);
        }
        $this->CompanyId = $companyId;
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $companyName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setCompanyName(\patest\StructType\GlobalString $companyName = null)
    {
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get CompanyTimezoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyTimezoneId()
    {
        return isset($this->CompanyTimezoneId) ? $this->CompanyTimezoneId : null;
    }
    /**
     * Set CompanyTimezoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyTimezoneId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setCompanyTimezoneId($companyTimezoneId = null)
    {
        // validation for constraint: string
        if (!is_null($companyTimezoneId) && !is_string($companyTimezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyTimezoneId, true), gettype($companyTimezoneId)), __LINE__);
        }
        if (is_null($companyTimezoneId) || (is_array($companyTimezoneId) && empty($companyTimezoneId))) {
            unset($this->CompanyTimezoneId);
        } else {
            $this->CompanyTimezoneId = $companyTimezoneId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * @return int|null
     */
    public function getCultureId()
    {
        return $this->CultureId;
    }
    /**
     * Set CultureId value
     * @param int $cultureId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        $this->CultureId = $cultureId;
        return $this;
    }
    /**
     * Get CultureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureName()
    {
        return isset($this->CultureName) ? $this->CultureName : null;
    }
    /**
     * Set CultureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        if (is_null($cultureName) || (is_array($cultureName) && empty($cultureName))) {
            unset($this->CultureName);
        } else {
            $this->CultureName = $cultureName;
        }
        return $this;
    }
    /**
     * Get ExpirationTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationTimeout()
    {
        return isset($this->ExpirationTimeout) ? $this->ExpirationTimeout : null;
    }
    /**
     * Set ExpirationTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationTimeout
     * @return \patest\StructType\ConnectionProperties
     */
    public function setExpirationTimeout($expirationTimeout = null)
    {
        // validation for constraint: string
        if (!is_null($expirationTimeout) && !is_string($expirationTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationTimeout, true), gettype($expirationTimeout)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($expirationTimeout) && false === mb_strpos($expirationTimeout, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $expirationTimeout)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($expirationTimeout, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($expirationTimeout) && false !== mb_strpos($expirationTimeout, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $expirationTimeout)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($expirationTimeout, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($expirationTimeout) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $expirationTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($expirationTimeout, true)), __LINE__);
        }
        if (is_null($expirationTimeout) || (is_array($expirationTimeout) && empty($expirationTimeout))) {
            unset($this->ExpirationTimeout);
        } else {
            $this->ExpirationTimeout = $expirationTimeout;
        }
        return $this;
    }
    /**
     * Get FallbackCultureId value
     * @return int|null
     */
    public function getFallbackCultureId()
    {
        return $this->FallbackCultureId;
    }
    /**
     * Set FallbackCultureId value
     * @param int $fallbackCultureId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setFallbackCultureId($fallbackCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($fallbackCultureId) && !(is_int($fallbackCultureId) || ctype_digit($fallbackCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fallbackCultureId, true), gettype($fallbackCultureId)), __LINE__);
        }
        $this->FallbackCultureId = $fallbackCultureId;
        return $this;
    }
    /**
     * Get HolderTenantId value
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return $this->HolderTenantId;
    }
    /**
     * Set HolderTenantId value
     * @param int $holderTenantId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        $this->HolderTenantId = $holderTenantId;
        return $this;
    }
    /**
     * Get IsMasterOrgUnit value
     * @return bool|null
     */
    public function getIsMasterOrgUnit()
    {
        return $this->IsMasterOrgUnit;
    }
    /**
     * Set IsMasterOrgUnit value
     * @param bool $isMasterOrgUnit
     * @return \patest\StructType\ConnectionProperties
     */
    public function setIsMasterOrgUnit($isMasterOrgUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMasterOrgUnit) && !is_bool($isMasterOrgUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMasterOrgUnit, true), gettype($isMasterOrgUnit)), __LINE__);
        }
        $this->IsMasterOrgUnit = $isMasterOrgUnit;
        return $this;
    }
    /**
     * Get IsSellerOrgUnit value
     * @return bool|null
     */
    public function getIsSellerOrgUnit()
    {
        return $this->IsSellerOrgUnit;
    }
    /**
     * Set IsSellerOrgUnit value
     * @param bool $isSellerOrgUnit
     * @return \patest\StructType\ConnectionProperties
     */
    public function setIsSellerOrgUnit($isSellerOrgUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellerOrgUnit) && !is_bool($isSellerOrgUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellerOrgUnit, true), gettype($isSellerOrgUnit)), __LINE__);
        }
        $this->IsSellerOrgUnit = $isSellerOrgUnit;
        return $this;
    }
    /**
     * Get IsSupplierOrgUnit value
     * @return bool|null
     */
    public function getIsSupplierOrgUnit()
    {
        return $this->IsSupplierOrgUnit;
    }
    /**
     * Set IsSupplierOrgUnit value
     * @param bool $isSupplierOrgUnit
     * @return \patest\StructType\ConnectionProperties
     */
    public function setIsSupplierOrgUnit($isSupplierOrgUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupplierOrgUnit) && !is_bool($isSupplierOrgUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupplierOrgUnit, true), gettype($isSupplierOrgUnit)), __LINE__);
        }
        $this->IsSupplierOrgUnit = $isSupplierOrgUnit;
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return $this->OrganizationUnitId;
    }
    /**
     * Set OrganizationUnitId value
     * @param string $organizationUnitId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        $this->OrganizationUnitId = $organizationUnitId;
        return $this;
    }
    /**
     * Get OrganizationUnitLocalId value
     * @return int|null
     */
    public function getOrganizationUnitLocalId()
    {
        return $this->OrganizationUnitLocalId;
    }
    /**
     * Set OrganizationUnitLocalId value
     * @param int $organizationUnitLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setOrganizationUnitLocalId($organizationUnitLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($organizationUnitLocalId) && !(is_int($organizationUnitLocalId) || ctype_digit($organizationUnitLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organizationUnitLocalId, true), gettype($organizationUnitLocalId)), __LINE__);
        }
        $this->OrganizationUnitLocalId = $organizationUnitLocalId;
        return $this;
    }
    /**
     * Get OrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitName()
    {
        return isset($this->OrganizationUnitName) ? $this->OrganizationUnitName : null;
    }
    /**
     * Set OrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setOrganizationUnitName($organizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitName) && !is_string($organizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitName, true), gettype($organizationUnitName)), __LINE__);
        }
        if (is_null($organizationUnitName) || (is_array($organizationUnitName) && empty($organizationUnitName))) {
            unset($this->OrganizationUnitName);
        } else {
            $this->OrganizationUnitName = $organizationUnitName;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitStatus value
     * @return string|null
     */
    public function getOrganizationUnitStatus()
    {
        return $this->OrganizationUnitStatus;
    }
    /**
     * Set OrganizationUnitStatus value
     * @uses \patest\EnumType\OrganizationUnitStatus::valueIsValid()
     * @uses \patest\EnumType\OrganizationUnitStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $organizationUnitStatus
     * @return \patest\StructType\ConnectionProperties
     */
    public function setOrganizationUnitStatus($organizationUnitStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrganizationUnitStatus::valueIsValid($organizationUnitStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrganizationUnitStatus', is_array($organizationUnitStatus) ? implode(', ', $organizationUnitStatus) : var_export($organizationUnitStatus, true), implode(', ', \patest\EnumType\OrganizationUnitStatus::getValidValues())), __LINE__);
        }
        $this->OrganizationUnitStatus = $organizationUnitStatus;
        return $this;
    }
    /**
     * Get SalePointId value
     * @return string|null
     */
    public function getSalePointId()
    {
        return $this->SalePointId;
    }
    /**
     * Set SalePointId value
     * @param string $salePointId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        $this->SalePointId = $salePointId;
        return $this;
    }
    /**
     * Get SalePointLocalId value
     * @return int|null
     */
    public function getSalePointLocalId()
    {
        return $this->SalePointLocalId;
    }
    /**
     * Set SalePointLocalId value
     * @param int $salePointLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSalePointLocalId($salePointLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($salePointLocalId) && !(is_int($salePointLocalId) || ctype_digit($salePointLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salePointLocalId, true), gettype($salePointLocalId)), __LINE__);
        }
        $this->SalePointLocalId = $salePointLocalId;
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salePointName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSalePointName(\patest\StructType\GlobalString $salePointName = null)
    {
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return $this->SecurityTokenId;
    }
    /**
     * Set SecurityTokenId value
     * @param string $securityTokenId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        $this->SecurityTokenId = $securityTokenId;
        return $this;
    }
    /**
     * Get SecurityTokenLocalId value
     * @return int|null
     */
    public function getSecurityTokenLocalId()
    {
        return $this->SecurityTokenLocalId;
    }
    /**
     * Set SecurityTokenLocalId value
     * @param int $securityTokenLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSecurityTokenLocalId($securityTokenLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($securityTokenLocalId) && !(is_int($securityTokenLocalId) || ctype_digit($securityTokenLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($securityTokenLocalId, true), gettype($securityTokenLocalId)), __LINE__);
        }
        $this->SecurityTokenLocalId = $securityTokenLocalId;
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $securityTokenName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSecurityTokenName(\patest\StructType\GlobalString $securityTokenName = null)
    {
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * @return string|null
     */
    public function getSiteId()
    {
        return $this->SiteId;
    }
    /**
     * Set SiteId value
     * @param string $siteId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($siteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($siteId, true)), __LINE__);
        }
        $this->SiteId = $siteId;
        return $this;
    }
    /**
     * Get SiteLocalId value
     * @return int|null
     */
    public function getSiteLocalId()
    {
        return $this->SiteLocalId;
    }
    /**
     * Set SiteLocalId value
     * @param int $siteLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSiteLocalId($siteLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($siteLocalId) && !(is_int($siteLocalId) || ctype_digit($siteLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siteLocalId, true), gettype($siteLocalId)), __LINE__);
        }
        $this->SiteLocalId = $siteLocalId;
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $siteName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSiteName(\patest\StructType\GlobalString $siteName = null)
    {
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get SiteTimezoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteTimezoneId()
    {
        return isset($this->SiteTimezoneId) ? $this->SiteTimezoneId : null;
    }
    /**
     * Set SiteTimezoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteTimezoneId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSiteTimezoneId($siteTimezoneId = null)
    {
        // validation for constraint: string
        if (!is_null($siteTimezoneId) && !is_string($siteTimezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteTimezoneId, true), gettype($siteTimezoneId)), __LINE__);
        }
        if (is_null($siteTimezoneId) || (is_array($siteTimezoneId) && empty($siteTimezoneId))) {
            unset($this->SiteTimezoneId);
        } else {
            $this->SiteTimezoneId = $siteTimezoneId;
        }
        return $this;
    }
    /**
     * Get SystemFallbackCultureId value
     * @return int|null
     */
    public function getSystemFallbackCultureId()
    {
        return $this->SystemFallbackCultureId;
    }
    /**
     * Set SystemFallbackCultureId value
     * @param int $systemFallbackCultureId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setSystemFallbackCultureId($systemFallbackCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($systemFallbackCultureId) && !(is_int($systemFallbackCultureId) || ctype_digit($systemFallbackCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemFallbackCultureId, true), gettype($systemFallbackCultureId)), __LINE__);
        }
        $this->SystemFallbackCultureId = $systemFallbackCultureId;
        return $this;
    }
    /**
     * Get TillGroupId value
     * @return string|null
     */
    public function getTillGroupId()
    {
        return $this->TillGroupId;
    }
    /**
     * Set TillGroupId value
     * @param string $tillGroupId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setTillGroupId($tillGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($tillGroupId) && !is_string($tillGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillGroupId, true), gettype($tillGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillGroupId, true)), __LINE__);
        }
        $this->TillGroupId = $tillGroupId;
        return $this;
    }
    /**
     * Get TillGroupLocalId value
     * @return int|null
     */
    public function getTillGroupLocalId()
    {
        return $this->TillGroupLocalId;
    }
    /**
     * Set TillGroupLocalId value
     * @param int $tillGroupLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setTillGroupLocalId($tillGroupLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($tillGroupLocalId) && !(is_int($tillGroupLocalId) || ctype_digit($tillGroupLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tillGroupLocalId, true), gettype($tillGroupLocalId)), __LINE__);
        }
        $this->TillGroupLocalId = $tillGroupLocalId;
        return $this;
    }
    /**
     * Get TillGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTillGroupName()
    {
        return isset($this->TillGroupName) ? $this->TillGroupName : null;
    }
    /**
     * Set TillGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tillGroupName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setTillGroupName(\patest\StructType\GlobalString $tillGroupName = null)
    {
        if (is_null($tillGroupName) || (is_array($tillGroupName) && empty($tillGroupName))) {
            unset($this->TillGroupName);
        } else {
            $this->TillGroupName = $tillGroupName;
        }
        return $this;
    }
    /**
     * Get TillId value
     * @return string|null
     */
    public function getTillId()
    {
        return $this->TillId;
    }
    /**
     * Set TillId value
     * @param string $tillId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        $this->TillId = $tillId;
        return $this;
    }
    /**
     * Get TillLocalId value
     * @return int|null
     */
    public function getTillLocalId()
    {
        return $this->TillLocalId;
    }
    /**
     * Set TillLocalId value
     * @param int $tillLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setTillLocalId($tillLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($tillLocalId) && !(is_int($tillLocalId) || ctype_digit($tillLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tillLocalId, true), gettype($tillLocalId)), __LINE__);
        }
        $this->TillLocalId = $tillLocalId;
        return $this;
    }
    /**
     * Get TillName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTillName()
    {
        return isset($this->TillName) ? $this->TillName : null;
    }
    /**
     * Set TillName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tillName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setTillName(\patest\StructType\GlobalString $tillName = null)
    {
        if (is_null($tillName) || (is_array($tillName) && empty($tillName))) {
            unset($this->TillName);
        } else {
            $this->TillName = $tillName;
        }
        return $this;
    }
    /**
     * Get UserAllowedToSellNonAllocated value
     * @return bool|null
     */
    public function getUserAllowedToSellNonAllocated()
    {
        return $this->UserAllowedToSellNonAllocated;
    }
    /**
     * Set UserAllowedToSellNonAllocated value
     * @param bool $userAllowedToSellNonAllocated
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserAllowedToSellNonAllocated($userAllowedToSellNonAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($userAllowedToSellNonAllocated) && !is_bool($userAllowedToSellNonAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userAllowedToSellNonAllocated, true), gettype($userAllowedToSellNonAllocated)), __LINE__);
        }
        $this->UserAllowedToSellNonAllocated = $userAllowedToSellNonAllocated;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get UserLocalId value
     * @return int|null
     */
    public function getUserLocalId()
    {
        return $this->UserLocalId;
    }
    /**
     * Set UserLocalId value
     * @param int $userLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserLocalId($userLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($userLocalId) && !(is_int($userLocalId) || ctype_digit($userLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userLocalId, true), gettype($userLocalId)), __LINE__);
        }
        $this->UserLocalId = $userLocalId;
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get UserProfileId value
     * @return string|null
     */
    public function getUserProfileId()
    {
        return $this->UserProfileId;
    }
    /**
     * Set UserProfileId value
     * @param string $userProfileId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserProfileId($userProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($userProfileId) && !is_string($userProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userProfileId, true), gettype($userProfileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userProfileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userProfileId, true)), __LINE__);
        }
        $this->UserProfileId = $userProfileId;
        return $this;
    }
    /**
     * Get UserProfileLocalId value
     * @return int|null
     */
    public function getUserProfileLocalId()
    {
        return $this->UserProfileLocalId;
    }
    /**
     * Set UserProfileLocalId value
     * @param int $userProfileLocalId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserProfileLocalId($userProfileLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($userProfileLocalId) && !(is_int($userProfileLocalId) || ctype_digit($userProfileLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userProfileLocalId, true), gettype($userProfileLocalId)), __LINE__);
        }
        $this->UserProfileLocalId = $userProfileLocalId;
        return $this;
    }
    /**
     * Get UserProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getUserProfileName()
    {
        return isset($this->UserProfileName) ? $this->UserProfileName : null;
    }
    /**
     * Set UserProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $userProfileName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserProfileName(\patest\StructType\GlobalString $userProfileName = null)
    {
        if (is_null($userProfileName) || (is_array($userProfileName) && empty($userProfileName))) {
            unset($this->UserProfileName);
        } else {
            $this->UserProfileName = $userProfileName;
        }
        return $this;
    }
    /**
     * Get UserRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserRoleId()
    {
        return isset($this->UserRoleId) ? $this->UserRoleId : null;
    }
    /**
     * Set UserRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userRoleId
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserRoleId($userRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($userRoleId) && !is_string($userRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRoleId, true), gettype($userRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userRoleId, true)), __LINE__);
        }
        if (is_null($userRoleId) || (is_array($userRoleId) && empty($userRoleId))) {
            unset($this->UserRoleId);
        } else {
            $this->UserRoleId = $userRoleId;
        }
        return $this;
    }
    /**
     * Get UserRoleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getUserRoleName()
    {
        return isset($this->UserRoleName) ? $this->UserRoleName : null;
    }
    /**
     * Set UserRoleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $userRoleName
     * @return \patest\StructType\ConnectionProperties
     */
    public function setUserRoleName(\patest\StructType\GlobalString $userRoleName = null)
    {
        if (is_null($userRoleName) || (is_array($userRoleName) && empty($userRoleName))) {
            unset($this->UserRoleName);
        } else {
            $this->UserRoleName = $userRoleName;
        }
        return $this;
    }
    /**
     * Get WebLinkUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebLinkUri()
    {
        return isset($this->WebLinkUri) ? $this->WebLinkUri : null;
    }
    /**
     * Set WebLinkUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webLinkUri
     * @return \patest\StructType\ConnectionProperties
     */
    public function setWebLinkUri($webLinkUri = null)
    {
        // validation for constraint: string
        if (!is_null($webLinkUri) && !is_string($webLinkUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webLinkUri, true), gettype($webLinkUri)), __LINE__);
        }
        if (is_null($webLinkUri) || (is_array($webLinkUri) && empty($webLinkUri))) {
            unset($this->WebLinkUri);
        } else {
            $this->WebLinkUri = $webLinkUri;
        }
        return $this;
    }
    /**
     * Get Application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplication()
    {
        return isset($this->Application) ? $this->Application : null;
    }
    /**
     * Set Application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $application
     * @return \patest\StructType\ConnectionProperties
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->Application);
        } else {
            $this->Application = $application;
        }
        return $this;
    }
    /**
     * Get WorkflowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkflowType()
    {
        return isset($this->WorkflowType) ? $this->WorkflowType : null;
    }
    /**
     * Set WorkflowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkflowType::valueIsValid()
     * @uses \patest\EnumType\WorkflowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workflowType
     * @return \patest\StructType\ConnectionProperties
     */
    public function setWorkflowType($workflowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkflowType::valueIsValid($workflowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkflowType', is_array($workflowType) ? implode(', ', $workflowType) : var_export($workflowType, true), implode(', ', \patest\EnumType\WorkflowType::getValidValues())), __LINE__);
        }
        if (is_null($workflowType) || (is_array($workflowType) && empty($workflowType))) {
            unset($this->WorkflowType);
        } else {
            $this->WorkflowType = $workflowType;
        }
        return $this;
    }
    /**
     * Get IsSgEmailDomain value
     * @return bool|null
     */
    public function getIsSgEmailDomain()
    {
        return $this->IsSgEmailDomain;
    }
    /**
     * Set IsSgEmailDomain value
     * @param bool $isSgEmailDomain
     * @return \patest\StructType\ConnectionProperties
     */
    public function setIsSgEmailDomain($isSgEmailDomain = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSgEmailDomain) && !is_bool($isSgEmailDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSgEmailDomain, true), gettype($isSgEmailDomain)), __LINE__);
        }
        $this->IsSgEmailDomain = $isSgEmailDomain;
        return $this;
    }
    /**
     * Get IsOnboardedToUserAdmin value
     * @return bool|null
     */
    public function getIsOnboardedToUserAdmin()
    {
        return $this->IsOnboardedToUserAdmin;
    }
    /**
     * Set IsOnboardedToUserAdmin value
     * @param bool $isOnboardedToUserAdmin
     * @return \patest\StructType\ConnectionProperties
     */
    public function setIsOnboardedToUserAdmin($isOnboardedToUserAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnboardedToUserAdmin) && !is_bool($isOnboardedToUserAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnboardedToUserAdmin, true), gettype($isOnboardedToUserAdmin)), __LINE__);
        }
        $this->IsOnboardedToUserAdmin = $isOnboardedToUserAdmin;
        return $this;
    }
    /**
     * Get ShouldSkipOnboardingToUserAdmin value
     * @return bool|null
     */
    public function getShouldSkipOnboardingToUserAdmin()
    {
        return $this->ShouldSkipOnboardingToUserAdmin;
    }
    /**
     * Set ShouldSkipOnboardingToUserAdmin value
     * @param bool $shouldSkipOnboardingToUserAdmin
     * @return \patest\StructType\ConnectionProperties
     */
    public function setShouldSkipOnboardingToUserAdmin($shouldSkipOnboardingToUserAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldSkipOnboardingToUserAdmin) && !is_bool($shouldSkipOnboardingToUserAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldSkipOnboardingToUserAdmin, true), gettype($shouldSkipOnboardingToUserAdmin)), __LINE__);
        }
        $this->ShouldSkipOnboardingToUserAdmin = $shouldSkipOnboardingToUserAdmin;
        return $this;
    }
}
