<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionPriceModifier StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommissionPriceModifier
 * @subpackage Structs
 */
class CommissionPriceModifier extends AbstractPriceModifier
{
    /**
     * The FinancialJournalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public $FinancialJournalInfo;
    /**
     * The AdjustedEffectiveAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $AdjustedEffectiveAmount;
    /**
     * Constructor method for CommissionPriceModifier
     * @uses CommissionPriceModifier::setFinancialJournalInfo()
     * @uses CommissionPriceModifier::setAdjustedEffectiveAmount()
     * @param \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo
     * @param \patest\StructType\Money $adjustedEffectiveAmount
     */
    public function __construct(\patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo = null, \patest\StructType\Money $adjustedEffectiveAmount = null)
    {
        $this
            ->setFinancialJournalInfo($financialJournalInfo)
            ->setAdjustedEffectiveAmount($adjustedEffectiveAmount);
    }
    /**
     * Get FinancialJournalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionElementFinancialJournalInfo|null
     */
    public function getFinancialJournalInfo()
    {
        return isset($this->FinancialJournalInfo) ? $this->FinancialJournalInfo : null;
    }
    /**
     * Set FinancialJournalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo
     * @return \patest\StructType\CommissionPriceModifier
     */
    public function setFinancialJournalInfo(\patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo = null)
    {
        if (is_null($financialJournalInfo) || (is_array($financialJournalInfo) && empty($financialJournalInfo))) {
            unset($this->FinancialJournalInfo);
        } else {
            $this->FinancialJournalInfo = $financialJournalInfo;
        }
        return $this;
    }
    /**
     * Get AdjustedEffectiveAmount value
     * @return \patest\StructType\Money|null
     */
    public function getAdjustedEffectiveAmount()
    {
        return $this->AdjustedEffectiveAmount;
    }
    /**
     * Set AdjustedEffectiveAmount value
     * @param \patest\StructType\Money $adjustedEffectiveAmount
     * @return \patest\StructType\CommissionPriceModifier
     */
    public function setAdjustedEffectiveAmount(\patest\StructType\Money $adjustedEffectiveAmount = null)
    {
        $this->AdjustedEffectiveAmount = $adjustedEffectiveAmount;
        return $this;
    }
}
