<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeResolution StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CodeResolution
 * @subpackage Structs
 */
class CodeResolution extends AbstractStructBase
{
    /**
     * The AccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_AccessCode
     */
    public $AccessCode;
    /**
     * The Presale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Presale
     */
    public $Presale;
    /**
     * Constructor method for CodeResolution
     * @uses CodeResolution::setAccessCode()
     * @uses CodeResolution::setPresale()
     * @param \patest\StructType\Ticketing_AccessCode $accessCode
     * @param \patest\StructType\Ticketing_Presale $presale
     */
    public function __construct(\patest\StructType\Ticketing_AccessCode $accessCode = null, \patest\StructType\Ticketing_Presale $presale = null)
    {
        $this
            ->setAccessCode($accessCode)
            ->setPresale($presale);
    }
    /**
     * Get AccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_AccessCode|null
     */
    public function getAccessCode()
    {
        return isset($this->AccessCode) ? $this->AccessCode : null;
    }
    /**
     * Set AccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_AccessCode $accessCode
     * @return \patest\StructType\CodeResolution
     */
    public function setAccessCode(\patest\StructType\Ticketing_AccessCode $accessCode = null)
    {
        if (is_null($accessCode) || (is_array($accessCode) && empty($accessCode))) {
            unset($this->AccessCode);
        } else {
            $this->AccessCode = $accessCode;
        }
        return $this;
    }
    /**
     * Get Presale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Presale|null
     */
    public function getPresale()
    {
        return isset($this->Presale) ? $this->Presale : null;
    }
    /**
     * Set Presale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Presale $presale
     * @return \patest\StructType\CodeResolution
     */
    public function setPresale(\patest\StructType\Ticketing_Presale $presale = null)
    {
        if (is_null($presale) || (is_array($presale) && empty($presale))) {
            unset($this->Presale);
        } else {
            $this->Presale = $presale;
        }
        return $this;
    }
}
