<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientTicketDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientTicketDetails
 * @subpackage Structs
 */
class ClientTicketDetails extends AbstractStructBase
{
    /**
     * The AllDayEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllDayEvent;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CanBeCancelledResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBeCancelledResale;
    /**
     * The CanBeDistributed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBeDistributed;
    /**
     * The CanBeDonated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBeDonated;
    /**
     * The CanBeForwarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBeForwarded;
    /**
     * The CanBePutOnResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBePutOnResale;
    /**
     * The CanBeRecalled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBeRecalled;
    /**
     * The DateFormatOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFormatOptions;
    /**
     * The EventDateUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateUtc;
    /**
     * The EventFormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventFormattedDate;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The GatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatesSummary;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The HasTicketHolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasTicketHolder;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsDistributed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDistributed;
    /**
     * The IsForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForResale;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinted;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResale;
    /**
     * The IsScanned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsScanned;
    /**
     * The IsSubscriptionTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriptionTicket;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The Nfc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nfc;
    /**
     * The OnlineDateFormatAdditionalText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDateFormatAdditionalText;
    /**
     * The OwnerCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerCrmId;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The PriceTypeColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeColor;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserId;
    /**
     * The ResaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleStatus;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeName;
    /**
     * The ShowMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShowMinutes;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandName;
    /**
     * The TicketHolderEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketHolderEmail;
    /**
     * The TicketHolderFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketHolderFirstName;
    /**
     * The TicketHolderLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketHolderLastName;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The TurnstilesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstilesSummary;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VenueName;
    /**
     * Constructor method for ClientTicketDetails
     * @uses ClientTicketDetails::setAllDayEvent()
     * @uses ClientTicketDetails::setAreaName()
     * @uses ClientTicketDetails::setBarcode()
     * @uses ClientTicketDetails::setCanBeCancelledResale()
     * @uses ClientTicketDetails::setCanBeDistributed()
     * @uses ClientTicketDetails::setCanBeDonated()
     * @uses ClientTicketDetails::setCanBeForwarded()
     * @uses ClientTicketDetails::setCanBePutOnResale()
     * @uses ClientTicketDetails::setCanBeRecalled()
     * @uses ClientTicketDetails::setDateFormatOptions()
     * @uses ClientTicketDetails::setEventDateUtc()
     * @uses ClientTicketDetails::setEventFormattedDate()
     * @uses ClientTicketDetails::setEventGuid()
     * @uses ClientTicketDetails::setEventName()
     * @uses ClientTicketDetails::setGatesSummary()
     * @uses ClientTicketDetails::setHallName()
     * @uses ClientTicketDetails::setHasTicketHolder()
     * @uses ClientTicketDetails::setId()
     * @uses ClientTicketDetails::setIsDistributed()
     * @uses ClientTicketDetails::setIsForResale()
     * @uses ClientTicketDetails::setIsPrinted()
     * @uses ClientTicketDetails::setIsResale()
     * @uses ClientTicketDetails::setIsScanned()
     * @uses ClientTicketDetails::setIsSubscriptionTicket()
     * @uses ClientTicketDetails::setIsValid()
     * @uses ClientTicketDetails::setLocalId()
     * @uses ClientTicketDetails::setNfc()
     * @uses ClientTicketDetails::setOnlineDateFormatAdditionalText()
     * @uses ClientTicketDetails::setOwnerCrmId()
     * @uses ClientTicketDetails::setOwnerId()
     * @uses ClientTicketDetails::setOwnerName()
     * @uses ClientTicketDetails::setPriceLevelName()
     * @uses ClientTicketDetails::setPriceTypeColor()
     * @uses ClientTicketDetails::setPriceTypeId()
     * @uses ClientTicketDetails::setPriceTypeName()
     * @uses ClientTicketDetails::setPurchaserId()
     * @uses ClientTicketDetails::setResaleStatus()
     * @uses ClientTicketDetails::setRowName()
     * @uses ClientTicketDetails::setSeatName()
     * @uses ClientTicketDetails::setSeatTypeName()
     * @uses ClientTicketDetails::setShowMinutes()
     * @uses ClientTicketDetails::setStandName()
     * @uses ClientTicketDetails::setTicketHolderEmail()
     * @uses ClientTicketDetails::setTicketHolderFirstName()
     * @uses ClientTicketDetails::setTicketHolderLastName()
     * @uses ClientTicketDetails::setTicketNumber()
     * @uses ClientTicketDetails::setTotalPrice()
     * @uses ClientTicketDetails::setTurnstilesSummary()
     * @uses ClientTicketDetails::setVenueName()
     * @param bool $allDayEvent
     * @param string $areaName
     * @param string $barcode
     * @param bool $canBeCancelledResale
     * @param bool $canBeDistributed
     * @param bool $canBeDonated
     * @param bool $canBeForwarded
     * @param bool $canBePutOnResale
     * @param bool $canBeRecalled
     * @param string $dateFormatOptions
     * @param string $eventDateUtc
     * @param string $eventFormattedDate
     * @param string $eventGuid
     * @param string $eventName
     * @param string $gatesSummary
     * @param string $hallName
     * @param bool $hasTicketHolder
     * @param string $id
     * @param bool $isDistributed
     * @param bool $isForResale
     * @param bool $isPrinted
     * @param bool $isResale
     * @param bool $isScanned
     * @param bool $isSubscriptionTicket
     * @param bool $isValid
     * @param int $localId
     * @param string $nfc
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @param string $ownerCrmId
     * @param string $ownerId
     * @param string $ownerName
     * @param string $priceLevelName
     * @param string $priceTypeColor
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string $purchaserId
     * @param string $resaleStatus
     * @param string $rowName
     * @param string $seatName
     * @param string $seatTypeName
     * @param int $showMinutes
     * @param string $standName
     * @param string $ticketHolderEmail
     * @param string $ticketHolderFirstName
     * @param string $ticketHolderLastName
     * @param int $ticketNumber
     * @param \patest\StructType\Money $totalPrice
     * @param string $turnstilesSummary
     * @param string $venueName
     */
    public function __construct($allDayEvent = null, $areaName = null, $barcode = null, $canBeCancelledResale = null, $canBeDistributed = null, $canBeDonated = null, $canBeForwarded = null, $canBePutOnResale = null, $canBeRecalled = null, $dateFormatOptions = null, $eventDateUtc = null, $eventFormattedDate = null, $eventGuid = null, $eventName = null, $gatesSummary = null, $hallName = null, $hasTicketHolder = null, $id = null, $isDistributed = null, $isForResale = null, $isPrinted = null, $isResale = null, $isScanned = null, $isSubscriptionTicket = null, $isValid = null, $localId = null, $nfc = null, \patest\StructType\GlobalString $onlineDateFormatAdditionalText = null, $ownerCrmId = null, $ownerId = null, $ownerName = null, $priceLevelName = null, $priceTypeColor = null, $priceTypeId = null, $priceTypeName = null, $purchaserId = null, $resaleStatus = null, $rowName = null, $seatName = null, $seatTypeName = null, $showMinutes = null, $standName = null, $ticketHolderEmail = null, $ticketHolderFirstName = null, $ticketHolderLastName = null, $ticketNumber = null, \patest\StructType\Money $totalPrice = null, $turnstilesSummary = null, $venueName = null)
    {
        $this
            ->setAllDayEvent($allDayEvent)
            ->setAreaName($areaName)
            ->setBarcode($barcode)
            ->setCanBeCancelledResale($canBeCancelledResale)
            ->setCanBeDistributed($canBeDistributed)
            ->setCanBeDonated($canBeDonated)
            ->setCanBeForwarded($canBeForwarded)
            ->setCanBePutOnResale($canBePutOnResale)
            ->setCanBeRecalled($canBeRecalled)
            ->setDateFormatOptions($dateFormatOptions)
            ->setEventDateUtc($eventDateUtc)
            ->setEventFormattedDate($eventFormattedDate)
            ->setEventGuid($eventGuid)
            ->setEventName($eventName)
            ->setGatesSummary($gatesSummary)
            ->setHallName($hallName)
            ->setHasTicketHolder($hasTicketHolder)
            ->setId($id)
            ->setIsDistributed($isDistributed)
            ->setIsForResale($isForResale)
            ->setIsPrinted($isPrinted)
            ->setIsResale($isResale)
            ->setIsScanned($isScanned)
            ->setIsSubscriptionTicket($isSubscriptionTicket)
            ->setIsValid($isValid)
            ->setLocalId($localId)
            ->setNfc($nfc)
            ->setOnlineDateFormatAdditionalText($onlineDateFormatAdditionalText)
            ->setOwnerCrmId($ownerCrmId)
            ->setOwnerId($ownerId)
            ->setOwnerName($ownerName)
            ->setPriceLevelName($priceLevelName)
            ->setPriceTypeColor($priceTypeColor)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setPurchaserId($purchaserId)
            ->setResaleStatus($resaleStatus)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSeatTypeName($seatTypeName)
            ->setShowMinutes($showMinutes)
            ->setStandName($standName)
            ->setTicketHolderEmail($ticketHolderEmail)
            ->setTicketHolderFirstName($ticketHolderFirstName)
            ->setTicketHolderLastName($ticketHolderLastName)
            ->setTicketNumber($ticketNumber)
            ->setTotalPrice($totalPrice)
            ->setTurnstilesSummary($turnstilesSummary)
            ->setVenueName($venueName);
    }
    /**
     * Get AllDayEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllDayEvent()
    {
        return isset($this->AllDayEvent) ? $this->AllDayEvent : null;
    }
    /**
     * Set AllDayEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allDayEvent
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setAllDayEvent($allDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($allDayEvent) && !is_bool($allDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allDayEvent, true), gettype($allDayEvent)), __LINE__);
        }
        if (is_null($allDayEvent) || (is_array($allDayEvent) && empty($allDayEvent))) {
            unset($this->AllDayEvent);
        } else {
            $this->AllDayEvent = $allDayEvent;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CanBeCancelledResale value
     * @return bool|null
     */
    public function getCanBeCancelledResale()
    {
        return $this->CanBeCancelledResale;
    }
    /**
     * Set CanBeCancelledResale value
     * @param bool $canBeCancelledResale
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setCanBeCancelledResale($canBeCancelledResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeCancelledResale) && !is_bool($canBeCancelledResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeCancelledResale, true), gettype($canBeCancelledResale)), __LINE__);
        }
        $this->CanBeCancelledResale = $canBeCancelledResale;
        return $this;
    }
    /**
     * Get CanBeDistributed value
     * @return bool|null
     */
    public function getCanBeDistributed()
    {
        return $this->CanBeDistributed;
    }
    /**
     * Set CanBeDistributed value
     * @param bool $canBeDistributed
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setCanBeDistributed($canBeDistributed = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeDistributed) && !is_bool($canBeDistributed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeDistributed, true), gettype($canBeDistributed)), __LINE__);
        }
        $this->CanBeDistributed = $canBeDistributed;
        return $this;
    }
    /**
     * Get CanBeDonated value
     * @return bool|null
     */
    public function getCanBeDonated()
    {
        return $this->CanBeDonated;
    }
    /**
     * Set CanBeDonated value
     * @param bool $canBeDonated
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setCanBeDonated($canBeDonated = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeDonated) && !is_bool($canBeDonated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeDonated, true), gettype($canBeDonated)), __LINE__);
        }
        $this->CanBeDonated = $canBeDonated;
        return $this;
    }
    /**
     * Get CanBeForwarded value
     * @return bool|null
     */
    public function getCanBeForwarded()
    {
        return $this->CanBeForwarded;
    }
    /**
     * Set CanBeForwarded value
     * @param bool $canBeForwarded
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setCanBeForwarded($canBeForwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeForwarded) && !is_bool($canBeForwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeForwarded, true), gettype($canBeForwarded)), __LINE__);
        }
        $this->CanBeForwarded = $canBeForwarded;
        return $this;
    }
    /**
     * Get CanBePutOnResale value
     * @return bool|null
     */
    public function getCanBePutOnResale()
    {
        return $this->CanBePutOnResale;
    }
    /**
     * Set CanBePutOnResale value
     * @param bool $canBePutOnResale
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setCanBePutOnResale($canBePutOnResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBePutOnResale) && !is_bool($canBePutOnResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBePutOnResale, true), gettype($canBePutOnResale)), __LINE__);
        }
        $this->CanBePutOnResale = $canBePutOnResale;
        return $this;
    }
    /**
     * Get CanBeRecalled value
     * @return bool|null
     */
    public function getCanBeRecalled()
    {
        return $this->CanBeRecalled;
    }
    /**
     * Set CanBeRecalled value
     * @param bool $canBeRecalled
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setCanBeRecalled($canBeRecalled = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeRecalled) && !is_bool($canBeRecalled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeRecalled, true), gettype($canBeRecalled)), __LINE__);
        }
        $this->CanBeRecalled = $canBeRecalled;
        return $this;
    }
    /**
     * Get DateFormatOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFormatOptions()
    {
        return isset($this->DateFormatOptions) ? $this->DateFormatOptions : null;
    }
    /**
     * Set DateFormatOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventDateFormatOptions::valueIsValid()
     * @uses \patest\EnumType\EventDateFormatOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateFormatOptions
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setDateFormatOptions($dateFormatOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventDateFormatOptions::valueIsValid($dateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventDateFormatOptions', is_array($dateFormatOptions) ? implode(', ', $dateFormatOptions) : var_export($dateFormatOptions, true), implode(', ', \patest\EnumType\EventDateFormatOptions::getValidValues())), __LINE__);
        }
        if (is_null($dateFormatOptions) || (is_array($dateFormatOptions) && empty($dateFormatOptions))) {
            unset($this->DateFormatOptions);
        } else {
            $this->DateFormatOptions = $dateFormatOptions;
        }
        return $this;
    }
    /**
     * Get EventDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateUtc()
    {
        return isset($this->EventDateUtc) ? $this->EventDateUtc : null;
    }
    /**
     * Set EventDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateUtc
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setEventDateUtc($eventDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateUtc) && !is_string($eventDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateUtc, true), gettype($eventDateUtc)), __LINE__);
        }
        if (is_null($eventDateUtc) || (is_array($eventDateUtc) && empty($eventDateUtc))) {
            unset($this->EventDateUtc);
        } else {
            $this->EventDateUtc = $eventDateUtc;
        }
        return $this;
    }
    /**
     * Get EventFormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventFormattedDate()
    {
        return isset($this->EventFormattedDate) ? $this->EventFormattedDate : null;
    }
    /**
     * Set EventFormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventFormattedDate
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setEventFormattedDate($eventFormattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventFormattedDate) && !is_string($eventFormattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventFormattedDate, true), gettype($eventFormattedDate)), __LINE__);
        }
        if (is_null($eventFormattedDate) || (is_array($eventFormattedDate) && empty($eventFormattedDate))) {
            unset($this->EventFormattedDate);
        } else {
            $this->EventFormattedDate = $eventFormattedDate;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get GatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatesSummary()
    {
        return isset($this->GatesSummary) ? $this->GatesSummary : null;
    }
    /**
     * Set GatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatesSummary
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setGatesSummary($gatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($gatesSummary) && !is_string($gatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatesSummary, true), gettype($gatesSummary)), __LINE__);
        }
        if (is_null($gatesSummary) || (is_array($gatesSummary) && empty($gatesSummary))) {
            unset($this->GatesSummary);
        } else {
            $this->GatesSummary = $gatesSummary;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HasTicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasTicketHolder()
    {
        return isset($this->HasTicketHolder) ? $this->HasTicketHolder : null;
    }
    /**
     * Set HasTicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasTicketHolder
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setHasTicketHolder($hasTicketHolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTicketHolder) && !is_bool($hasTicketHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTicketHolder, true), gettype($hasTicketHolder)), __LINE__);
        }
        if (is_null($hasTicketHolder) || (is_array($hasTicketHolder) && empty($hasTicketHolder))) {
            unset($this->HasTicketHolder);
        } else {
            $this->HasTicketHolder = $hasTicketHolder;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsDistributed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDistributed()
    {
        return isset($this->IsDistributed) ? $this->IsDistributed : null;
    }
    /**
     * Set IsDistributed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDistributed
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsDistributed($isDistributed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDistributed) && !is_bool($isDistributed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDistributed, true), gettype($isDistributed)), __LINE__);
        }
        if (is_null($isDistributed) || (is_array($isDistributed) && empty($isDistributed))) {
            unset($this->IsDistributed);
        } else {
            $this->IsDistributed = $isDistributed;
        }
        return $this;
    }
    /**
     * Get IsForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForResale()
    {
        return isset($this->IsForResale) ? $this->IsForResale : null;
    }
    /**
     * Set IsForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForResale
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsForResale($isForResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForResale) && !is_bool($isForResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForResale, true), gettype($isForResale)), __LINE__);
        }
        if (is_null($isForResale) || (is_array($isForResale) && empty($isForResale))) {
            unset($this->IsForResale);
        } else {
            $this->IsForResale = $isForResale;
        }
        return $this;
    }
    /**
     * Get IsPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return isset($this->IsPrinted) ? $this->IsPrinted : null;
    }
    /**
     * Set IsPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinted
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        if (is_null($isPrinted) || (is_array($isPrinted) && empty($isPrinted))) {
            unset($this->IsPrinted);
        } else {
            $this->IsPrinted = $isPrinted;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResale()
    {
        return isset($this->IsResale) ? $this->IsResale : null;
    }
    /**
     * Set IsResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResale
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        if (is_null($isResale) || (is_array($isResale) && empty($isResale))) {
            unset($this->IsResale);
        } else {
            $this->IsResale = $isResale;
        }
        return $this;
    }
    /**
     * Get IsScanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsScanned()
    {
        return isset($this->IsScanned) ? $this->IsScanned : null;
    }
    /**
     * Set IsScanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isScanned
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsScanned($isScanned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isScanned) && !is_bool($isScanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isScanned, true), gettype($isScanned)), __LINE__);
        }
        if (is_null($isScanned) || (is_array($isScanned) && empty($isScanned))) {
            unset($this->IsScanned);
        } else {
            $this->IsScanned = $isScanned;
        }
        return $this;
    }
    /**
     * Get IsSubscriptionTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriptionTicket()
    {
        return isset($this->IsSubscriptionTicket) ? $this->IsSubscriptionTicket : null;
    }
    /**
     * Set IsSubscriptionTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriptionTicket
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsSubscriptionTicket($isSubscriptionTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriptionTicket) && !is_bool($isSubscriptionTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriptionTicket, true), gettype($isSubscriptionTicket)), __LINE__);
        }
        if (is_null($isSubscriptionTicket) || (is_array($isSubscriptionTicket) && empty($isSubscriptionTicket))) {
            unset($this->IsSubscriptionTicket);
        } else {
            $this->IsSubscriptionTicket = $isSubscriptionTicket;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get Nfc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNfc()
    {
        return isset($this->Nfc) ? $this->Nfc : null;
    }
    /**
     * Set Nfc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nfc
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setNfc($nfc = null)
    {
        // validation for constraint: string
        if (!is_null($nfc) && !is_string($nfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nfc, true), gettype($nfc)), __LINE__);
        }
        if (is_null($nfc) || (is_array($nfc) && empty($nfc))) {
            unset($this->Nfc);
        } else {
            $this->Nfc = $nfc;
        }
        return $this;
    }
    /**
     * Get OnlineDateFormatAdditionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDateFormatAdditionalText()
    {
        return isset($this->OnlineDateFormatAdditionalText) ? $this->OnlineDateFormatAdditionalText : null;
    }
    /**
     * Set OnlineDateFormatAdditionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setOnlineDateFormatAdditionalText(\patest\StructType\GlobalString $onlineDateFormatAdditionalText = null)
    {
        if (is_null($onlineDateFormatAdditionalText) || (is_array($onlineDateFormatAdditionalText) && empty($onlineDateFormatAdditionalText))) {
            unset($this->OnlineDateFormatAdditionalText);
        } else {
            $this->OnlineDateFormatAdditionalText = $onlineDateFormatAdditionalText;
        }
        return $this;
    }
    /**
     * Get OwnerCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerCrmId()
    {
        return isset($this->OwnerCrmId) ? $this->OwnerCrmId : null;
    }
    /**
     * Set OwnerCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerCrmId
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setOwnerCrmId($ownerCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCrmId) && !is_string($ownerCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCrmId, true), gettype($ownerCrmId)), __LINE__);
        }
        if (is_null($ownerCrmId) || (is_array($ownerCrmId) && empty($ownerCrmId))) {
            unset($this->OwnerCrmId);
        } else {
            $this->OwnerCrmId = $ownerCrmId;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceTypeColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeColor()
    {
        return isset($this->PriceTypeColor) ? $this->PriceTypeColor : null;
    }
    /**
     * Set PriceTypeColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeColor
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setPriceTypeColor($priceTypeColor = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeColor) && !is_string($priceTypeColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeColor, true), gettype($priceTypeColor)), __LINE__);
        }
        if (is_null($priceTypeColor) || (is_array($priceTypeColor) && empty($priceTypeColor))) {
            unset($this->PriceTypeColor);
        } else {
            $this->PriceTypeColor = $priceTypeColor;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return $this->PriceTypeId;
    }
    /**
     * Set PriceTypeId value
     * @param string $priceTypeId
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        $this->PriceTypeId = $priceTypeId;
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserId
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserId) && !is_string($purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserId, true)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get ResaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleStatus()
    {
        return isset($this->ResaleStatus) ? $this->ResaleStatus : null;
    }
    /**
     * Set ResaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResaleStatus::valueIsValid()
     * @uses \patest\EnumType\ResaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleStatus
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setResaleStatus($resaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResaleStatus::valueIsValid($resaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResaleStatus', is_array($resaleStatus) ? implode(', ', $resaleStatus) : var_export($resaleStatus, true), implode(', ', \patest\EnumType\ResaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($resaleStatus) || (is_array($resaleStatus) && empty($resaleStatus))) {
            unset($this->ResaleStatus);
        } else {
            $this->ResaleStatus = $resaleStatus;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeName()
    {
        return isset($this->SeatTypeName) ? $this->SeatTypeName : null;
    }
    /**
     * Set SeatTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setSeatTypeName($seatTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeName) && !is_string($seatTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeName, true), gettype($seatTypeName)), __LINE__);
        }
        if (is_null($seatTypeName) || (is_array($seatTypeName) && empty($seatTypeName))) {
            unset($this->SeatTypeName);
        } else {
            $this->SeatTypeName = $seatTypeName;
        }
        return $this;
    }
    /**
     * Get ShowMinutes value
     * @return int|null
     */
    public function getShowMinutes()
    {
        return $this->ShowMinutes;
    }
    /**
     * Set ShowMinutes value
     * @param int $showMinutes
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setShowMinutes($showMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($showMinutes) && !(is_int($showMinutes) || ctype_digit($showMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showMinutes, true), gettype($showMinutes)), __LINE__);
        }
        $this->ShowMinutes = $showMinutes;
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setStandName($standName = null)
    {
        // validation for constraint: string
        if (!is_null($standName) && !is_string($standName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standName, true), gettype($standName)), __LINE__);
        }
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get TicketHolderEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketHolderEmail()
    {
        return isset($this->TicketHolderEmail) ? $this->TicketHolderEmail : null;
    }
    /**
     * Set TicketHolderEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketHolderEmail
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setTicketHolderEmail($ticketHolderEmail = null)
    {
        // validation for constraint: string
        if (!is_null($ticketHolderEmail) && !is_string($ticketHolderEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketHolderEmail, true), gettype($ticketHolderEmail)), __LINE__);
        }
        if (is_null($ticketHolderEmail) || (is_array($ticketHolderEmail) && empty($ticketHolderEmail))) {
            unset($this->TicketHolderEmail);
        } else {
            $this->TicketHolderEmail = $ticketHolderEmail;
        }
        return $this;
    }
    /**
     * Get TicketHolderFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketHolderFirstName()
    {
        return isset($this->TicketHolderFirstName) ? $this->TicketHolderFirstName : null;
    }
    /**
     * Set TicketHolderFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketHolderFirstName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setTicketHolderFirstName($ticketHolderFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketHolderFirstName) && !is_string($ticketHolderFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketHolderFirstName, true), gettype($ticketHolderFirstName)), __LINE__);
        }
        if (is_null($ticketHolderFirstName) || (is_array($ticketHolderFirstName) && empty($ticketHolderFirstName))) {
            unset($this->TicketHolderFirstName);
        } else {
            $this->TicketHolderFirstName = $ticketHolderFirstName;
        }
        return $this;
    }
    /**
     * Get TicketHolderLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketHolderLastName()
    {
        return isset($this->TicketHolderLastName) ? $this->TicketHolderLastName : null;
    }
    /**
     * Set TicketHolderLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketHolderLastName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setTicketHolderLastName($ticketHolderLastName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketHolderLastName) && !is_string($ticketHolderLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketHolderLastName, true), gettype($ticketHolderLastName)), __LINE__);
        }
        if (is_null($ticketHolderLastName) || (is_array($ticketHolderLastName) && empty($ticketHolderLastName))) {
            unset($this->TicketHolderLastName);
        } else {
            $this->TicketHolderLastName = $ticketHolderLastName;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get TurnstilesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstilesSummary()
    {
        return isset($this->TurnstilesSummary) ? $this->TurnstilesSummary : null;
    }
    /**
     * Set TurnstilesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstilesSummary
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setTurnstilesSummary($turnstilesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($turnstilesSummary) && !is_string($turnstilesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstilesSummary, true), gettype($turnstilesSummary)), __LINE__);
        }
        if (is_null($turnstilesSummary) || (is_array($turnstilesSummary) && empty($turnstilesSummary))) {
            unset($this->TurnstilesSummary);
        } else {
            $this->TurnstilesSummary = $turnstilesSummary;
        }
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueName
     * @return \patest\StructType\ClientTicketDetails
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
}
