<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientEnrollmentsQueryRequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientEnrollmentsQueryRequestBase
 * @subpackage Structs
 */
class ClientEnrollmentsQueryRequestBase extends ExtensibleDataContract
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The TicketSchemeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketSchemeIds;
    /**
     * The TicketSchemeSeasonIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketSchemeSeasonIds;
    /**
     * Constructor method for ClientEnrollmentsQueryRequestBase
     * @uses ClientEnrollmentsQueryRequestBase::setClientId()
     * @uses ClientEnrollmentsQueryRequestBase::setTicketSchemeIds()
     * @uses ClientEnrollmentsQueryRequestBase::setTicketSchemeSeasonIds()
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfguid $ticketSchemeIds
     * @param \patest\ArrayType\ArrayOfguid $ticketSchemeSeasonIds
     */
    public function __construct($clientId = null, \patest\ArrayType\ArrayOfguid $ticketSchemeIds = null, \patest\ArrayType\ArrayOfguid $ticketSchemeSeasonIds = null)
    {
        $this
            ->setClientId($clientId)
            ->setTicketSchemeIds($ticketSchemeIds)
            ->setTicketSchemeSeasonIds($ticketSchemeSeasonIds);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\ClientEnrollmentsQueryRequestBase
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get TicketSchemeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketSchemeIds()
    {
        return isset($this->TicketSchemeIds) ? $this->TicketSchemeIds : null;
    }
    /**
     * Set TicketSchemeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketSchemeIds
     * @return \patest\StructType\ClientEnrollmentsQueryRequestBase
     */
    public function setTicketSchemeIds(\patest\ArrayType\ArrayOfguid $ticketSchemeIds = null)
    {
        if (is_null($ticketSchemeIds) || (is_array($ticketSchemeIds) && empty($ticketSchemeIds))) {
            unset($this->TicketSchemeIds);
        } else {
            $this->TicketSchemeIds = $ticketSchemeIds;
        }
        return $this;
    }
    /**
     * Get TicketSchemeSeasonIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketSchemeSeasonIds()
    {
        return isset($this->TicketSchemeSeasonIds) ? $this->TicketSchemeSeasonIds : null;
    }
    /**
     * Set TicketSchemeSeasonIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketSchemeSeasonIds
     * @return \patest\StructType\ClientEnrollmentsQueryRequestBase
     */
    public function setTicketSchemeSeasonIds(\patest\ArrayType\ArrayOfguid $ticketSchemeSeasonIds = null)
    {
        if (is_null($ticketSchemeSeasonIds) || (is_array($ticketSchemeSeasonIds) && empty($ticketSchemeSeasonIds))) {
            unset($this->TicketSchemeSeasonIds);
        } else {
            $this->TicketSchemeSeasonIds = $ticketSchemeSeasonIds;
        }
        return $this;
    }
}
