<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientCreditDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientCreditDescription
 * @subpackage Structs
 */
class ClientCreditDescription extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetId;
    /**
     * The TargetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetType;
    /**
     * Constructor method for ClientCreditDescription
     * @uses ClientCreditDescription::setAmount()
     * @uses ClientCreditDescription::setCategoryId()
     * @uses ClientCreditDescription::setClientId()
     * @uses ClientCreditDescription::setTargetId()
     * @uses ClientCreditDescription::setTargetType()
     * @param \patest\StructType\Money $amount
     * @param string $categoryId
     * @param string $clientId
     * @param string $targetId
     * @param string $targetType
     */
    public function __construct(\patest\StructType\Money $amount = null, $categoryId = null, $clientId = null, $targetId = null, $targetType = null)
    {
        $this
            ->setAmount($amount)
            ->setCategoryId($categoryId)
            ->setClientId($clientId)
            ->setTargetId($targetId)
            ->setTargetType($targetType);
    }
    /**
     * Get Amount value
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\ClientCreditDescription
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \patest\StructType\ClientCreditDescription
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\ClientCreditDescription
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get TargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId()
    {
        return isset($this->TargetId) ? $this->TargetId : null;
    }
    /**
     * Set TargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId
     * @return \patest\StructType\ClientCreditDescription
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        if (is_null($targetId) || (is_array($targetId) && empty($targetId))) {
            unset($this->TargetId);
        } else {
            $this->TargetId = $targetId;
        }
        return $this;
    }
    /**
     * Get TargetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetType()
    {
        return isset($this->TargetType) ? $this->TargetType : null;
    }
    /**
     * Set TargetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DepositTargetType::valueIsValid()
     * @uses \patest\EnumType\DepositTargetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetType
     * @return \patest\StructType\ClientCreditDescription
     */
    public function setTargetType($targetType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DepositTargetType::valueIsValid($targetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DepositTargetType', is_array($targetType) ? implode(', ', $targetType) : var_export($targetType, true), implode(', ', \patest\EnumType\DepositTargetType::getValidValues())), __LINE__);
        }
        if (is_null($targetType) || (is_array($targetType) && empty($targetType))) {
            unset($this->TargetType);
        } else {
            $this->TargetType = $targetType;
        }
        return $this;
    }
}
