<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeSubsTicketAppliedPriceListType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeSubsTicketAppliedPriceListType
 * @subpackage Structs
 */
class ChangeSubsTicketAppliedPriceListType extends AbstractStructBase
{
    /**
     * The PriceListToApply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PriceListToApply;
    /**
     * The SeriesIdToApplyPriceList
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesIdToApplyPriceList;
    /**
     * Constructor method for ChangeSubsTicketAppliedPriceListType
     * @uses ChangeSubsTicketAppliedPriceListType::setPriceListToApply()
     * @uses ChangeSubsTicketAppliedPriceListType::setSeriesIdToApplyPriceList()
     * @param string $priceListToApply
     * @param string $seriesIdToApplyPriceList
     */
    public function __construct($priceListToApply = null, $seriesIdToApplyPriceList = null)
    {
        $this
            ->setPriceListToApply($priceListToApply)
            ->setSeriesIdToApplyPriceList($seriesIdToApplyPriceList);
    }
    /**
     * Get PriceListToApply value
     * @return string|null
     */
    public function getPriceListToApply()
    {
        return $this->PriceListToApply;
    }
    /**
     * Set PriceListToApply value
     * @uses \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::valueIsValid()
     * @uses \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceListToApply
     * @return \patest\StructType\ChangeSubsTicketAppliedPriceListType
     */
    public function setPriceListToApply($priceListToApply = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::valueIsValid($priceListToApply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum', is_array($priceListToApply) ? implode(', ', $priceListToApply) : var_export($priceListToApply, true), implode(', ', \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::getValidValues())), __LINE__);
        }
        $this->PriceListToApply = $priceListToApply;
        return $this;
    }
    /**
     * Get SeriesIdToApplyPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIdToApplyPriceList()
    {
        return isset($this->SeriesIdToApplyPriceList) ? $this->SeriesIdToApplyPriceList : null;
    }
    /**
     * Set SeriesIdToApplyPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIdToApplyPriceList
     * @return \patest\StructType\ChangeSubsTicketAppliedPriceListType
     */
    public function setSeriesIdToApplyPriceList($seriesIdToApplyPriceList = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIdToApplyPriceList) && !is_string($seriesIdToApplyPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIdToApplyPriceList, true), gettype($seriesIdToApplyPriceList)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesIdToApplyPriceList) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesIdToApplyPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesIdToApplyPriceList, true)), __LINE__);
        }
        if (is_null($seriesIdToApplyPriceList) || (is_array($seriesIdToApplyPriceList) && empty($seriesIdToApplyPriceList))) {
            unset($this->SeriesIdToApplyPriceList);
        } else {
            $this->SeriesIdToApplyPriceList = $seriesIdToApplyPriceList;
        }
        return $this;
    }
}
