<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CatchSeatsPerEventRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CatchSeatsPerEventRequest
 * @subpackage Structs
 */
class CatchSeatsPerEventRequest extends AbstractStructBase
{
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The ECardIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfNullableOfguid
     */
    public $ECardIds;
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The OrderIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OrderIdentity
     */
    public $OrderIdentity;
    /**
     * The PartId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartId;
    /**
     * The SeatsToCatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCatchSeatRequest
     */
    public $SeatsToCatch;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SubscriptionInstanceIds;
    /**
     * Constructor method for CatchSeatsPerEventRequest
     * @uses CatchSeatsPerEventRequest::setCouponIdentity()
     * @uses CatchSeatsPerEventRequest::setECardIds()
     * @uses CatchSeatsPerEventRequest::setEffectiveAvailabilityFilter()
     * @uses CatchSeatsPerEventRequest::setEventId()
     * @uses CatchSeatsPerEventRequest::setOrderIdentity()
     * @uses CatchSeatsPerEventRequest::setPartId()
     * @uses CatchSeatsPerEventRequest::setSeatsToCatch()
     * @uses CatchSeatsPerEventRequest::setSubscriptionInstanceIds()
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param \patest\ArrayType\ArrayOfNullableOfguid $eCardIds
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param string $eventId
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @param string $partId
     * @param \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds
     */
    public function __construct(\patest\StructType\CouponIdentity $couponIdentity = null, \patest\ArrayType\ArrayOfNullableOfguid $eCardIds = null, \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, $eventId = null, \patest\StructType\OrderIdentity $orderIdentity = null, $partId = null, \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch = null, \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds = null)
    {
        $this
            ->setCouponIdentity($couponIdentity)
            ->setECardIds($eCardIds)
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setEventId($eventId)
            ->setOrderIdentity($orderIdentity)
            ->setPartId($partId)
            ->setSeatsToCatch($seatsToCatch)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds);
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get ECardIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfNullableOfguid|null
     */
    public function getECardIds()
    {
        return isset($this->ECardIds) ? $this->ECardIds : null;
    }
    /**
     * Set ECardIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfNullableOfguid $eCardIds
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setECardIds(\patest\ArrayType\ArrayOfNullableOfguid $eCardIds = null)
    {
        if (is_null($eCardIds) || (is_array($eCardIds) && empty($eCardIds))) {
            unset($this->ECardIds);
        } else {
            $this->ECardIds = $eCardIds;
        }
        return $this;
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get OrderIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OrderIdentity|null
     */
    public function getOrderIdentity()
    {
        return isset($this->OrderIdentity) ? $this->OrderIdentity : null;
    }
    /**
     * Set OrderIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setOrderIdentity(\patest\StructType\OrderIdentity $orderIdentity = null)
    {
        if (is_null($orderIdentity) || (is_array($orderIdentity) && empty($orderIdentity))) {
            unset($this->OrderIdentity);
        } else {
            $this->OrderIdentity = $orderIdentity;
        }
        return $this;
    }
    /**
     * Get PartId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->PartId;
    }
    /**
     * Set PartId value
     * @param string $partId
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partId, true)), __LINE__);
        }
        $this->PartId = $partId;
        return $this;
    }
    /**
     * Get SeatsToCatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCatchSeatRequest|null
     */
    public function getSeatsToCatch()
    {
        return isset($this->SeatsToCatch) ? $this->SeatsToCatch : null;
    }
    /**
     * Set SeatsToCatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setSeatsToCatch(\patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch = null)
    {
        if (is_null($seatsToCatch) || (is_array($seatsToCatch) && empty($seatsToCatch))) {
            unset($this->SeatsToCatch);
        } else {
            $this->SeatsToCatch = $seatsToCatch;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds
     * @return \patest\StructType\CatchSeatsPerEventRequest
     */
    public function setSubscriptionInstanceIds(\patest\ArrayType\ArrayOfguid $subscriptionInstanceIds = null)
    {
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
}
