<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardTransactionResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CardTransactionResponse
 * @subpackage Structs
 */
class CardTransactionResponse extends AbstractStructBase
{
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The Authorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Authorized;
    /**
     * The Balances
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCardBalance
     */
    public $Balances;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMsg;
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Identifier;
    /**
     * The IsNewCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNewCard;
    /**
     * The IsSplitPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSplitPay;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionType;
    /**
     * Constructor method for CardTransactionResponse
     * @uses CardTransactionResponse::setAuthorizationCode()
     * @uses CardTransactionResponse::setAuthorized()
     * @uses CardTransactionResponse::setBalances()
     * @uses CardTransactionResponse::setCardNumber()
     * @uses CardTransactionResponse::setErrorMsg()
     * @uses CardTransactionResponse::setIdentifier()
     * @uses CardTransactionResponse::setIsNewCard()
     * @uses CardTransactionResponse::setIsSplitPay()
     * @uses CardTransactionResponse::setTransactionType()
     * @param string $authorizationCode
     * @param bool $authorized
     * @param \patest\ArrayType\ArrayOfCardBalance $balances
     * @param string $cardNumber
     * @param string $errorMsg
     * @param string $identifier
     * @param bool $isNewCard
     * @param bool $isSplitPay
     * @param string $transactionType
     */
    public function __construct($authorizationCode = null, $authorized = null, \patest\ArrayType\ArrayOfCardBalance $balances = null, $cardNumber = null, $errorMsg = null, $identifier = null, $isNewCard = null, $isSplitPay = null, $transactionType = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setAuthorized($authorized)
            ->setBalances($balances)
            ->setCardNumber($cardNumber)
            ->setErrorMsg($errorMsg)
            ->setIdentifier($identifier)
            ->setIsNewCard($isNewCard)
            ->setIsSplitPay($isSplitPay)
            ->setTransactionType($transactionType);
    }
    /**
     * Get AuthorizationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return isset($this->AuthorizationCode) ? $this->AuthorizationCode : null;
    }
    /**
     * Set AuthorizationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationCode
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        if (is_null($authorizationCode) || (is_array($authorizationCode) && empty($authorizationCode))) {
            unset($this->AuthorizationCode);
        } else {
            $this->AuthorizationCode = $authorizationCode;
        }
        return $this;
    }
    /**
     * Get Authorized value
     * @return bool|null
     */
    public function getAuthorized()
    {
        return $this->Authorized;
    }
    /**
     * Set Authorized value
     * @param bool $authorized
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setAuthorized($authorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorized) && !is_bool($authorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authorized, true), gettype($authorized)), __LINE__);
        }
        $this->Authorized = $authorized;
        return $this;
    }
    /**
     * Get Balances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCardBalance|null
     */
    public function getBalances()
    {
        return isset($this->Balances) ? $this->Balances : null;
    }
    /**
     * Set Balances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCardBalance $balances
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setBalances(\patest\ArrayType\ArrayOfCardBalance $balances = null)
    {
        if (is_null($balances) || (is_array($balances) && empty($balances))) {
            unset($this->Balances);
        } else {
            $this->Balances = $balances;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get ErrorMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMsg()
    {
        return isset($this->ErrorMsg) ? $this->ErrorMsg : null;
    }
    /**
     * Set ErrorMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMsg
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        if (is_null($errorMsg) || (is_array($errorMsg) && empty($errorMsg))) {
            unset($this->ErrorMsg);
        } else {
            $this->ErrorMsg = $errorMsg;
        }
        return $this;
    }
    /**
     * Get Identifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentifier()
    {
        return isset($this->Identifier) ? $this->Identifier : null;
    }
    /**
     * Set Identifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identifier
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        if (is_null($identifier) || (is_array($identifier) && empty($identifier))) {
            unset($this->Identifier);
        } else {
            $this->Identifier = $identifier;
        }
        return $this;
    }
    /**
     * Get IsNewCard value
     * @return bool|null
     */
    public function getIsNewCard()
    {
        return $this->IsNewCard;
    }
    /**
     * Set IsNewCard value
     * @param bool $isNewCard
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setIsNewCard($isNewCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewCard) && !is_bool($isNewCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNewCard, true), gettype($isNewCard)), __LINE__);
        }
        $this->IsNewCard = $isNewCard;
        return $this;
    }
    /**
     * Get IsSplitPay value
     * @return bool|null
     */
    public function getIsSplitPay()
    {
        return $this->IsSplitPay;
    }
    /**
     * Set IsSplitPay value
     * @param bool $isSplitPay
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setIsSplitPay($isSplitPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSplitPay) && !is_bool($isSplitPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSplitPay, true), gettype($isSplitPay)), __LINE__);
        }
        $this->IsSplitPay = $isSplitPay;
        return $this;
    }
    /**
     * Get TransactionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionType()
    {
        return isset($this->TransactionType) ? $this->TransactionType : null;
    }
    /**
     * Set TransactionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionType
     * @return \patest\StructType\CardTransactionResponse
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionType, true), gettype($transactionType)), __LINE__);
        }
        if (is_null($transactionType) || (is_array($transactionType) && empty($transactionType))) {
            unset($this->TransactionType);
        } else {
            $this->TransactionType = $transactionType;
        }
        return $this;
    }
}
