<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateDefaultInvoiceDueDateRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CalculateDefaultInvoiceDueDateRequest
 * @subpackage Structs
 */
class CalculateDefaultInvoiceDueDateRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The PaymentTermsId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTermsId;
    /**
     * Constructor method for CalculateDefaultInvoiceDueDateRequest
     * @uses CalculateDefaultInvoiceDueDateRequest::setClientId()
     * @uses CalculateDefaultInvoiceDueDateRequest::setPaymentTermsId()
     * @param string $clientId
     * @param string $paymentTermsId
     */
    public function __construct($clientId = null, $paymentTermsId = null)
    {
        $this
            ->setClientId($clientId)
            ->setPaymentTermsId($paymentTermsId);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\CalculateDefaultInvoiceDueDateRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get PaymentTermsId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTermsId()
    {
        return isset($this->PaymentTermsId) ? $this->PaymentTermsId : null;
    }
    /**
     * Set PaymentTermsId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTermsId
     * @return \patest\StructType\CalculateDefaultInvoiceDueDateRequest
     */
    public function setPaymentTermsId($paymentTermsId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsId) && !is_string($paymentTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsId, true), gettype($paymentTermsId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTermsId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTermsId, true)), __LINE__);
        }
        if (is_null($paymentTermsId) || (is_array($paymentTermsId) && empty($paymentTermsId))) {
            unset($this->PaymentTermsId);
        } else {
            $this->PaymentTermsId = $paymentTermsId;
        }
        return $this;
    }
}
