<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleRequiredAdditionalInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleRequiredAdditionalInfo
 * @subpackage Structs
 */
class BundleRequiredAdditionalInfo extends ExtensibleDataContract
{
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBundleAllocatedItemAreaAvailability
     */
    public $Areas;
    /**
     * The DefaultAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAreaId;
    /**
     * The PriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBundleItemPriceLevelsAvailability
     */
    public $PriceLevels;
    /**
     * Constructor method for BundleRequiredAdditionalInfo
     * @uses BundleRequiredAdditionalInfo::setAreas()
     * @uses BundleRequiredAdditionalInfo::setDefaultAreaId()
     * @uses BundleRequiredAdditionalInfo::setPriceLevels()
     * @param \patest\ArrayType\ArrayOfBundleAllocatedItemAreaAvailability $areas
     * @param string $defaultAreaId
     * @param \patest\ArrayType\ArrayOfBundleItemPriceLevelsAvailability $priceLevels
     */
    public function __construct(\patest\ArrayType\ArrayOfBundleAllocatedItemAreaAvailability $areas = null, $defaultAreaId = null, \patest\ArrayType\ArrayOfBundleItemPriceLevelsAvailability $priceLevels = null)
    {
        $this
            ->setAreas($areas)
            ->setDefaultAreaId($defaultAreaId)
            ->setPriceLevels($priceLevels);
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBundleAllocatedItemAreaAvailability|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBundleAllocatedItemAreaAvailability $areas
     * @return \patest\StructType\BundleRequiredAdditionalInfo
     */
    public function setAreas(\patest\ArrayType\ArrayOfBundleAllocatedItemAreaAvailability $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get DefaultAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAreaId()
    {
        return isset($this->DefaultAreaId) ? $this->DefaultAreaId : null;
    }
    /**
     * Set DefaultAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAreaId
     * @return \patest\StructType\BundleRequiredAdditionalInfo
     */
    public function setDefaultAreaId($defaultAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAreaId) && !is_string($defaultAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAreaId, true), gettype($defaultAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAreaId, true)), __LINE__);
        }
        if (is_null($defaultAreaId) || (is_array($defaultAreaId) && empty($defaultAreaId))) {
            unset($this->DefaultAreaId);
        } else {
            $this->DefaultAreaId = $defaultAreaId;
        }
        return $this;
    }
    /**
     * Get PriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBundleItemPriceLevelsAvailability|null
     */
    public function getPriceLevels()
    {
        return isset($this->PriceLevels) ? $this->PriceLevels : null;
    }
    /**
     * Set PriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBundleItemPriceLevelsAvailability $priceLevels
     * @return \patest\StructType\BundleRequiredAdditionalInfo
     */
    public function setPriceLevels(\patest\ArrayType\ArrayOfBundleItemPriceLevelsAvailability $priceLevels = null)
    {
        if (is_null($priceLevels) || (is_array($priceLevels) && empty($priceLevels))) {
            unset($this->PriceLevels);
        } else {
            $this->PriceLevels = $priceLevels;
        }
        return $this;
    }
}
