<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleDescription
 * @subpackage Structs
 */
class BundleDescription extends AbstractStructBase
{
    /**
     * The Entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Bundle
     */
    public $Entity;
    /**
     * The IsAllShouldOccurOnSameDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllShouldOccurOnSameDay;
    /**
     * Constructor method for BundleDescription
     * @uses BundleDescription::setEntity()
     * @uses BundleDescription::setIsAllShouldOccurOnSameDay()
     * @param \patest\StructType\Sales_Bundle $entity
     * @param bool $isAllShouldOccurOnSameDay
     */
    public function __construct(\patest\StructType\Sales_Bundle $entity = null, $isAllShouldOccurOnSameDay = null)
    {
        $this
            ->setEntity($entity)
            ->setIsAllShouldOccurOnSameDay($isAllShouldOccurOnSameDay);
    }
    /**
     * Get Entity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Bundle|null
     */
    public function getEntity()
    {
        return isset($this->Entity) ? $this->Entity : null;
    }
    /**
     * Set Entity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Bundle $entity
     * @return \patest\StructType\BundleDescription
     */
    public function setEntity(\patest\StructType\Sales_Bundle $entity = null)
    {
        if (is_null($entity) || (is_array($entity) && empty($entity))) {
            unset($this->Entity);
        } else {
            $this->Entity = $entity;
        }
        return $this;
    }
    /**
     * Get IsAllShouldOccurOnSameDay value
     * @return bool|null
     */
    public function getIsAllShouldOccurOnSameDay()
    {
        return $this->IsAllShouldOccurOnSameDay;
    }
    /**
     * Set IsAllShouldOccurOnSameDay value
     * @param bool $isAllShouldOccurOnSameDay
     * @return \patest\StructType\BundleDescription
     */
    public function setIsAllShouldOccurOnSameDay($isAllShouldOccurOnSameDay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllShouldOccurOnSameDay) && !is_bool($isAllShouldOccurOnSameDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllShouldOccurOnSameDay, true), gettype($isAllShouldOccurOnSameDay)), __LINE__);
        }
        $this->IsAllShouldOccurOnSameDay = $isAllShouldOccurOnSameDay;
        return $this;
    }
}
