<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BulkEventOwnership-ResponseV2 StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BulkEventOwnership-ResponseV2
 * @subpackage Structs
 */
class BulkEventOwnership_ResponseV2 extends ExtensibleDataContract
{
    /**
     * The BulkEventOwnershipEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBulkEventOwnershipEntryV2
     */
    public $BulkEventOwnershipEntries;
    /**
     * The NextTicketWithVersionsLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NextTicketWithVersionsLocalId;
    /**
     * Constructor method for BulkEventOwnership-ResponseV2
     * @uses BulkEventOwnership_ResponseV2::setBulkEventOwnershipEntries()
     * @uses BulkEventOwnership_ResponseV2::setNextTicketWithVersionsLocalId()
     * @param \patest\ArrayType\ArrayOfBulkEventOwnershipEntryV2 $bulkEventOwnershipEntries
     * @param int $nextTicketWithVersionsLocalId
     */
    public function __construct(\patest\ArrayType\ArrayOfBulkEventOwnershipEntryV2 $bulkEventOwnershipEntries = null, $nextTicketWithVersionsLocalId = null)
    {
        $this
            ->setBulkEventOwnershipEntries($bulkEventOwnershipEntries)
            ->setNextTicketWithVersionsLocalId($nextTicketWithVersionsLocalId);
    }
    /**
     * Get BulkEventOwnershipEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBulkEventOwnershipEntryV2|null
     */
    public function getBulkEventOwnershipEntries()
    {
        return isset($this->BulkEventOwnershipEntries) ? $this->BulkEventOwnershipEntries : null;
    }
    /**
     * Set BulkEventOwnershipEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBulkEventOwnershipEntryV2 $bulkEventOwnershipEntries
     * @return \patest\StructType\BulkEventOwnership_ResponseV2
     */
    public function setBulkEventOwnershipEntries(\patest\ArrayType\ArrayOfBulkEventOwnershipEntryV2 $bulkEventOwnershipEntries = null)
    {
        if (is_null($bulkEventOwnershipEntries) || (is_array($bulkEventOwnershipEntries) && empty($bulkEventOwnershipEntries))) {
            unset($this->BulkEventOwnershipEntries);
        } else {
            $this->BulkEventOwnershipEntries = $bulkEventOwnershipEntries;
        }
        return $this;
    }
    /**
     * Get NextTicketWithVersionsLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNextTicketWithVersionsLocalId()
    {
        return isset($this->NextTicketWithVersionsLocalId) ? $this->NextTicketWithVersionsLocalId : null;
    }
    /**
     * Set NextTicketWithVersionsLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nextTicketWithVersionsLocalId
     * @return \patest\StructType\BulkEventOwnership_ResponseV2
     */
    public function setNextTicketWithVersionsLocalId($nextTicketWithVersionsLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($nextTicketWithVersionsLocalId) && !(is_int($nextTicketWithVersionsLocalId) || ctype_digit($nextTicketWithVersionsLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextTicketWithVersionsLocalId, true), gettype($nextTicketWithVersionsLocalId)), __LINE__);
        }
        if (is_null($nextTicketWithVersionsLocalId) || (is_array($nextTicketWithVersionsLocalId) && empty($nextTicketWithVersionsLocalId))) {
            unset($this->NextTicketWithVersionsLocalId);
        } else {
            $this->NextTicketWithVersionsLocalId = $nextTicketWithVersionsLocalId;
        }
        return $this;
    }
}
