<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.VisitActivityGuideRequest StructType
 * @subpackage Structs
 */
class BizResource_VisitActivityGuideRequest extends BizResource_GuideRequest
{
    /**
     * The ActivityId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrderVisitActivityCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitActivityCategoryId;
    /**
     * The OrderVisitActivityId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitActivityId;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * The RequestedPeople
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RequestedPeople;
    /**
     * The RoomId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomId;
    /**
     * Constructor method for BizResource.VisitActivityGuideRequest
     * @uses BizResource_VisitActivityGuideRequest::setActivityId()
     * @uses BizResource_VisitActivityGuideRequest::setName()
     * @uses BizResource_VisitActivityGuideRequest::setOrderVisitActivityCategoryId()
     * @uses BizResource_VisitActivityGuideRequest::setOrderVisitActivityId()
     * @uses BizResource_VisitActivityGuideRequest::setOrderVisitId()
     * @uses BizResource_VisitActivityGuideRequest::setRequestedPeople()
     * @uses BizResource_VisitActivityGuideRequest::setRoomId()
     * @param string $activityId
     * @param string $name
     * @param string $orderVisitActivityCategoryId
     * @param string $orderVisitActivityId
     * @param string $orderVisitId
     * @param int $requestedPeople
     * @param string $roomId
     */
    public function __construct($activityId = null, $name = null, $orderVisitActivityCategoryId = null, $orderVisitActivityId = null, $orderVisitId = null, $requestedPeople = null, $roomId = null)
    {
        $this
            ->setActivityId($activityId)
            ->setName($name)
            ->setOrderVisitActivityCategoryId($orderVisitActivityCategoryId)
            ->setOrderVisitActivityId($orderVisitActivityId)
            ->setOrderVisitId($orderVisitId)
            ->setRequestedPeople($requestedPeople)
            ->setRoomId($roomId);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrderVisitActivityCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitActivityCategoryId()
    {
        return isset($this->OrderVisitActivityCategoryId) ? $this->OrderVisitActivityCategoryId : null;
    }
    /**
     * Set OrderVisitActivityCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitActivityCategoryId
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setOrderVisitActivityCategoryId($orderVisitActivityCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitActivityCategoryId) && !is_string($orderVisitActivityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitActivityCategoryId, true), gettype($orderVisitActivityCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitActivityCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitActivityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitActivityCategoryId, true)), __LINE__);
        }
        if (is_null($orderVisitActivityCategoryId) || (is_array($orderVisitActivityCategoryId) && empty($orderVisitActivityCategoryId))) {
            unset($this->OrderVisitActivityCategoryId);
        } else {
            $this->OrderVisitActivityCategoryId = $orderVisitActivityCategoryId;
        }
        return $this;
    }
    /**
     * Get OrderVisitActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitActivityId()
    {
        return isset($this->OrderVisitActivityId) ? $this->OrderVisitActivityId : null;
    }
    /**
     * Set OrderVisitActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitActivityId
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setOrderVisitActivityId($orderVisitActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitActivityId) && !is_string($orderVisitActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitActivityId, true), gettype($orderVisitActivityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitActivityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitActivityId, true)), __LINE__);
        }
        if (is_null($orderVisitActivityId) || (is_array($orderVisitActivityId) && empty($orderVisitActivityId))) {
            unset($this->OrderVisitActivityId);
        } else {
            $this->OrderVisitActivityId = $orderVisitActivityId;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get RequestedPeople value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRequestedPeople()
    {
        return isset($this->RequestedPeople) ? $this->RequestedPeople : null;
    }
    /**
     * Set RequestedPeople value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $requestedPeople
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setRequestedPeople($requestedPeople = null)
    {
        // validation for constraint: int
        if (!is_null($requestedPeople) && !(is_int($requestedPeople) || ctype_digit($requestedPeople))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedPeople, true), gettype($requestedPeople)), __LINE__);
        }
        if (is_null($requestedPeople) || (is_array($requestedPeople) && empty($requestedPeople))) {
            unset($this->RequestedPeople);
        } else {
            $this->RequestedPeople = $requestedPeople;
        }
        return $this;
    }
    /**
     * Get RoomId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomId()
    {
        return isset($this->RoomId) ? $this->RoomId : null;
    }
    /**
     * Set RoomId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomId
     * @return \patest\StructType\BizResource_VisitActivityGuideRequest
     */
    public function setRoomId($roomId = null)
    {
        // validation for constraint: string
        if (!is_null($roomId) && !is_string($roomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomId, true), gettype($roomId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomId, true)), __LINE__);
        }
        if (is_null($roomId) || (is_array($roomId) && empty($roomId))) {
            unset($this->RoomId);
        } else {
            $this->RoomId = $roomId;
        }
        return $this;
    }
}
