<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.SchoolOrderVisit StructType
 * @subpackage Structs
 */
class BizResource_SchoolOrderVisit extends BizResource_OrderVisit
{
    /**
     * The BirthYear
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BirthYear;
    /**
     * The SchoolYear
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SchoolYear;
    /**
     * Constructor method for BizResource.SchoolOrderVisit
     * @uses BizResource_SchoolOrderVisit::setBirthYear()
     * @uses BizResource_SchoolOrderVisit::setSchoolYear()
     * @param int $birthYear
     * @param int $schoolYear
     */
    public function __construct($birthYear = null, $schoolYear = null)
    {
        $this
            ->setBirthYear($birthYear)
            ->setSchoolYear($schoolYear);
    }
    /**
     * Get BirthYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBirthYear()
    {
        return isset($this->BirthYear) ? $this->BirthYear : null;
    }
    /**
     * Set BirthYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $birthYear
     * @return \patest\StructType\BizResource_SchoolOrderVisit
     */
    public function setBirthYear($birthYear = null)
    {
        // validation for constraint: int
        if (!is_null($birthYear) && !(is_int($birthYear) || ctype_digit($birthYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($birthYear, true), gettype($birthYear)), __LINE__);
        }
        if (is_null($birthYear) || (is_array($birthYear) && empty($birthYear))) {
            unset($this->BirthYear);
        } else {
            $this->BirthYear = $birthYear;
        }
        return $this;
    }
    /**
     * Get SchoolYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSchoolYear()
    {
        return isset($this->SchoolYear) ? $this->SchoolYear : null;
    }
    /**
     * Set SchoolYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $schoolYear
     * @return \patest\StructType\BizResource_SchoolOrderVisit
     */
    public function setSchoolYear($schoolYear = null)
    {
        // validation for constraint: int
        if (!is_null($schoolYear) && !(is_int($schoolYear) || ctype_digit($schoolYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($schoolYear, true), gettype($schoolYear)), __LINE__);
        }
        if (is_null($schoolYear) || (is_array($schoolYear) && empty($schoolYear))) {
            unset($this->SchoolYear);
        } else {
            $this->SchoolYear = $schoolYear;
        }
        return $this;
    }
}
