<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.eSRO.ClientDetails StructType
 * @subpackage Structs
 */
class BizAction_eSRO_ClientDetails extends AnyEntity
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AddressDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_eSRO_AddressDetails
     */
    public $AddressDetails;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Age;
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientTypeId;
    /**
     * The ClientTypeLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientTypeLocalId;
    /**
     * The DataProtectionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_eSRO_DataProtectionAnswer
     */
    public $DataProtectionDetails;
    /**
     * The DeliveryAddressDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_eSRO_AddressDetails
     */
    public $DeliveryAddressDetails;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Extras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_eSRO_ClientExtras
     */
    public $Extras;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The IdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdNumber;
    /**
     * The Initials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Initials;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Preferences
     */
    public $Preferences;
    /**
     * The Prefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefix;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_eSRO_IdOrValue
     */
    public $Title;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebSite;
    /**
     * Constructor method for BizAction.eSRO.ClientDetails
     * @uses BizAction_eSRO_ClientDetails::setAccountName()
     * @uses BizAction_eSRO_ClientDetails::setAddressDetails()
     * @uses BizAction_eSRO_ClientDetails::setAge()
     * @uses BizAction_eSRO_ClientDetails::setBirthday()
     * @uses BizAction_eSRO_ClientDetails::setClientId()
     * @uses BizAction_eSRO_ClientDetails::setClientTypeId()
     * @uses BizAction_eSRO_ClientDetails::setClientTypeLocalId()
     * @uses BizAction_eSRO_ClientDetails::setDataProtectionDetails()
     * @uses BizAction_eSRO_ClientDetails::setDeliveryAddressDetails()
     * @uses BizAction_eSRO_ClientDetails::setEmail()
     * @uses BizAction_eSRO_ClientDetails::setExtras()
     * @uses BizAction_eSRO_ClientDetails::setFax()
     * @uses BizAction_eSRO_ClientDetails::setFirstName()
     * @uses BizAction_eSRO_ClientDetails::setGender()
     * @uses BizAction_eSRO_ClientDetails::setIdNumber()
     * @uses BizAction_eSRO_ClientDetails::setInitials()
     * @uses BizAction_eSRO_ClientDetails::setIsHidden()
     * @uses BizAction_eSRO_ClientDetails::setLastName()
     * @uses BizAction_eSRO_ClientDetails::setMiddleName()
     * @uses BizAction_eSRO_ClientDetails::setMobile()
     * @uses BizAction_eSRO_ClientDetails::setPassword()
     * @uses BizAction_eSRO_ClientDetails::setPhone()
     * @uses BizAction_eSRO_ClientDetails::setPreferences()
     * @uses BizAction_eSRO_ClientDetails::setPrefix()
     * @uses BizAction_eSRO_ClientDetails::setSuffix()
     * @uses BizAction_eSRO_ClientDetails::setTaxExemptNumber()
     * @uses BizAction_eSRO_ClientDetails::setTitle()
     * @uses BizAction_eSRO_ClientDetails::setType()
     * @uses BizAction_eSRO_ClientDetails::setUserName()
     * @uses BizAction_eSRO_ClientDetails::setVatRegistrationNumber()
     * @uses BizAction_eSRO_ClientDetails::setWebSite()
     * @param string $accountName
     * @param \patest\StructType\BizAction_eSRO_AddressDetails $addressDetails
     * @param int $age
     * @param string $birthday
     * @param string $clientId
     * @param string $clientTypeId
     * @param int $clientTypeLocalId
     * @param \patest\StructType\RecordSetOfBizAction_eSRO_DataProtectionAnswer $dataProtectionDetails
     * @param \patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails
     * @param string $email
     * @param \patest\StructType\BizAction_eSRO_ClientExtras $extras
     * @param string $fax
     * @param string $firstName
     * @param string $gender
     * @param string $idNumber
     * @param string $initials
     * @param bool $isHidden
     * @param string $lastName
     * @param string $middleName
     * @param string $mobile
     * @param string $password
     * @param string $phone
     * @param \patest\StructType\Preferences $preferences
     * @param string $prefix
     * @param string $suffix
     * @param string $taxExemptNumber
     * @param \patest\StructType\BizAction_eSRO_IdOrValue $title
     * @param string[] $type
     * @param string $userName
     * @param string $vatRegistrationNumber
     * @param string $webSite
     */
    public function __construct($accountName = null, \patest\StructType\BizAction_eSRO_AddressDetails $addressDetails = null, $age = null, $birthday = null, $clientId = null, $clientTypeId = null, $clientTypeLocalId = null, \patest\StructType\RecordSetOfBizAction_eSRO_DataProtectionAnswer $dataProtectionDetails = null, \patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails = null, $email = null, \patest\StructType\BizAction_eSRO_ClientExtras $extras = null, $fax = null, $firstName = null, $gender = null, $idNumber = null, $initials = null, $isHidden = null, $lastName = null, $middleName = null, $mobile = null, $password = null, $phone = null, \patest\StructType\Preferences $preferences = null, $prefix = null, $suffix = null, $taxExemptNumber = null, \patest\StructType\BizAction_eSRO_IdOrValue $title = null, array $type = array(), $userName = null, $vatRegistrationNumber = null, $webSite = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAddressDetails($addressDetails)
            ->setAge($age)
            ->setBirthday($birthday)
            ->setClientId($clientId)
            ->setClientTypeId($clientTypeId)
            ->setClientTypeLocalId($clientTypeLocalId)
            ->setDataProtectionDetails($dataProtectionDetails)
            ->setDeliveryAddressDetails($deliveryAddressDetails)
            ->setEmail($email)
            ->setExtras($extras)
            ->setFax($fax)
            ->setFirstName($firstName)
            ->setGender($gender)
            ->setIdNumber($idNumber)
            ->setInitials($initials)
            ->setIsHidden($isHidden)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setMobile($mobile)
            ->setPassword($password)
            ->setPhone($phone)
            ->setPreferences($preferences)
            ->setPrefix($prefix)
            ->setSuffix($suffix)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setTitle($title)
            ->setType($type)
            ->setUserName($userName)
            ->setVatRegistrationNumber($vatRegistrationNumber)
            ->setWebSite($webSite);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_eSRO_AddressDetails|null
     */
    public function getAddressDetails()
    {
        return isset($this->AddressDetails) ? $this->AddressDetails : null;
    }
    /**
     * Set AddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_eSRO_AddressDetails $addressDetails
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setAddressDetails(\patest\StructType\BizAction_eSRO_AddressDetails $addressDetails = null)
    {
        if (is_null($addressDetails) || (is_array($addressDetails) && empty($addressDetails))) {
            unset($this->AddressDetails);
        } else {
            $this->AddressDetails = $addressDetails;
        }
        return $this;
    }
    /**
     * Get Age value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAge()
    {
        return isset($this->Age) ? $this->Age : null;
    }
    /**
     * Set Age value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $age
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        if (is_null($age) || (is_array($age) && empty($age))) {
            unset($this->Age);
        } else {
            $this->Age = $age;
        }
        return $this;
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeId()
    {
        return isset($this->ClientTypeId) ? $this->ClientTypeId : null;
    }
    /**
     * Set ClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeId
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setClientTypeId($clientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeId) && !is_string($clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeId, true), gettype($clientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientTypeId, true)), __LINE__);
        }
        if (is_null($clientTypeId) || (is_array($clientTypeId) && empty($clientTypeId))) {
            unset($this->ClientTypeId);
        } else {
            $this->ClientTypeId = $clientTypeId;
        }
        return $this;
    }
    /**
     * Get ClientTypeLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientTypeLocalId()
    {
        return isset($this->ClientTypeLocalId) ? $this->ClientTypeLocalId : null;
    }
    /**
     * Set ClientTypeLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientTypeLocalId
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setClientTypeLocalId($clientTypeLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($clientTypeLocalId) && !(is_int($clientTypeLocalId) || ctype_digit($clientTypeLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientTypeLocalId, true), gettype($clientTypeLocalId)), __LINE__);
        }
        if (is_null($clientTypeLocalId) || (is_array($clientTypeLocalId) && empty($clientTypeLocalId))) {
            unset($this->ClientTypeLocalId);
        } else {
            $this->ClientTypeLocalId = $clientTypeLocalId;
        }
        return $this;
    }
    /**
     * Get DataProtectionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_eSRO_DataProtectionAnswer|null
     */
    public function getDataProtectionDetails()
    {
        return isset($this->DataProtectionDetails) ? $this->DataProtectionDetails : null;
    }
    /**
     * Set DataProtectionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_eSRO_DataProtectionAnswer $dataProtectionDetails
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setDataProtectionDetails(\patest\StructType\RecordSetOfBizAction_eSRO_DataProtectionAnswer $dataProtectionDetails = null)
    {
        if (is_null($dataProtectionDetails) || (is_array($dataProtectionDetails) && empty($dataProtectionDetails))) {
            unset($this->DataProtectionDetails);
        } else {
            $this->DataProtectionDetails = $dataProtectionDetails;
        }
        return $this;
    }
    /**
     * Get DeliveryAddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_eSRO_AddressDetails|null
     */
    public function getDeliveryAddressDetails()
    {
        return isset($this->DeliveryAddressDetails) ? $this->DeliveryAddressDetails : null;
    }
    /**
     * Set DeliveryAddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setDeliveryAddressDetails(\patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails = null)
    {
        if (is_null($deliveryAddressDetails) || (is_array($deliveryAddressDetails) && empty($deliveryAddressDetails))) {
            unset($this->DeliveryAddressDetails);
        } else {
            $this->DeliveryAddressDetails = $deliveryAddressDetails;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Extras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_eSRO_ClientExtras|null
     */
    public function getExtras()
    {
        return isset($this->Extras) ? $this->Extras : null;
    }
    /**
     * Set Extras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_eSRO_ClientExtras $extras
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setExtras(\patest\StructType\BizAction_eSRO_ClientExtras $extras = null)
    {
        if (is_null($extras) || (is_array($extras) && empty($extras))) {
            unset($this->Extras);
        } else {
            $this->Extras = $extras;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get IdNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdNumber()
    {
        return isset($this->IdNumber) ? $this->IdNumber : null;
    }
    /**
     * Set IdNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idNumber
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idNumber, true), gettype($idNumber)), __LINE__);
        }
        if (is_null($idNumber) || (is_array($idNumber) && empty($idNumber))) {
            unset($this->IdNumber);
        } else {
            $this->IdNumber = $idNumber;
        }
        return $this;
    }
    /**
     * Get Initials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitials()
    {
        return isset($this->Initials) ? $this->Initials : null;
    }
    /**
     * Set Initials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initials
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        if (is_null($initials) || (is_array($initials) && empty($initials))) {
            unset($this->Initials);
        } else {
            $this->Initials = $initials;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get Mobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobile()
    {
        return isset($this->Mobile) ? $this->Mobile : null;
    }
    /**
     * Set Mobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobile
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        if (is_null($mobile) || (is_array($mobile) && empty($mobile))) {
            unset($this->Mobile);
        } else {
            $this->Mobile = $mobile;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get Preferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Preferences|null
     */
    public function getPreferences()
    {
        return isset($this->Preferences) ? $this->Preferences : null;
    }
    /**
     * Set Preferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Preferences $preferences
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setPreferences(\patest\StructType\Preferences $preferences = null)
    {
        if (is_null($preferences) || (is_array($preferences) && empty($preferences))) {
            unset($this->Preferences);
        } else {
            $this->Preferences = $preferences;
        }
        return $this;
    }
    /**
     * Get Prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->Prefix) ? $this->Prefix : null;
    }
    /**
     * Set Prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->Prefix);
        } else {
            $this->Prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_eSRO_IdOrValue|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_eSRO_IdOrValue $title
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setTitle(\patest\StructType\BizAction_eSRO_IdOrValue $title = null)
    {
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_eSRO_ClientDetailsTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($bizAction_eSRO_ClientDetailsTypeItem)) {
                $invalidValues[] = is_object($bizAction_eSRO_ClientDetailsTypeItem) ? get_class($bizAction_eSRO_ClientDetailsTypeItem) : sprintf('%s(%s)', gettype($bizAction_eSRO_ClientDetailsTypeItem), var_export($bizAction_eSRO_ClientDetailsTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
    /**
     * Get WebSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebSite()
    {
        return isset($this->WebSite) ? $this->WebSite : null;
    }
    /**
     * Set WebSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webSite
     * @return \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        if (is_null($webSite) || (is_array($webSite) && empty($webSite))) {
            unset($this->WebSite);
        } else {
            $this->WebSite = $webSite;
        }
        return $this;
    }
}
