<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.eSRO.AddDeliveryMethodToTransaction.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_eSRO_AddDeliveryMethodToTransaction_Request extends AnyEntity
{
    /**
     * The DeliveryAddressDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_eSRO_AddressDetails
     */
    public $DeliveryAddressDetails;
    /**
     * The DeliveryMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryMethodId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The UsePrimaryAddressForDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsePrimaryAddressForDelivery;
    /**
     * Constructor method for BizAction.eSRO.AddDeliveryMethodToTransaction.Request
     * @uses BizAction_eSRO_AddDeliveryMethodToTransaction_Request::setDeliveryAddressDetails()
     * @uses BizAction_eSRO_AddDeliveryMethodToTransaction_Request::setDeliveryMethodId()
     * @uses BizAction_eSRO_AddDeliveryMethodToTransaction_Request::setTransactionId()
     * @uses BizAction_eSRO_AddDeliveryMethodToTransaction_Request::setUsePrimaryAddressForDelivery()
     * @param \patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails
     * @param string $deliveryMethodId
     * @param string $transactionId
     * @param bool $usePrimaryAddressForDelivery
     */
    public function __construct(\patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails = null, $deliveryMethodId = null, $transactionId = null, $usePrimaryAddressForDelivery = null)
    {
        $this
            ->setDeliveryAddressDetails($deliveryAddressDetails)
            ->setDeliveryMethodId($deliveryMethodId)
            ->setTransactionId($transactionId)
            ->setUsePrimaryAddressForDelivery($usePrimaryAddressForDelivery);
    }
    /**
     * Get DeliveryAddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_eSRO_AddressDetails|null
     */
    public function getDeliveryAddressDetails()
    {
        return isset($this->DeliveryAddressDetails) ? $this->DeliveryAddressDetails : null;
    }
    /**
     * Set DeliveryAddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails
     * @return \patest\StructType\BizAction_eSRO_AddDeliveryMethodToTransaction_Request
     */
    public function setDeliveryAddressDetails(\patest\StructType\BizAction_eSRO_AddressDetails $deliveryAddressDetails = null)
    {
        if (is_null($deliveryAddressDetails) || (is_array($deliveryAddressDetails) && empty($deliveryAddressDetails))) {
            unset($this->DeliveryAddressDetails);
        } else {
            $this->DeliveryAddressDetails = $deliveryAddressDetails;
        }
        return $this;
    }
    /**
     * Get DeliveryMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryMethodId()
    {
        return isset($this->DeliveryMethodId) ? $this->DeliveryMethodId : null;
    }
    /**
     * Set DeliveryMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryMethodId
     * @return \patest\StructType\BizAction_eSRO_AddDeliveryMethodToTransaction_Request
     */
    public function setDeliveryMethodId($deliveryMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMethodId) && !is_string($deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryMethodId, true), gettype($deliveryMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryMethodId, true)), __LINE__);
        }
        if (is_null($deliveryMethodId) || (is_array($deliveryMethodId) && empty($deliveryMethodId))) {
            unset($this->DeliveryMethodId);
        } else {
            $this->DeliveryMethodId = $deliveryMethodId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\BizAction_eSRO_AddDeliveryMethodToTransaction_Request
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get UsePrimaryAddressForDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsePrimaryAddressForDelivery()
    {
        return isset($this->UsePrimaryAddressForDelivery) ? $this->UsePrimaryAddressForDelivery : null;
    }
    /**
     * Set UsePrimaryAddressForDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usePrimaryAddressForDelivery
     * @return \patest\StructType\BizAction_eSRO_AddDeliveryMethodToTransaction_Request
     */
    public function setUsePrimaryAddressForDelivery($usePrimaryAddressForDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePrimaryAddressForDelivery) && !is_bool($usePrimaryAddressForDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePrimaryAddressForDelivery, true), gettype($usePrimaryAddressForDelivery)), __LINE__);
        }
        if (is_null($usePrimaryAddressForDelivery) || (is_array($usePrimaryAddressForDelivery) && empty($usePrimaryAddressForDelivery))) {
            unset($this->UsePrimaryAddressForDelivery);
        } else {
            $this->UsePrimaryAddressForDelivery = $usePrimaryAddressForDelivery;
        }
        return $this;
    }
}
