<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.UpdatePropertiesOfEvents.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_UpdatePropertiesOfEvents_Request extends AnyEntity
{
    /**
     * The CalcPotentialPriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CalcPotentialPriceListId;
    /**
     * The CompanyOwnsInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CompanyOwnsInventory;
    /**
     * The ComplimentaryEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComplimentaryEventIds;
    /**
     * The DateFormatOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFormatOptions;
    /**
     * The DatesToExclude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_DatesToExclude
     */
    public $DatesToExclude;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The EventSaleFlowMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventSaleFlowMode;
    /**
     * The EventsCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_UpdatePropertiesOfEvents_Criteria
     */
    public $EventsCriteria;
    /**
     * The EventTagIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTagIds;
    /**
     * The EventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTime;
    /**
     * The EventType1Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType1Id;
    /**
     * The EventType2Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType2Id;
    /**
     * The EventType3Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType3Id;
    /**
     * The EventType4Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType4Id;
    /**
     * The EventType5Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType5Id;
    /**
     * The EventTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeId;
    /**
     * The FaceValuePriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FaceValuePriceListId;
    /**
     * The IsRelativeVisibilityEndTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRelativeVisibilityEndTime;
    /**
     * The IsRelativeVisibilityStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRelativeVisibilityStartTime;
    /**
     * The IsSGOServiceActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSGOServiceActive;
    /**
     * The IsUpdateCalcPotentialPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateCalcPotentialPriceList;
    /**
     * The IsUpdateCompanyOwnsInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateCompanyOwnsInventory;
    /**
     * The IsUpdateDateFormatOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateDateFormatOptions;
    /**
     * The IsUpdateDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateDisplayName;
    /**
     * The IsUpdateEventSaleFlowMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventSaleFlowMode;
    /**
     * The IsUpdateEventTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventTags;
    /**
     * The IsUpdateEventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventTime;
    /**
     * The IsUpdateEventType1Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventType1Id;
    /**
     * The IsUpdateEventType2Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventType2Id;
    /**
     * The IsUpdateEventType3Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventType3Id;
    /**
     * The IsUpdateEventType4Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventType4Id;
    /**
     * The IsUpdateEventType5Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventType5Id;
    /**
     * The IsUpdateEventTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateEventTypeId;
    /**
     * The IsUpdateFaceValuePriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateFaceValuePriceList;
    /**
     * The IsUpdateLedgerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateLedgerId;
    /**
     * The IsUpdateOrganizerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateOrganizerId;
    /**
     * The IsUpdateOwnerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateOwnerId;
    /**
     * The IsUpdatePrimaryPerformer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdatePrimaryPerformer;
    /**
     * The IsUpdateProjectIdentifierId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateProjectIdentifierId;
    /**
     * The IsUpdatePromoterId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdatePromoterId;
    /**
     * The IsUpdateSalesTargetValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateSalesTargetValue;
    /**
     * The IsUpdateSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateSaleStatus;
    /**
     * The IsUpdateSecondaryPerformers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateSecondaryPerformers;
    /**
     * The IsUpdateTaxonomy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateTaxonomy;
    /**
     * The IsUpdateUseAccessControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateUseAccessControl;
    /**
     * The IsUpdateVisibility
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateVisibility;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The OrganizerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizerId;
    /**
     * The OverrideTaxonomy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OverrideTaxonomy;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The PerformerIdsToRetrieve
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerformerIdsToRetrieve;
    /**
     * The Performers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_PerformerData
     */
    public $Performers;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The PromoterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterId;
    /**
     * The PublicVisibilityEndTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublicVisibilityEndTime;
    /**
     * The PublicVisibilityIsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PublicVisibilityIsEnabled;
    /**
     * The PublicVisibilityStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublicVisibilityStartTime;
    /**
     * The SalesTargetValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SalesTargetValue;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SaleStatus;
    /**
     * The StartDisplayTime
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $StartDisplayTime;
    /**
     * The StartDisplayTimeWhen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDisplayTimeWhen;
    /**
     * The StopDisplayTime
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $StopDisplayTime;
    /**
     * The StopDisplayTimeWhen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StopDisplayTimeWhen;
    /**
     * The SummaryText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SummaryText;
    /**
     * The TaxonomyGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TaxonomyGuid;
    /**
     * The TaxonomyId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TaxonomyId;
    /**
     * The TaxonomyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyName;
    /**
     * The UseAccessControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAccessControl;
    /**
     * Constructor method for BizAction.Ticketing.UpdatePropertiesOfEvents.Request
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setCalcPotentialPriceListId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setCompanyOwnsInventory()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setComplimentaryEventIds()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setDateFormatOptions()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setDatesToExclude()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setDisplayName()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventIds()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventSaleFlowMode()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventsCriteria()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventTagIds()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventType1Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventType2Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventType3Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventType4Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventType5Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setEventTypeId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setFaceValuePriceListId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsRelativeVisibilityEndTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsRelativeVisibilityStartTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsSGOServiceActive()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateCalcPotentialPriceList()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateCompanyOwnsInventory()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateDateFormatOptions()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateDisplayName()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventSaleFlowMode()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventTags()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventType1Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventType2Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventType3Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventType4Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventType5Id()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateEventTypeId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateFaceValuePriceList()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateLedgerId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateOrganizerId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateOwnerId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdatePrimaryPerformer()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateProjectIdentifierId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdatePromoterId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateSalesTargetValue()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateSaleStatus()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateSecondaryPerformers()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateTaxonomy()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateUseAccessControl()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setIsUpdateVisibility()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setLedgerId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setOrganizerId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setOverrideTaxonomy()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setOwnerId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setPerformerIdsToRetrieve()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setPerformers()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setProjectIdentifierId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setPromoterId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setPublicVisibilityEndTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setPublicVisibilityIsEnabled()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setPublicVisibilityStartTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setSalesTargetValue()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setSaleStatus()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setStartDisplayTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setStartDisplayTimeWhen()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setStopDisplayTime()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setStopDisplayTimeWhen()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setSummaryText()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setTaxonomyGuid()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setTaxonomyId()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setTaxonomyName()
     * @uses BizAction_Ticketing_UpdatePropertiesOfEvents_Request::setUseAccessControl()
     * @param string $calcPotentialPriceListId
     * @param bool $companyOwnsInventory
     * @param string $complimentaryEventIds
     * @param string $dateFormatOptions
     * @param \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude
     * @param string $displayName
     * @param \patest\StructType\EventIds $eventIds
     * @param string $eventSaleFlowMode
     * @param \patest\StructType\Ticketing_UpdatePropertiesOfEvents_Criteria $eventsCriteria
     * @param string $eventTagIds
     * @param string $eventTime
     * @param string $eventType1Id
     * @param string $eventType2Id
     * @param string $eventType3Id
     * @param string $eventType4Id
     * @param string $eventType5Id
     * @param string $eventTypeId
     * @param string $faceValuePriceListId
     * @param bool $isRelativeVisibilityEndTime
     * @param bool $isRelativeVisibilityStartTime
     * @param bool $isSGOServiceActive
     * @param bool $isUpdateCalcPotentialPriceList
     * @param bool $isUpdateCompanyOwnsInventory
     * @param bool $isUpdateDateFormatOptions
     * @param bool $isUpdateDisplayName
     * @param bool $isUpdateEventSaleFlowMode
     * @param bool $isUpdateEventTags
     * @param bool $isUpdateEventTime
     * @param bool $isUpdateEventType1Id
     * @param bool $isUpdateEventType2Id
     * @param bool $isUpdateEventType3Id
     * @param bool $isUpdateEventType4Id
     * @param bool $isUpdateEventType5Id
     * @param bool $isUpdateEventTypeId
     * @param bool $isUpdateFaceValuePriceList
     * @param bool $isUpdateLedgerId
     * @param bool $isUpdateOrganizerId
     * @param bool $isUpdateOwnerId
     * @param bool $isUpdatePrimaryPerformer
     * @param bool $isUpdateProjectIdentifierId
     * @param bool $isUpdatePromoterId
     * @param bool $isUpdateSalesTargetValue
     * @param bool $isUpdateSaleStatus
     * @param bool $isUpdateSecondaryPerformers
     * @param bool $isUpdateTaxonomy
     * @param bool $isUpdateUseAccessControl
     * @param bool $isUpdateVisibility
     * @param string $ledgerId
     * @param string $organizerId
     * @param bool $overrideTaxonomy
     * @param string $ownerId
     * @param string $performerIdsToRetrieve
     * @param \patest\StructType\RecordSetOfTicketing_PerformerData $performers
     * @param string $projectIdentifierId
     * @param string $promoterId
     * @param string $publicVisibilityEndTime
     * @param bool $publicVisibilityIsEnabled
     * @param string $publicVisibilityStartTime
     * @param \patest\StructType\Money $salesTargetValue
     * @param string[] $saleStatus
     * @param string $startDisplayTime
     * @param string $startDisplayTimeWhen
     * @param string $stopDisplayTime
     * @param string $stopDisplayTimeWhen
     * @param string $summaryText
     * @param string $taxonomyGuid
     * @param int $taxonomyId
     * @param string $taxonomyName
     * @param bool $useAccessControl
     */
    public function __construct($calcPotentialPriceListId = null, $companyOwnsInventory = null, $complimentaryEventIds = null, $dateFormatOptions = null, \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude = null, $displayName = null, \patest\StructType\EventIds $eventIds = null, $eventSaleFlowMode = null, \patest\StructType\Ticketing_UpdatePropertiesOfEvents_Criteria $eventsCriteria = null, $eventTagIds = null, $eventTime = null, $eventType1Id = null, $eventType2Id = null, $eventType3Id = null, $eventType4Id = null, $eventType5Id = null, $eventTypeId = null, $faceValuePriceListId = null, $isRelativeVisibilityEndTime = null, $isRelativeVisibilityStartTime = null, $isSGOServiceActive = null, $isUpdateCalcPotentialPriceList = null, $isUpdateCompanyOwnsInventory = null, $isUpdateDateFormatOptions = null, $isUpdateDisplayName = null, $isUpdateEventSaleFlowMode = null, $isUpdateEventTags = null, $isUpdateEventTime = null, $isUpdateEventType1Id = null, $isUpdateEventType2Id = null, $isUpdateEventType3Id = null, $isUpdateEventType4Id = null, $isUpdateEventType5Id = null, $isUpdateEventTypeId = null, $isUpdateFaceValuePriceList = null, $isUpdateLedgerId = null, $isUpdateOrganizerId = null, $isUpdateOwnerId = null, $isUpdatePrimaryPerformer = null, $isUpdateProjectIdentifierId = null, $isUpdatePromoterId = null, $isUpdateSalesTargetValue = null, $isUpdateSaleStatus = null, $isUpdateSecondaryPerformers = null, $isUpdateTaxonomy = null, $isUpdateUseAccessControl = null, $isUpdateVisibility = null, $ledgerId = null, $organizerId = null, $overrideTaxonomy = null, $ownerId = null, $performerIdsToRetrieve = null, \patest\StructType\RecordSetOfTicketing_PerformerData $performers = null, $projectIdentifierId = null, $promoterId = null, $publicVisibilityEndTime = null, $publicVisibilityIsEnabled = null, $publicVisibilityStartTime = null, \patest\StructType\Money $salesTargetValue = null, array $saleStatus = array(), $startDisplayTime = null, $startDisplayTimeWhen = null, $stopDisplayTime = null, $stopDisplayTimeWhen = null, $summaryText = null, $taxonomyGuid = null, $taxonomyId = null, $taxonomyName = null, $useAccessControl = null)
    {
        $this
            ->setCalcPotentialPriceListId($calcPotentialPriceListId)
            ->setCompanyOwnsInventory($companyOwnsInventory)
            ->setComplimentaryEventIds($complimentaryEventIds)
            ->setDateFormatOptions($dateFormatOptions)
            ->setDatesToExclude($datesToExclude)
            ->setDisplayName($displayName)
            ->setEventIds($eventIds)
            ->setEventSaleFlowMode($eventSaleFlowMode)
            ->setEventsCriteria($eventsCriteria)
            ->setEventTagIds($eventTagIds)
            ->setEventTime($eventTime)
            ->setEventType1Id($eventType1Id)
            ->setEventType2Id($eventType2Id)
            ->setEventType3Id($eventType3Id)
            ->setEventType4Id($eventType4Id)
            ->setEventType5Id($eventType5Id)
            ->setEventTypeId($eventTypeId)
            ->setFaceValuePriceListId($faceValuePriceListId)
            ->setIsRelativeVisibilityEndTime($isRelativeVisibilityEndTime)
            ->setIsRelativeVisibilityStartTime($isRelativeVisibilityStartTime)
            ->setIsSGOServiceActive($isSGOServiceActive)
            ->setIsUpdateCalcPotentialPriceList($isUpdateCalcPotentialPriceList)
            ->setIsUpdateCompanyOwnsInventory($isUpdateCompanyOwnsInventory)
            ->setIsUpdateDateFormatOptions($isUpdateDateFormatOptions)
            ->setIsUpdateDisplayName($isUpdateDisplayName)
            ->setIsUpdateEventSaleFlowMode($isUpdateEventSaleFlowMode)
            ->setIsUpdateEventTags($isUpdateEventTags)
            ->setIsUpdateEventTime($isUpdateEventTime)
            ->setIsUpdateEventType1Id($isUpdateEventType1Id)
            ->setIsUpdateEventType2Id($isUpdateEventType2Id)
            ->setIsUpdateEventType3Id($isUpdateEventType3Id)
            ->setIsUpdateEventType4Id($isUpdateEventType4Id)
            ->setIsUpdateEventType5Id($isUpdateEventType5Id)
            ->setIsUpdateEventTypeId($isUpdateEventTypeId)
            ->setIsUpdateFaceValuePriceList($isUpdateFaceValuePriceList)
            ->setIsUpdateLedgerId($isUpdateLedgerId)
            ->setIsUpdateOrganizerId($isUpdateOrganizerId)
            ->setIsUpdateOwnerId($isUpdateOwnerId)
            ->setIsUpdatePrimaryPerformer($isUpdatePrimaryPerformer)
            ->setIsUpdateProjectIdentifierId($isUpdateProjectIdentifierId)
            ->setIsUpdatePromoterId($isUpdatePromoterId)
            ->setIsUpdateSalesTargetValue($isUpdateSalesTargetValue)
            ->setIsUpdateSaleStatus($isUpdateSaleStatus)
            ->setIsUpdateSecondaryPerformers($isUpdateSecondaryPerformers)
            ->setIsUpdateTaxonomy($isUpdateTaxonomy)
            ->setIsUpdateUseAccessControl($isUpdateUseAccessControl)
            ->setIsUpdateVisibility($isUpdateVisibility)
            ->setLedgerId($ledgerId)
            ->setOrganizerId($organizerId)
            ->setOverrideTaxonomy($overrideTaxonomy)
            ->setOwnerId($ownerId)
            ->setPerformerIdsToRetrieve($performerIdsToRetrieve)
            ->setPerformers($performers)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setPromoterId($promoterId)
            ->setPublicVisibilityEndTime($publicVisibilityEndTime)
            ->setPublicVisibilityIsEnabled($publicVisibilityIsEnabled)
            ->setPublicVisibilityStartTime($publicVisibilityStartTime)
            ->setSalesTargetValue($salesTargetValue)
            ->setSaleStatus($saleStatus)
            ->setStartDisplayTime($startDisplayTime)
            ->setStartDisplayTimeWhen($startDisplayTimeWhen)
            ->setStopDisplayTime($stopDisplayTime)
            ->setStopDisplayTimeWhen($stopDisplayTimeWhen)
            ->setSummaryText($summaryText)
            ->setTaxonomyGuid($taxonomyGuid)
            ->setTaxonomyId($taxonomyId)
            ->setTaxonomyName($taxonomyName)
            ->setUseAccessControl($useAccessControl);
    }
    /**
     * Get CalcPotentialPriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalcPotentialPriceListId()
    {
        return isset($this->CalcPotentialPriceListId) ? $this->CalcPotentialPriceListId : null;
    }
    /**
     * Set CalcPotentialPriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calcPotentialPriceListId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setCalcPotentialPriceListId($calcPotentialPriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($calcPotentialPriceListId) && !is_string($calcPotentialPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcPotentialPriceListId, true), gettype($calcPotentialPriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($calcPotentialPriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $calcPotentialPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($calcPotentialPriceListId, true)), __LINE__);
        }
        if (is_null($calcPotentialPriceListId) || (is_array($calcPotentialPriceListId) && empty($calcPotentialPriceListId))) {
            unset($this->CalcPotentialPriceListId);
        } else {
            $this->CalcPotentialPriceListId = $calcPotentialPriceListId;
        }
        return $this;
    }
    /**
     * Get CompanyOwnsInventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCompanyOwnsInventory()
    {
        return isset($this->CompanyOwnsInventory) ? $this->CompanyOwnsInventory : null;
    }
    /**
     * Set CompanyOwnsInventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $companyOwnsInventory
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setCompanyOwnsInventory($companyOwnsInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($companyOwnsInventory) && !is_bool($companyOwnsInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($companyOwnsInventory, true), gettype($companyOwnsInventory)), __LINE__);
        }
        if (is_null($companyOwnsInventory) || (is_array($companyOwnsInventory) && empty($companyOwnsInventory))) {
            unset($this->CompanyOwnsInventory);
        } else {
            $this->CompanyOwnsInventory = $companyOwnsInventory;
        }
        return $this;
    }
    /**
     * Get ComplimentaryEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplimentaryEventIds()
    {
        return isset($this->ComplimentaryEventIds) ? $this->ComplimentaryEventIds : null;
    }
    /**
     * Set ComplimentaryEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $complimentaryEventIds
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setComplimentaryEventIds($complimentaryEventIds = null)
    {
        // validation for constraint: string
        if (!is_null($complimentaryEventIds) && !is_string($complimentaryEventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complimentaryEventIds, true), gettype($complimentaryEventIds)), __LINE__);
        }
        if (is_null($complimentaryEventIds) || (is_array($complimentaryEventIds) && empty($complimentaryEventIds))) {
            unset($this->ComplimentaryEventIds);
        } else {
            $this->ComplimentaryEventIds = $complimentaryEventIds;
        }
        return $this;
    }
    /**
     * Get DateFormatOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFormatOptions()
    {
        return isset($this->DateFormatOptions) ? $this->DateFormatOptions : null;
    }
    /**
     * Set DateFormatOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventDateFormatOptions::valueIsValid()
     * @uses \patest\EnumType\EventDateFormatOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateFormatOptions
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setDateFormatOptions($dateFormatOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventDateFormatOptions::valueIsValid($dateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventDateFormatOptions', is_array($dateFormatOptions) ? implode(', ', $dateFormatOptions) : var_export($dateFormatOptions, true), implode(', ', \patest\EnumType\EventDateFormatOptions::getValidValues())), __LINE__);
        }
        if (is_null($dateFormatOptions) || (is_array($dateFormatOptions) && empty($dateFormatOptions))) {
            unset($this->DateFormatOptions);
        } else {
            $this->DateFormatOptions = $dateFormatOptions;
        }
        return $this;
    }
    /**
     * Get DatesToExclude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_DatesToExclude|null
     */
    public function getDatesToExclude()
    {
        return isset($this->DatesToExclude) ? $this->DatesToExclude : null;
    }
    /**
     * Set DatesToExclude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setDatesToExclude(\patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude = null)
    {
        if (is_null($datesToExclude) || (is_array($datesToExclude) && empty($datesToExclude))) {
            unset($this->DatesToExclude);
        } else {
            $this->DatesToExclude = $datesToExclude;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get EventSaleFlowMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventSaleFlowMode()
    {
        return isset($this->EventSaleFlowMode) ? $this->EventSaleFlowMode : null;
    }
    /**
     * Set EventSaleFlowMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleFlowMode::valueIsValid()
     * @uses \patest\EnumType\EventSaleFlowMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventSaleFlowMode
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventSaleFlowMode($eventSaleFlowMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventSaleFlowMode::valueIsValid($eventSaleFlowMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleFlowMode', is_array($eventSaleFlowMode) ? implode(', ', $eventSaleFlowMode) : var_export($eventSaleFlowMode, true), implode(', ', \patest\EnumType\EventSaleFlowMode::getValidValues())), __LINE__);
        }
        if (is_null($eventSaleFlowMode) || (is_array($eventSaleFlowMode) && empty($eventSaleFlowMode))) {
            unset($this->EventSaleFlowMode);
        } else {
            $this->EventSaleFlowMode = $eventSaleFlowMode;
        }
        return $this;
    }
    /**
     * Get EventsCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_UpdatePropertiesOfEvents_Criteria|null
     */
    public function getEventsCriteria()
    {
        return isset($this->EventsCriteria) ? $this->EventsCriteria : null;
    }
    /**
     * Set EventsCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_UpdatePropertiesOfEvents_Criteria $eventsCriteria
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventsCriteria(\patest\StructType\Ticketing_UpdatePropertiesOfEvents_Criteria $eventsCriteria = null)
    {
        if (is_null($eventsCriteria) || (is_array($eventsCriteria) && empty($eventsCriteria))) {
            unset($this->EventsCriteria);
        } else {
            $this->EventsCriteria = $eventsCriteria;
        }
        return $this;
    }
    /**
     * Get EventTagIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTagIds()
    {
        return isset($this->EventTagIds) ? $this->EventTagIds : null;
    }
    /**
     * Set EventTagIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTagIds
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventTagIds($eventTagIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventTagIds) && !is_string($eventTagIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTagIds, true), gettype($eventTagIds)), __LINE__);
        }
        if (is_null($eventTagIds) || (is_array($eventTagIds) && empty($eventTagIds))) {
            unset($this->EventTagIds);
        } else {
            $this->EventTagIds = $eventTagIds;
        }
        return $this;
    }
    /**
     * Get EventTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTime()
    {
        return isset($this->EventTime) ? $this->EventTime : null;
    }
    /**
     * Set EventTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventTime($eventTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventTime) && !is_string($eventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTime, true), gettype($eventTime)), __LINE__);
        }
        if (is_null($eventTime) || (is_array($eventTime) && empty($eventTime))) {
            unset($this->EventTime);
        } else {
            $this->EventTime = $eventTime;
        }
        return $this;
    }
    /**
     * Get EventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType1Id()
    {
        return isset($this->EventType1Id) ? $this->EventType1Id : null;
    }
    /**
     * Set EventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType1Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventType1Id($eventType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType1Id) && !is_string($eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType1Id, true), gettype($eventType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType1Id, true)), __LINE__);
        }
        if (is_null($eventType1Id) || (is_array($eventType1Id) && empty($eventType1Id))) {
            unset($this->EventType1Id);
        } else {
            $this->EventType1Id = $eventType1Id;
        }
        return $this;
    }
    /**
     * Get EventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType2Id()
    {
        return isset($this->EventType2Id) ? $this->EventType2Id : null;
    }
    /**
     * Set EventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType2Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventType2Id($eventType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType2Id) && !is_string($eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType2Id, true), gettype($eventType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType2Id, true)), __LINE__);
        }
        if (is_null($eventType2Id) || (is_array($eventType2Id) && empty($eventType2Id))) {
            unset($this->EventType2Id);
        } else {
            $this->EventType2Id = $eventType2Id;
        }
        return $this;
    }
    /**
     * Get EventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType3Id()
    {
        return isset($this->EventType3Id) ? $this->EventType3Id : null;
    }
    /**
     * Set EventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType3Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventType3Id($eventType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType3Id) && !is_string($eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType3Id, true), gettype($eventType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType3Id, true)), __LINE__);
        }
        if (is_null($eventType3Id) || (is_array($eventType3Id) && empty($eventType3Id))) {
            unset($this->EventType3Id);
        } else {
            $this->EventType3Id = $eventType3Id;
        }
        return $this;
    }
    /**
     * Get EventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType4Id()
    {
        return isset($this->EventType4Id) ? $this->EventType4Id : null;
    }
    /**
     * Set EventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType4Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventType4Id($eventType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType4Id) && !is_string($eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType4Id, true), gettype($eventType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType4Id, true)), __LINE__);
        }
        if (is_null($eventType4Id) || (is_array($eventType4Id) && empty($eventType4Id))) {
            unset($this->EventType4Id);
        } else {
            $this->EventType4Id = $eventType4Id;
        }
        return $this;
    }
    /**
     * Get EventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType5Id()
    {
        return isset($this->EventType5Id) ? $this->EventType5Id : null;
    }
    /**
     * Set EventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType5Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventType5Id($eventType5Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType5Id) && !is_string($eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType5Id, true), gettype($eventType5Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType5Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType5Id, true)), __LINE__);
        }
        if (is_null($eventType5Id) || (is_array($eventType5Id) && empty($eventType5Id))) {
            unset($this->EventType5Id);
        } else {
            $this->EventType5Id = $eventType5Id;
        }
        return $this;
    }
    /**
     * Get EventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeId()
    {
        return isset($this->EventTypeId) ? $this->EventTypeId : null;
    }
    /**
     * Set EventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setEventTypeId($eventTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeId) && !is_string($eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeId, true), gettype($eventTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeId, true)), __LINE__);
        }
        if (is_null($eventTypeId) || (is_array($eventTypeId) && empty($eventTypeId))) {
            unset($this->EventTypeId);
        } else {
            $this->EventTypeId = $eventTypeId;
        }
        return $this;
    }
    /**
     * Get FaceValuePriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaceValuePriceListId()
    {
        return isset($this->FaceValuePriceListId) ? $this->FaceValuePriceListId : null;
    }
    /**
     * Set FaceValuePriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faceValuePriceListId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setFaceValuePriceListId($faceValuePriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($faceValuePriceListId) && !is_string($faceValuePriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faceValuePriceListId, true), gettype($faceValuePriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($faceValuePriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $faceValuePriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($faceValuePriceListId, true)), __LINE__);
        }
        if (is_null($faceValuePriceListId) || (is_array($faceValuePriceListId) && empty($faceValuePriceListId))) {
            unset($this->FaceValuePriceListId);
        } else {
            $this->FaceValuePriceListId = $faceValuePriceListId;
        }
        return $this;
    }
    /**
     * Get IsRelativeVisibilityEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRelativeVisibilityEndTime()
    {
        return isset($this->IsRelativeVisibilityEndTime) ? $this->IsRelativeVisibilityEndTime : null;
    }
    /**
     * Set IsRelativeVisibilityEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRelativeVisibilityEndTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsRelativeVisibilityEndTime($isRelativeVisibilityEndTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelativeVisibilityEndTime) && !is_bool($isRelativeVisibilityEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelativeVisibilityEndTime, true), gettype($isRelativeVisibilityEndTime)), __LINE__);
        }
        if (is_null($isRelativeVisibilityEndTime) || (is_array($isRelativeVisibilityEndTime) && empty($isRelativeVisibilityEndTime))) {
            unset($this->IsRelativeVisibilityEndTime);
        } else {
            $this->IsRelativeVisibilityEndTime = $isRelativeVisibilityEndTime;
        }
        return $this;
    }
    /**
     * Get IsRelativeVisibilityStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRelativeVisibilityStartTime()
    {
        return isset($this->IsRelativeVisibilityStartTime) ? $this->IsRelativeVisibilityStartTime : null;
    }
    /**
     * Set IsRelativeVisibilityStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRelativeVisibilityStartTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsRelativeVisibilityStartTime($isRelativeVisibilityStartTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelativeVisibilityStartTime) && !is_bool($isRelativeVisibilityStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelativeVisibilityStartTime, true), gettype($isRelativeVisibilityStartTime)), __LINE__);
        }
        if (is_null($isRelativeVisibilityStartTime) || (is_array($isRelativeVisibilityStartTime) && empty($isRelativeVisibilityStartTime))) {
            unset($this->IsRelativeVisibilityStartTime);
        } else {
            $this->IsRelativeVisibilityStartTime = $isRelativeVisibilityStartTime;
        }
        return $this;
    }
    /**
     * Get IsSGOServiceActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSGOServiceActive()
    {
        return isset($this->IsSGOServiceActive) ? $this->IsSGOServiceActive : null;
    }
    /**
     * Set IsSGOServiceActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSGOServiceActive
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsSGOServiceActive($isSGOServiceActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSGOServiceActive) && !is_bool($isSGOServiceActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSGOServiceActive, true), gettype($isSGOServiceActive)), __LINE__);
        }
        if (is_null($isSGOServiceActive) || (is_array($isSGOServiceActive) && empty($isSGOServiceActive))) {
            unset($this->IsSGOServiceActive);
        } else {
            $this->IsSGOServiceActive = $isSGOServiceActive;
        }
        return $this;
    }
    /**
     * Get IsUpdateCalcPotentialPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateCalcPotentialPriceList()
    {
        return isset($this->IsUpdateCalcPotentialPriceList) ? $this->IsUpdateCalcPotentialPriceList : null;
    }
    /**
     * Set IsUpdateCalcPotentialPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateCalcPotentialPriceList
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateCalcPotentialPriceList($isUpdateCalcPotentialPriceList = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateCalcPotentialPriceList) && !is_bool($isUpdateCalcPotentialPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateCalcPotentialPriceList, true), gettype($isUpdateCalcPotentialPriceList)), __LINE__);
        }
        if (is_null($isUpdateCalcPotentialPriceList) || (is_array($isUpdateCalcPotentialPriceList) && empty($isUpdateCalcPotentialPriceList))) {
            unset($this->IsUpdateCalcPotentialPriceList);
        } else {
            $this->IsUpdateCalcPotentialPriceList = $isUpdateCalcPotentialPriceList;
        }
        return $this;
    }
    /**
     * Get IsUpdateCompanyOwnsInventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateCompanyOwnsInventory()
    {
        return isset($this->IsUpdateCompanyOwnsInventory) ? $this->IsUpdateCompanyOwnsInventory : null;
    }
    /**
     * Set IsUpdateCompanyOwnsInventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateCompanyOwnsInventory
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateCompanyOwnsInventory($isUpdateCompanyOwnsInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateCompanyOwnsInventory) && !is_bool($isUpdateCompanyOwnsInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateCompanyOwnsInventory, true), gettype($isUpdateCompanyOwnsInventory)), __LINE__);
        }
        if (is_null($isUpdateCompanyOwnsInventory) || (is_array($isUpdateCompanyOwnsInventory) && empty($isUpdateCompanyOwnsInventory))) {
            unset($this->IsUpdateCompanyOwnsInventory);
        } else {
            $this->IsUpdateCompanyOwnsInventory = $isUpdateCompanyOwnsInventory;
        }
        return $this;
    }
    /**
     * Get IsUpdateDateFormatOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateDateFormatOptions()
    {
        return isset($this->IsUpdateDateFormatOptions) ? $this->IsUpdateDateFormatOptions : null;
    }
    /**
     * Set IsUpdateDateFormatOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateDateFormatOptions
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateDateFormatOptions($isUpdateDateFormatOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateDateFormatOptions) && !is_bool($isUpdateDateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateDateFormatOptions, true), gettype($isUpdateDateFormatOptions)), __LINE__);
        }
        if (is_null($isUpdateDateFormatOptions) || (is_array($isUpdateDateFormatOptions) && empty($isUpdateDateFormatOptions))) {
            unset($this->IsUpdateDateFormatOptions);
        } else {
            $this->IsUpdateDateFormatOptions = $isUpdateDateFormatOptions;
        }
        return $this;
    }
    /**
     * Get IsUpdateDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateDisplayName()
    {
        return isset($this->IsUpdateDisplayName) ? $this->IsUpdateDisplayName : null;
    }
    /**
     * Set IsUpdateDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateDisplayName
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateDisplayName($isUpdateDisplayName = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateDisplayName) && !is_bool($isUpdateDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateDisplayName, true), gettype($isUpdateDisplayName)), __LINE__);
        }
        if (is_null($isUpdateDisplayName) || (is_array($isUpdateDisplayName) && empty($isUpdateDisplayName))) {
            unset($this->IsUpdateDisplayName);
        } else {
            $this->IsUpdateDisplayName = $isUpdateDisplayName;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventSaleFlowMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventSaleFlowMode()
    {
        return isset($this->IsUpdateEventSaleFlowMode) ? $this->IsUpdateEventSaleFlowMode : null;
    }
    /**
     * Set IsUpdateEventSaleFlowMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventSaleFlowMode
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventSaleFlowMode($isUpdateEventSaleFlowMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventSaleFlowMode) && !is_bool($isUpdateEventSaleFlowMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventSaleFlowMode, true), gettype($isUpdateEventSaleFlowMode)), __LINE__);
        }
        if (is_null($isUpdateEventSaleFlowMode) || (is_array($isUpdateEventSaleFlowMode) && empty($isUpdateEventSaleFlowMode))) {
            unset($this->IsUpdateEventSaleFlowMode);
        } else {
            $this->IsUpdateEventSaleFlowMode = $isUpdateEventSaleFlowMode;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventTags()
    {
        return isset($this->IsUpdateEventTags) ? $this->IsUpdateEventTags : null;
    }
    /**
     * Set IsUpdateEventTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventTags
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventTags($isUpdateEventTags = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventTags) && !is_bool($isUpdateEventTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventTags, true), gettype($isUpdateEventTags)), __LINE__);
        }
        if (is_null($isUpdateEventTags) || (is_array($isUpdateEventTags) && empty($isUpdateEventTags))) {
            unset($this->IsUpdateEventTags);
        } else {
            $this->IsUpdateEventTags = $isUpdateEventTags;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventTime()
    {
        return isset($this->IsUpdateEventTime) ? $this->IsUpdateEventTime : null;
    }
    /**
     * Set IsUpdateEventTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventTime($isUpdateEventTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventTime) && !is_bool($isUpdateEventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventTime, true), gettype($isUpdateEventTime)), __LINE__);
        }
        if (is_null($isUpdateEventTime) || (is_array($isUpdateEventTime) && empty($isUpdateEventTime))) {
            unset($this->IsUpdateEventTime);
        } else {
            $this->IsUpdateEventTime = $isUpdateEventTime;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventType1Id()
    {
        return isset($this->IsUpdateEventType1Id) ? $this->IsUpdateEventType1Id : null;
    }
    /**
     * Set IsUpdateEventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventType1Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventType1Id($isUpdateEventType1Id = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventType1Id) && !is_bool($isUpdateEventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventType1Id, true), gettype($isUpdateEventType1Id)), __LINE__);
        }
        if (is_null($isUpdateEventType1Id) || (is_array($isUpdateEventType1Id) && empty($isUpdateEventType1Id))) {
            unset($this->IsUpdateEventType1Id);
        } else {
            $this->IsUpdateEventType1Id = $isUpdateEventType1Id;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventType2Id()
    {
        return isset($this->IsUpdateEventType2Id) ? $this->IsUpdateEventType2Id : null;
    }
    /**
     * Set IsUpdateEventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventType2Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventType2Id($isUpdateEventType2Id = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventType2Id) && !is_bool($isUpdateEventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventType2Id, true), gettype($isUpdateEventType2Id)), __LINE__);
        }
        if (is_null($isUpdateEventType2Id) || (is_array($isUpdateEventType2Id) && empty($isUpdateEventType2Id))) {
            unset($this->IsUpdateEventType2Id);
        } else {
            $this->IsUpdateEventType2Id = $isUpdateEventType2Id;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventType3Id()
    {
        return isset($this->IsUpdateEventType3Id) ? $this->IsUpdateEventType3Id : null;
    }
    /**
     * Set IsUpdateEventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventType3Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventType3Id($isUpdateEventType3Id = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventType3Id) && !is_bool($isUpdateEventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventType3Id, true), gettype($isUpdateEventType3Id)), __LINE__);
        }
        if (is_null($isUpdateEventType3Id) || (is_array($isUpdateEventType3Id) && empty($isUpdateEventType3Id))) {
            unset($this->IsUpdateEventType3Id);
        } else {
            $this->IsUpdateEventType3Id = $isUpdateEventType3Id;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventType4Id()
    {
        return isset($this->IsUpdateEventType4Id) ? $this->IsUpdateEventType4Id : null;
    }
    /**
     * Set IsUpdateEventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventType4Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventType4Id($isUpdateEventType4Id = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventType4Id) && !is_bool($isUpdateEventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventType4Id, true), gettype($isUpdateEventType4Id)), __LINE__);
        }
        if (is_null($isUpdateEventType4Id) || (is_array($isUpdateEventType4Id) && empty($isUpdateEventType4Id))) {
            unset($this->IsUpdateEventType4Id);
        } else {
            $this->IsUpdateEventType4Id = $isUpdateEventType4Id;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventType5Id()
    {
        return isset($this->IsUpdateEventType5Id) ? $this->IsUpdateEventType5Id : null;
    }
    /**
     * Set IsUpdateEventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventType5Id
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventType5Id($isUpdateEventType5Id = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventType5Id) && !is_bool($isUpdateEventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventType5Id, true), gettype($isUpdateEventType5Id)), __LINE__);
        }
        if (is_null($isUpdateEventType5Id) || (is_array($isUpdateEventType5Id) && empty($isUpdateEventType5Id))) {
            unset($this->IsUpdateEventType5Id);
        } else {
            $this->IsUpdateEventType5Id = $isUpdateEventType5Id;
        }
        return $this;
    }
    /**
     * Get IsUpdateEventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateEventTypeId()
    {
        return isset($this->IsUpdateEventTypeId) ? $this->IsUpdateEventTypeId : null;
    }
    /**
     * Set IsUpdateEventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateEventTypeId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateEventTypeId($isUpdateEventTypeId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateEventTypeId) && !is_bool($isUpdateEventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateEventTypeId, true), gettype($isUpdateEventTypeId)), __LINE__);
        }
        if (is_null($isUpdateEventTypeId) || (is_array($isUpdateEventTypeId) && empty($isUpdateEventTypeId))) {
            unset($this->IsUpdateEventTypeId);
        } else {
            $this->IsUpdateEventTypeId = $isUpdateEventTypeId;
        }
        return $this;
    }
    /**
     * Get IsUpdateFaceValuePriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateFaceValuePriceList()
    {
        return isset($this->IsUpdateFaceValuePriceList) ? $this->IsUpdateFaceValuePriceList : null;
    }
    /**
     * Set IsUpdateFaceValuePriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateFaceValuePriceList
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateFaceValuePriceList($isUpdateFaceValuePriceList = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateFaceValuePriceList) && !is_bool($isUpdateFaceValuePriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateFaceValuePriceList, true), gettype($isUpdateFaceValuePriceList)), __LINE__);
        }
        if (is_null($isUpdateFaceValuePriceList) || (is_array($isUpdateFaceValuePriceList) && empty($isUpdateFaceValuePriceList))) {
            unset($this->IsUpdateFaceValuePriceList);
        } else {
            $this->IsUpdateFaceValuePriceList = $isUpdateFaceValuePriceList;
        }
        return $this;
    }
    /**
     * Get IsUpdateLedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateLedgerId()
    {
        return isset($this->IsUpdateLedgerId) ? $this->IsUpdateLedgerId : null;
    }
    /**
     * Set IsUpdateLedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateLedgerId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateLedgerId($isUpdateLedgerId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateLedgerId) && !is_bool($isUpdateLedgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateLedgerId, true), gettype($isUpdateLedgerId)), __LINE__);
        }
        if (is_null($isUpdateLedgerId) || (is_array($isUpdateLedgerId) && empty($isUpdateLedgerId))) {
            unset($this->IsUpdateLedgerId);
        } else {
            $this->IsUpdateLedgerId = $isUpdateLedgerId;
        }
        return $this;
    }
    /**
     * Get IsUpdateOrganizerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateOrganizerId()
    {
        return isset($this->IsUpdateOrganizerId) ? $this->IsUpdateOrganizerId : null;
    }
    /**
     * Set IsUpdateOrganizerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateOrganizerId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateOrganizerId($isUpdateOrganizerId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateOrganizerId) && !is_bool($isUpdateOrganizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateOrganizerId, true), gettype($isUpdateOrganizerId)), __LINE__);
        }
        if (is_null($isUpdateOrganizerId) || (is_array($isUpdateOrganizerId) && empty($isUpdateOrganizerId))) {
            unset($this->IsUpdateOrganizerId);
        } else {
            $this->IsUpdateOrganizerId = $isUpdateOrganizerId;
        }
        return $this;
    }
    /**
     * Get IsUpdateOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateOwnerId()
    {
        return isset($this->IsUpdateOwnerId) ? $this->IsUpdateOwnerId : null;
    }
    /**
     * Set IsUpdateOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateOwnerId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateOwnerId($isUpdateOwnerId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateOwnerId) && !is_bool($isUpdateOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateOwnerId, true), gettype($isUpdateOwnerId)), __LINE__);
        }
        if (is_null($isUpdateOwnerId) || (is_array($isUpdateOwnerId) && empty($isUpdateOwnerId))) {
            unset($this->IsUpdateOwnerId);
        } else {
            $this->IsUpdateOwnerId = $isUpdateOwnerId;
        }
        return $this;
    }
    /**
     * Get IsUpdatePrimaryPerformer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdatePrimaryPerformer()
    {
        return isset($this->IsUpdatePrimaryPerformer) ? $this->IsUpdatePrimaryPerformer : null;
    }
    /**
     * Set IsUpdatePrimaryPerformer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdatePrimaryPerformer
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdatePrimaryPerformer($isUpdatePrimaryPerformer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatePrimaryPerformer) && !is_bool($isUpdatePrimaryPerformer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdatePrimaryPerformer, true), gettype($isUpdatePrimaryPerformer)), __LINE__);
        }
        if (is_null($isUpdatePrimaryPerformer) || (is_array($isUpdatePrimaryPerformer) && empty($isUpdatePrimaryPerformer))) {
            unset($this->IsUpdatePrimaryPerformer);
        } else {
            $this->IsUpdatePrimaryPerformer = $isUpdatePrimaryPerformer;
        }
        return $this;
    }
    /**
     * Get IsUpdateProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateProjectIdentifierId()
    {
        return isset($this->IsUpdateProjectIdentifierId) ? $this->IsUpdateProjectIdentifierId : null;
    }
    /**
     * Set IsUpdateProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateProjectIdentifierId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateProjectIdentifierId($isUpdateProjectIdentifierId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateProjectIdentifierId) && !is_bool($isUpdateProjectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateProjectIdentifierId, true), gettype($isUpdateProjectIdentifierId)), __LINE__);
        }
        if (is_null($isUpdateProjectIdentifierId) || (is_array($isUpdateProjectIdentifierId) && empty($isUpdateProjectIdentifierId))) {
            unset($this->IsUpdateProjectIdentifierId);
        } else {
            $this->IsUpdateProjectIdentifierId = $isUpdateProjectIdentifierId;
        }
        return $this;
    }
    /**
     * Get IsUpdatePromoterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdatePromoterId()
    {
        return isset($this->IsUpdatePromoterId) ? $this->IsUpdatePromoterId : null;
    }
    /**
     * Set IsUpdatePromoterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdatePromoterId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdatePromoterId($isUpdatePromoterId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatePromoterId) && !is_bool($isUpdatePromoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdatePromoterId, true), gettype($isUpdatePromoterId)), __LINE__);
        }
        if (is_null($isUpdatePromoterId) || (is_array($isUpdatePromoterId) && empty($isUpdatePromoterId))) {
            unset($this->IsUpdatePromoterId);
        } else {
            $this->IsUpdatePromoterId = $isUpdatePromoterId;
        }
        return $this;
    }
    /**
     * Get IsUpdateSalesTargetValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateSalesTargetValue()
    {
        return isset($this->IsUpdateSalesTargetValue) ? $this->IsUpdateSalesTargetValue : null;
    }
    /**
     * Set IsUpdateSalesTargetValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateSalesTargetValue
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateSalesTargetValue($isUpdateSalesTargetValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSalesTargetValue) && !is_bool($isUpdateSalesTargetValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateSalesTargetValue, true), gettype($isUpdateSalesTargetValue)), __LINE__);
        }
        if (is_null($isUpdateSalesTargetValue) || (is_array($isUpdateSalesTargetValue) && empty($isUpdateSalesTargetValue))) {
            unset($this->IsUpdateSalesTargetValue);
        } else {
            $this->IsUpdateSalesTargetValue = $isUpdateSalesTargetValue;
        }
        return $this;
    }
    /**
     * Get IsUpdateSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateSaleStatus()
    {
        return isset($this->IsUpdateSaleStatus) ? $this->IsUpdateSaleStatus : null;
    }
    /**
     * Set IsUpdateSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateSaleStatus
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateSaleStatus($isUpdateSaleStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSaleStatus) && !is_bool($isUpdateSaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateSaleStatus, true), gettype($isUpdateSaleStatus)), __LINE__);
        }
        if (is_null($isUpdateSaleStatus) || (is_array($isUpdateSaleStatus) && empty($isUpdateSaleStatus))) {
            unset($this->IsUpdateSaleStatus);
        } else {
            $this->IsUpdateSaleStatus = $isUpdateSaleStatus;
        }
        return $this;
    }
    /**
     * Get IsUpdateSecondaryPerformers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateSecondaryPerformers()
    {
        return isset($this->IsUpdateSecondaryPerformers) ? $this->IsUpdateSecondaryPerformers : null;
    }
    /**
     * Set IsUpdateSecondaryPerformers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateSecondaryPerformers
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateSecondaryPerformers($isUpdateSecondaryPerformers = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSecondaryPerformers) && !is_bool($isUpdateSecondaryPerformers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateSecondaryPerformers, true), gettype($isUpdateSecondaryPerformers)), __LINE__);
        }
        if (is_null($isUpdateSecondaryPerformers) || (is_array($isUpdateSecondaryPerformers) && empty($isUpdateSecondaryPerformers))) {
            unset($this->IsUpdateSecondaryPerformers);
        } else {
            $this->IsUpdateSecondaryPerformers = $isUpdateSecondaryPerformers;
        }
        return $this;
    }
    /**
     * Get IsUpdateTaxonomy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateTaxonomy()
    {
        return isset($this->IsUpdateTaxonomy) ? $this->IsUpdateTaxonomy : null;
    }
    /**
     * Set IsUpdateTaxonomy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateTaxonomy
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateTaxonomy($isUpdateTaxonomy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateTaxonomy) && !is_bool($isUpdateTaxonomy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateTaxonomy, true), gettype($isUpdateTaxonomy)), __LINE__);
        }
        if (is_null($isUpdateTaxonomy) || (is_array($isUpdateTaxonomy) && empty($isUpdateTaxonomy))) {
            unset($this->IsUpdateTaxonomy);
        } else {
            $this->IsUpdateTaxonomy = $isUpdateTaxonomy;
        }
        return $this;
    }
    /**
     * Get IsUpdateUseAccessControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateUseAccessControl()
    {
        return isset($this->IsUpdateUseAccessControl) ? $this->IsUpdateUseAccessControl : null;
    }
    /**
     * Set IsUpdateUseAccessControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateUseAccessControl
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateUseAccessControl($isUpdateUseAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateUseAccessControl) && !is_bool($isUpdateUseAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateUseAccessControl, true), gettype($isUpdateUseAccessControl)), __LINE__);
        }
        if (is_null($isUpdateUseAccessControl) || (is_array($isUpdateUseAccessControl) && empty($isUpdateUseAccessControl))) {
            unset($this->IsUpdateUseAccessControl);
        } else {
            $this->IsUpdateUseAccessControl = $isUpdateUseAccessControl;
        }
        return $this;
    }
    /**
     * Get IsUpdateVisibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateVisibility()
    {
        return isset($this->IsUpdateVisibility) ? $this->IsUpdateVisibility : null;
    }
    /**
     * Set IsUpdateVisibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateVisibility
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setIsUpdateVisibility($isUpdateVisibility = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateVisibility) && !is_bool($isUpdateVisibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateVisibility, true), gettype($isUpdateVisibility)), __LINE__);
        }
        if (is_null($isUpdateVisibility) || (is_array($isUpdateVisibility) && empty($isUpdateVisibility))) {
            unset($this->IsUpdateVisibility);
        } else {
            $this->IsUpdateVisibility = $isUpdateVisibility;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get OrganizerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizerId()
    {
        return isset($this->OrganizerId) ? $this->OrganizerId : null;
    }
    /**
     * Set OrganizerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizerId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setOrganizerId($organizerId = null)
    {
        // validation for constraint: string
        if (!is_null($organizerId) && !is_string($organizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizerId, true), gettype($organizerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizerId, true)), __LINE__);
        }
        if (is_null($organizerId) || (is_array($organizerId) && empty($organizerId))) {
            unset($this->OrganizerId);
        } else {
            $this->OrganizerId = $organizerId;
        }
        return $this;
    }
    /**
     * Get OverrideTaxonomy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOverrideTaxonomy()
    {
        return isset($this->OverrideTaxonomy) ? $this->OverrideTaxonomy : null;
    }
    /**
     * Set OverrideTaxonomy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $overrideTaxonomy
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setOverrideTaxonomy($overrideTaxonomy = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideTaxonomy) && !is_bool($overrideTaxonomy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideTaxonomy, true), gettype($overrideTaxonomy)), __LINE__);
        }
        if (is_null($overrideTaxonomy) || (is_array($overrideTaxonomy) && empty($overrideTaxonomy))) {
            unset($this->OverrideTaxonomy);
        } else {
            $this->OverrideTaxonomy = $overrideTaxonomy;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PerformerIdsToRetrieve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerIdsToRetrieve()
    {
        return isset($this->PerformerIdsToRetrieve) ? $this->PerformerIdsToRetrieve : null;
    }
    /**
     * Set PerformerIdsToRetrieve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $performerIdsToRetrieve
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setPerformerIdsToRetrieve($performerIdsToRetrieve = null)
    {
        // validation for constraint: string
        if (!is_null($performerIdsToRetrieve) && !is_string($performerIdsToRetrieve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($performerIdsToRetrieve, true), gettype($performerIdsToRetrieve)), __LINE__);
        }
        if (is_null($performerIdsToRetrieve) || (is_array($performerIdsToRetrieve) && empty($performerIdsToRetrieve))) {
            unset($this->PerformerIdsToRetrieve);
        } else {
            $this->PerformerIdsToRetrieve = $performerIdsToRetrieve;
        }
        return $this;
    }
    /**
     * Get Performers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_PerformerData|null
     */
    public function getPerformers()
    {
        return isset($this->Performers) ? $this->Performers : null;
    }
    /**
     * Set Performers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_PerformerData $performers
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setPerformers(\patest\StructType\RecordSetOfTicketing_PerformerData $performers = null)
    {
        if (is_null($performers) || (is_array($performers) && empty($performers))) {
            unset($this->Performers);
        } else {
            $this->Performers = $performers;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get PromoterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterId()
    {
        return isset($this->PromoterId) ? $this->PromoterId : null;
    }
    /**
     * Set PromoterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setPromoterId($promoterId = null)
    {
        // validation for constraint: string
        if (!is_null($promoterId) && !is_string($promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterId, true), gettype($promoterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterId, true)), __LINE__);
        }
        if (is_null($promoterId) || (is_array($promoterId) && empty($promoterId))) {
            unset($this->PromoterId);
        } else {
            $this->PromoterId = $promoterId;
        }
        return $this;
    }
    /**
     * Get PublicVisibilityEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublicVisibilityEndTime()
    {
        return isset($this->PublicVisibilityEndTime) ? $this->PublicVisibilityEndTime : null;
    }
    /**
     * Set PublicVisibilityEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publicVisibilityEndTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setPublicVisibilityEndTime($publicVisibilityEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($publicVisibilityEndTime) && !is_string($publicVisibilityEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicVisibilityEndTime, true), gettype($publicVisibilityEndTime)), __LINE__);
        }
        if (is_null($publicVisibilityEndTime) || (is_array($publicVisibilityEndTime) && empty($publicVisibilityEndTime))) {
            unset($this->PublicVisibilityEndTime);
        } else {
            $this->PublicVisibilityEndTime = $publicVisibilityEndTime;
        }
        return $this;
    }
    /**
     * Get PublicVisibilityIsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPublicVisibilityIsEnabled()
    {
        return isset($this->PublicVisibilityIsEnabled) ? $this->PublicVisibilityIsEnabled : null;
    }
    /**
     * Set PublicVisibilityIsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $publicVisibilityIsEnabled
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setPublicVisibilityIsEnabled($publicVisibilityIsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($publicVisibilityIsEnabled) && !is_bool($publicVisibilityIsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($publicVisibilityIsEnabled, true), gettype($publicVisibilityIsEnabled)), __LINE__);
        }
        if (is_null($publicVisibilityIsEnabled) || (is_array($publicVisibilityIsEnabled) && empty($publicVisibilityIsEnabled))) {
            unset($this->PublicVisibilityIsEnabled);
        } else {
            $this->PublicVisibilityIsEnabled = $publicVisibilityIsEnabled;
        }
        return $this;
    }
    /**
     * Get PublicVisibilityStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublicVisibilityStartTime()
    {
        return isset($this->PublicVisibilityStartTime) ? $this->PublicVisibilityStartTime : null;
    }
    /**
     * Set PublicVisibilityStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publicVisibilityStartTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setPublicVisibilityStartTime($publicVisibilityStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($publicVisibilityStartTime) && !is_string($publicVisibilityStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicVisibilityStartTime, true), gettype($publicVisibilityStartTime)), __LINE__);
        }
        if (is_null($publicVisibilityStartTime) || (is_array($publicVisibilityStartTime) && empty($publicVisibilityStartTime))) {
            unset($this->PublicVisibilityStartTime);
        } else {
            $this->PublicVisibilityStartTime = $publicVisibilityStartTime;
        }
        return $this;
    }
    /**
     * Get SalesTargetValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSalesTargetValue()
    {
        return isset($this->SalesTargetValue) ? $this->SalesTargetValue : null;
    }
    /**
     * Set SalesTargetValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $salesTargetValue
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setSalesTargetValue(\patest\StructType\Money $salesTargetValue = null)
    {
        if (is_null($salesTargetValue) || (is_array($salesTargetValue) && empty($salesTargetValue))) {
            unset($this->SalesTargetValue);
        } else {
            $this->SalesTargetValue = $salesTargetValue;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleStatusForArrayConstraintsFromSetSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_UpdatePropertiesOfEvents_RequestSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($bizAction_Ticketing_UpdatePropertiesOfEvents_RequestSaleStatusItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_UpdatePropertiesOfEvents_RequestSaleStatusItem) ? get_class($bizAction_Ticketing_UpdatePropertiesOfEvents_RequestSaleStatusItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_UpdatePropertiesOfEvents_RequestSaleStatusItem), var_export($bizAction_Ticketing_UpdatePropertiesOfEvents_RequestSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $saleStatus
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setSaleStatus(array $saleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($saleStatusArrayErrorMessage = self::validateSaleStatusForArrayConstraintsFromSetSaleStatus($saleStatus))) {
            throw new \InvalidArgumentException($saleStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = is_array($saleStatus) ? implode(' ', $saleStatus) : null;
        }
        return $this;
    }
    /**
     * Get StartDisplayTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDisplayTime()
    {
        return isset($this->StartDisplayTime) ? $this->StartDisplayTime : null;
    }
    /**
     * Set StartDisplayTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDisplayTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setStartDisplayTime($startDisplayTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDisplayTime) && !is_string($startDisplayTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDisplayTime, true), gettype($startDisplayTime)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($startDisplayTime) && false === mb_strpos($startDisplayTime, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $startDisplayTime)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($startDisplayTime, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($startDisplayTime) && false !== mb_strpos($startDisplayTime, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $startDisplayTime)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($startDisplayTime, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($startDisplayTime) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $startDisplayTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($startDisplayTime, true)), __LINE__);
        }
        if (is_null($startDisplayTime) || (is_array($startDisplayTime) && empty($startDisplayTime))) {
            unset($this->StartDisplayTime);
        } else {
            $this->StartDisplayTime = $startDisplayTime;
        }
        return $this;
    }
    /**
     * Get StartDisplayTimeWhen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDisplayTimeWhen()
    {
        return isset($this->StartDisplayTimeWhen) ? $this->StartDisplayTimeWhen : null;
    }
    /**
     * Set StartDisplayTimeWhen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActionDateTypes::valueIsValid()
     * @uses \patest\EnumType\ActionDateTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDisplayTimeWhen
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setStartDisplayTimeWhen($startDisplayTimeWhen = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActionDateTypes::valueIsValid($startDisplayTimeWhen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActionDateTypes', is_array($startDisplayTimeWhen) ? implode(', ', $startDisplayTimeWhen) : var_export($startDisplayTimeWhen, true), implode(', ', \patest\EnumType\ActionDateTypes::getValidValues())), __LINE__);
        }
        if (is_null($startDisplayTimeWhen) || (is_array($startDisplayTimeWhen) && empty($startDisplayTimeWhen))) {
            unset($this->StartDisplayTimeWhen);
        } else {
            $this->StartDisplayTimeWhen = $startDisplayTimeWhen;
        }
        return $this;
    }
    /**
     * Get StopDisplayTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopDisplayTime()
    {
        return isset($this->StopDisplayTime) ? $this->StopDisplayTime : null;
    }
    /**
     * Set StopDisplayTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopDisplayTime
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setStopDisplayTime($stopDisplayTime = null)
    {
        // validation for constraint: string
        if (!is_null($stopDisplayTime) && !is_string($stopDisplayTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopDisplayTime, true), gettype($stopDisplayTime)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($stopDisplayTime) && false === mb_strpos($stopDisplayTime, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $stopDisplayTime)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($stopDisplayTime, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($stopDisplayTime) && false !== mb_strpos($stopDisplayTime, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $stopDisplayTime)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($stopDisplayTime, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($stopDisplayTime) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $stopDisplayTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($stopDisplayTime, true)), __LINE__);
        }
        if (is_null($stopDisplayTime) || (is_array($stopDisplayTime) && empty($stopDisplayTime))) {
            unset($this->StopDisplayTime);
        } else {
            $this->StopDisplayTime = $stopDisplayTime;
        }
        return $this;
    }
    /**
     * Get StopDisplayTimeWhen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopDisplayTimeWhen()
    {
        return isset($this->StopDisplayTimeWhen) ? $this->StopDisplayTimeWhen : null;
    }
    /**
     * Set StopDisplayTimeWhen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActionDateTypes::valueIsValid()
     * @uses \patest\EnumType\ActionDateTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopDisplayTimeWhen
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setStopDisplayTimeWhen($stopDisplayTimeWhen = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActionDateTypes::valueIsValid($stopDisplayTimeWhen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActionDateTypes', is_array($stopDisplayTimeWhen) ? implode(', ', $stopDisplayTimeWhen) : var_export($stopDisplayTimeWhen, true), implode(', ', \patest\EnumType\ActionDateTypes::getValidValues())), __LINE__);
        }
        if (is_null($stopDisplayTimeWhen) || (is_array($stopDisplayTimeWhen) && empty($stopDisplayTimeWhen))) {
            unset($this->StopDisplayTimeWhen);
        } else {
            $this->StopDisplayTimeWhen = $stopDisplayTimeWhen;
        }
        return $this;
    }
    /**
     * Get SummaryText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummaryText()
    {
        return isset($this->SummaryText) ? $this->SummaryText : null;
    }
    /**
     * Set SummaryText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summaryText
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setSummaryText($summaryText = null)
    {
        // validation for constraint: string
        if (!is_null($summaryText) && !is_string($summaryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summaryText, true), gettype($summaryText)), __LINE__);
        }
        if (is_null($summaryText) || (is_array($summaryText) && empty($summaryText))) {
            unset($this->SummaryText);
        } else {
            $this->SummaryText = $summaryText;
        }
        return $this;
    }
    /**
     * Get TaxonomyGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyGuid()
    {
        return isset($this->TaxonomyGuid) ? $this->TaxonomyGuid : null;
    }
    /**
     * Set TaxonomyGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxonomyGuid
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setTaxonomyGuid($taxonomyGuid = null)
    {
        // validation for constraint: string
        if (!is_null($taxonomyGuid) && !is_string($taxonomyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxonomyGuid, true), gettype($taxonomyGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($taxonomyGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $taxonomyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($taxonomyGuid, true)), __LINE__);
        }
        if (is_null($taxonomyGuid) || (is_array($taxonomyGuid) && empty($taxonomyGuid))) {
            unset($this->TaxonomyGuid);
        } else {
            $this->TaxonomyGuid = $taxonomyGuid;
        }
        return $this;
    }
    /**
     * Get TaxonomyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTaxonomyId()
    {
        return isset($this->TaxonomyId) ? $this->TaxonomyId : null;
    }
    /**
     * Set TaxonomyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $taxonomyId
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setTaxonomyId($taxonomyId = null)
    {
        // validation for constraint: int
        if (!is_null($taxonomyId) && !(is_int($taxonomyId) || ctype_digit($taxonomyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxonomyId, true), gettype($taxonomyId)), __LINE__);
        }
        if (is_null($taxonomyId) || (is_array($taxonomyId) && empty($taxonomyId))) {
            unset($this->TaxonomyId);
        } else {
            $this->TaxonomyId = $taxonomyId;
        }
        return $this;
    }
    /**
     * Get TaxonomyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyName()
    {
        return isset($this->TaxonomyName) ? $this->TaxonomyName : null;
    }
    /**
     * Set TaxonomyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxonomyName
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setTaxonomyName($taxonomyName = null)
    {
        // validation for constraint: string
        if (!is_null($taxonomyName) && !is_string($taxonomyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxonomyName, true), gettype($taxonomyName)), __LINE__);
        }
        if (is_null($taxonomyName) || (is_array($taxonomyName) && empty($taxonomyName))) {
            unset($this->TaxonomyName);
        } else {
            $this->TaxonomyName = $taxonomyName;
        }
        return $this;
    }
    /**
     * Get UseAccessControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAccessControl()
    {
        return isset($this->UseAccessControl) ? $this->UseAccessControl : null;
    }
    /**
     * Set UseAccessControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAccessControl
     * @return \patest\StructType\BizAction_Ticketing_UpdatePropertiesOfEvents_Request
     */
    public function setUseAccessControl($useAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAccessControl) && !is_bool($useAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAccessControl, true), gettype($useAccessControl)), __LINE__);
        }
        if (is_null($useAccessControl) || (is_array($useAccessControl) && empty($useAccessControl))) {
            unset($this->UseAccessControl);
        } else {
            $this->UseAccessControl = $useAccessControl;
        }
        return $this;
    }
}
