<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.SetTicketSchemeFulfillmentState.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request extends AnyEntity
{
    /**
     * The FulfillmentIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FulfillmentIds
     */
    public $FulfillmentIds;
    /**
     * The IsConfirmOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmOperation;
    /**
     * The IsSubscriptionCanceled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriptionCanceled;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Remark;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TicketSchemeFulfillmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeFulfillmentId;
    /**
     * Constructor method for
     * BizAction.Ticketing.SetTicketSchemeFulfillmentState.Request
     * @uses BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request::setFulfillmentIds()
     * @uses BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request::setIsConfirmOperation()
     * @uses BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request::setIsSubscriptionCanceled()
     * @uses BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request::setRemark()
     * @uses BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request::setState()
     * @uses BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request::setTicketSchemeFulfillmentId()
     * @param \patest\StructType\FulfillmentIds $fulfillmentIds
     * @param bool $isConfirmOperation
     * @param bool $isSubscriptionCanceled
     * @param \patest\StructType\GlobalString $remark
     * @param string $state
     * @param string $ticketSchemeFulfillmentId
     */
    public function __construct(\patest\StructType\FulfillmentIds $fulfillmentIds = null, $isConfirmOperation = null, $isSubscriptionCanceled = null, \patest\StructType\GlobalString $remark = null, $state = null, $ticketSchemeFulfillmentId = null)
    {
        $this
            ->setFulfillmentIds($fulfillmentIds)
            ->setIsConfirmOperation($isConfirmOperation)
            ->setIsSubscriptionCanceled($isSubscriptionCanceled)
            ->setRemark($remark)
            ->setState($state)
            ->setTicketSchemeFulfillmentId($ticketSchemeFulfillmentId);
    }
    /**
     * Get FulfillmentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FulfillmentIds|null
     */
    public function getFulfillmentIds()
    {
        return isset($this->FulfillmentIds) ? $this->FulfillmentIds : null;
    }
    /**
     * Set FulfillmentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FulfillmentIds $fulfillmentIds
     * @return \patest\StructType\BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request
     */
    public function setFulfillmentIds(\patest\StructType\FulfillmentIds $fulfillmentIds = null)
    {
        if (is_null($fulfillmentIds) || (is_array($fulfillmentIds) && empty($fulfillmentIds))) {
            unset($this->FulfillmentIds);
        } else {
            $this->FulfillmentIds = $fulfillmentIds;
        }
        return $this;
    }
    /**
     * Get IsConfirmOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmOperation()
    {
        return isset($this->IsConfirmOperation) ? $this->IsConfirmOperation : null;
    }
    /**
     * Set IsConfirmOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmOperation
     * @return \patest\StructType\BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request
     */
    public function setIsConfirmOperation($isConfirmOperation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmOperation) && !is_bool($isConfirmOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmOperation, true), gettype($isConfirmOperation)), __LINE__);
        }
        if (is_null($isConfirmOperation) || (is_array($isConfirmOperation) && empty($isConfirmOperation))) {
            unset($this->IsConfirmOperation);
        } else {
            $this->IsConfirmOperation = $isConfirmOperation;
        }
        return $this;
    }
    /**
     * Get IsSubscriptionCanceled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriptionCanceled()
    {
        return isset($this->IsSubscriptionCanceled) ? $this->IsSubscriptionCanceled : null;
    }
    /**
     * Set IsSubscriptionCanceled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriptionCanceled
     * @return \patest\StructType\BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request
     */
    public function setIsSubscriptionCanceled($isSubscriptionCanceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriptionCanceled) && !is_bool($isSubscriptionCanceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriptionCanceled, true), gettype($isSubscriptionCanceled)), __LINE__);
        }
        if (is_null($isSubscriptionCanceled) || (is_array($isSubscriptionCanceled) && empty($isSubscriptionCanceled))) {
            unset($this->IsSubscriptionCanceled);
        } else {
            $this->IsSubscriptionCanceled = $isSubscriptionCanceled;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $remark
     * @return \patest\StructType\BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request
     */
    public function setRemark(\patest\StructType\GlobalString $remark = null)
    {
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EnrollmentFulfillmentState::valueIsValid()
     * @uses \patest\EnumType\EnrollmentFulfillmentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EnrollmentFulfillmentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EnrollmentFulfillmentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\EnrollmentFulfillmentState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TicketSchemeFulfillmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeFulfillmentId()
    {
        return isset($this->TicketSchemeFulfillmentId) ? $this->TicketSchemeFulfillmentId : null;
    }
    /**
     * Set TicketSchemeFulfillmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeFulfillmentId
     * @return \patest\StructType\BizAction_Ticketing_SetTicketSchemeFulfillmentState_Request
     */
    public function setTicketSchemeFulfillmentId($ticketSchemeFulfillmentId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeFulfillmentId) && !is_string($ticketSchemeFulfillmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeFulfillmentId, true), gettype($ticketSchemeFulfillmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeFulfillmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeFulfillmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeFulfillmentId, true)), __LINE__);
        }
        if (is_null($ticketSchemeFulfillmentId) || (is_array($ticketSchemeFulfillmentId) && empty($ticketSchemeFulfillmentId))) {
            unset($this->TicketSchemeFulfillmentId);
        } else {
            $this->TicketSchemeFulfillmentId = $ticketSchemeFulfillmentId;
        }
        return $this;
    }
}
