<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.SetEventCalcPotentialPriceList.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SetEventCalcPotentialPriceList_Request extends AnyEntity
{
    /**
     * The CalcPotentialPriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CalcPotentialPriceListId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * Constructor method for
     * BizAction.Ticketing.SetEventCalcPotentialPriceList.Request
     * @uses BizAction_Ticketing_SetEventCalcPotentialPriceList_Request::setCalcPotentialPriceListId()
     * @uses BizAction_Ticketing_SetEventCalcPotentialPriceList_Request::setEventId()
     * @param string $calcPotentialPriceListId
     * @param string $eventId
     */
    public function __construct($calcPotentialPriceListId = null, $eventId = null)
    {
        $this
            ->setCalcPotentialPriceListId($calcPotentialPriceListId)
            ->setEventId($eventId);
    }
    /**
     * Get CalcPotentialPriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalcPotentialPriceListId()
    {
        return isset($this->CalcPotentialPriceListId) ? $this->CalcPotentialPriceListId : null;
    }
    /**
     * Set CalcPotentialPriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calcPotentialPriceListId
     * @return \patest\StructType\BizAction_Ticketing_SetEventCalcPotentialPriceList_Request
     */
    public function setCalcPotentialPriceListId($calcPotentialPriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($calcPotentialPriceListId) && !is_string($calcPotentialPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcPotentialPriceListId, true), gettype($calcPotentialPriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($calcPotentialPriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $calcPotentialPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($calcPotentialPriceListId, true)), __LINE__);
        }
        if (is_null($calcPotentialPriceListId) || (is_array($calcPotentialPriceListId) && empty($calcPotentialPriceListId))) {
            unset($this->CalcPotentialPriceListId);
        } else {
            $this->CalcPotentialPriceListId = $calcPotentialPriceListId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_SetEventCalcPotentialPriceList_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
}
