<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.SearchBallotGroupApplicants.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SearchBallotGroupApplicants_Request extends AnyEntity
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The EmailOrPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailOrPhone;
    /**
     * The FilteredApplicants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_FilteredBallotGroupApplicant
     */
    public $FilteredApplicants;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The SelectedIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedIds;
    /**
     * The TextSearchOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextSearchOption;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for BizAction.Ticketing.SearchBallotGroupApplicants.Request
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setBallotId()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setCrmId()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setEmailOrPhone()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setFilteredApplicants()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setFirstName()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setGroupId()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setLastName()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setSelectedIds()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setTextSearchOption()
     * @uses BizAction_Ticketing_SearchBallotGroupApplicants_Request::setZipCode()
     * @param string $ballotId
     * @param string $crmId
     * @param string $emailOrPhone
     * @param \patest\StructType\RecordSetOfTicketing_FilteredBallotGroupApplicant $filteredApplicants
     * @param string $firstName
     * @param string $groupId
     * @param string $lastName
     * @param string $selectedIds
     * @param string $textSearchOption
     * @param string $zipCode
     */
    public function __construct($ballotId = null, $crmId = null, $emailOrPhone = null, \patest\StructType\RecordSetOfTicketing_FilteredBallotGroupApplicant $filteredApplicants = null, $firstName = null, $groupId = null, $lastName = null, $selectedIds = null, $textSearchOption = null, $zipCode = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setCrmId($crmId)
            ->setEmailOrPhone($emailOrPhone)
            ->setFilteredApplicants($filteredApplicants)
            ->setFirstName($firstName)
            ->setGroupId($groupId)
            ->setLastName($lastName)
            ->setSelectedIds($selectedIds)
            ->setTextSearchOption($textSearchOption)
            ->setZipCode($zipCode);
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get EmailOrPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailOrPhone()
    {
        return isset($this->EmailOrPhone) ? $this->EmailOrPhone : null;
    }
    /**
     * Set EmailOrPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailOrPhone
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setEmailOrPhone($emailOrPhone = null)
    {
        // validation for constraint: string
        if (!is_null($emailOrPhone) && !is_string($emailOrPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailOrPhone, true), gettype($emailOrPhone)), __LINE__);
        }
        if (is_null($emailOrPhone) || (is_array($emailOrPhone) && empty($emailOrPhone))) {
            unset($this->EmailOrPhone);
        } else {
            $this->EmailOrPhone = $emailOrPhone;
        }
        return $this;
    }
    /**
     * Get FilteredApplicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_FilteredBallotGroupApplicant|null
     */
    public function getFilteredApplicants()
    {
        return isset($this->FilteredApplicants) ? $this->FilteredApplicants : null;
    }
    /**
     * Set FilteredApplicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_FilteredBallotGroupApplicant $filteredApplicants
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setFilteredApplicants(\patest\StructType\RecordSetOfTicketing_FilteredBallotGroupApplicant $filteredApplicants = null)
    {
        if (is_null($filteredApplicants) || (is_array($filteredApplicants) && empty($filteredApplicants))) {
            unset($this->FilteredApplicants);
        } else {
            $this->FilteredApplicants = $filteredApplicants;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get SelectedIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedIds()
    {
        return isset($this->SelectedIds) ? $this->SelectedIds : null;
    }
    /**
     * Set SelectedIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedIds
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setSelectedIds($selectedIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedIds) && !is_string($selectedIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedIds, true), gettype($selectedIds)), __LINE__);
        }
        if (is_null($selectedIds) || (is_array($selectedIds) && empty($selectedIds))) {
            unset($this->SelectedIds);
        } else {
            $this->SelectedIds = $selectedIds;
        }
        return $this;
    }
    /**
     * Get TextSearchOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextSearchOption()
    {
        return isset($this->TextSearchOption) ? $this->TextSearchOption : null;
    }
    /**
     * Set TextSearchOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LastnameFilterOperator::valueIsValid()
     * @uses \patest\EnumType\LastnameFilterOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $textSearchOption
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setTextSearchOption($textSearchOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LastnameFilterOperator::valueIsValid($textSearchOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LastnameFilterOperator', is_array($textSearchOption) ? implode(', ', $textSearchOption) : var_export($textSearchOption, true), implode(', ', \patest\EnumType\LastnameFilterOperator::getValidValues())), __LINE__);
        }
        if (is_null($textSearchOption) || (is_array($textSearchOption) && empty($textSearchOption))) {
            unset($this->TextSearchOption);
        } else {
            $this->TextSearchOption = $textSearchOption;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \patest\StructType\BizAction_Ticketing_SearchBallotGroupApplicants_Request
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
}
