<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.ProcessBallotEventFilterApplicantsParameters.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request extends AnyEntity
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The ClientTypesFilterMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypesFilterMode;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_FilterEventForBallot
     */
    public $Events;
    /**
     * The IncludeWinnersInOtherEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeWinnersInOtherEvents;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The MinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeats;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The SelectedBallotEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedBallotEventIds;
    /**
     * The SelectedClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedClientTypeIds;
    /**
     * Constructor method for
     * BizAction.Ticketing.ProcessBallotEventFilterApplicantsParameters.Request
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setBallotId()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setClientTypeIds()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setClientTypesFilterMode()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setEvents()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setIncludeWinnersInOtherEvents()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setMaxSeats()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setMinSeats()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setSectionId()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setSelectedBallotEventIds()
     * @uses BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request::setSelectedClientTypeIds()
     * @param string $ballotId
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param string $clientTypesFilterMode
     * @param \patest\StructType\RecordSetOfTicketing_FilterEventForBallot $events
     * @param string $includeWinnersInOtherEvents
     * @param int $maxSeats
     * @param int $minSeats
     * @param string $sectionId
     * @param string $selectedBallotEventIds
     * @param string $selectedClientTypeIds
     */
    public function __construct($ballotId = null, \patest\StructType\ClientTypeIds $clientTypeIds = null, $clientTypesFilterMode = null, \patest\StructType\RecordSetOfTicketing_FilterEventForBallot $events = null, $includeWinnersInOtherEvents = null, $maxSeats = null, $minSeats = null, $sectionId = null, $selectedBallotEventIds = null, $selectedClientTypeIds = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setClientTypeIds($clientTypeIds)
            ->setClientTypesFilterMode($clientTypesFilterMode)
            ->setEvents($events)
            ->setIncludeWinnersInOtherEvents($includeWinnersInOtherEvents)
            ->setMaxSeats($maxSeats)
            ->setMinSeats($minSeats)
            ->setSectionId($sectionId)
            ->setSelectedBallotEventIds($selectedBallotEventIds)
            ->setSelectedClientTypeIds($selectedClientTypeIds);
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get ClientTypesFilterMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypesFilterMode()
    {
        return isset($this->ClientTypesFilterMode) ? $this->ClientTypesFilterMode : null;
    }
    /**
     * Set ClientTypesFilterMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientTypesFilterMode::valueIsValid()
     * @uses \patest\EnumType\ClientTypesFilterMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientTypesFilterMode
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setClientTypesFilterMode($clientTypesFilterMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientTypesFilterMode::valueIsValid($clientTypesFilterMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientTypesFilterMode', is_array($clientTypesFilterMode) ? implode(', ', $clientTypesFilterMode) : var_export($clientTypesFilterMode, true), implode(', ', \patest\EnumType\ClientTypesFilterMode::getValidValues())), __LINE__);
        }
        if (is_null($clientTypesFilterMode) || (is_array($clientTypesFilterMode) && empty($clientTypesFilterMode))) {
            unset($this->ClientTypesFilterMode);
        } else {
            $this->ClientTypesFilterMode = $clientTypesFilterMode;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_FilterEventForBallot|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_FilterEventForBallot $events
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setEvents(\patest\StructType\RecordSetOfTicketing_FilterEventForBallot $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get IncludeWinnersInOtherEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeWinnersInOtherEvents()
    {
        return isset($this->IncludeWinnersInOtherEvents) ? $this->IncludeWinnersInOtherEvents : null;
    }
    /**
     * Set IncludeWinnersInOtherEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\IncludeWinnersInOtherEventsEnum::valueIsValid()
     * @uses \patest\EnumType\IncludeWinnersInOtherEventsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeWinnersInOtherEvents
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setIncludeWinnersInOtherEvents($includeWinnersInOtherEvents = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\IncludeWinnersInOtherEventsEnum::valueIsValid($includeWinnersInOtherEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\IncludeWinnersInOtherEventsEnum', is_array($includeWinnersInOtherEvents) ? implode(', ', $includeWinnersInOtherEvents) : var_export($includeWinnersInOtherEvents, true), implode(', ', \patest\EnumType\IncludeWinnersInOtherEventsEnum::getValidValues())), __LINE__);
        }
        if (is_null($includeWinnersInOtherEvents) || (is_array($includeWinnersInOtherEvents) && empty($includeWinnersInOtherEvents))) {
            unset($this->IncludeWinnersInOtherEvents);
        } else {
            $this->IncludeWinnersInOtherEvents = $includeWinnersInOtherEvents;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get MinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeats()
    {
        return isset($this->MinSeats) ? $this->MinSeats : null;
    }
    /**
     * Set MinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setMinSeats($minSeats = null)
    {
        // validation for constraint: int
        if (!is_null($minSeats) && !(is_int($minSeats) || ctype_digit($minSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeats, true), gettype($minSeats)), __LINE__);
        }
        if (is_null($minSeats) || (is_array($minSeats) && empty($minSeats))) {
            unset($this->MinSeats);
        } else {
            $this->MinSeats = $minSeats;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get SelectedBallotEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedBallotEventIds()
    {
        return isset($this->SelectedBallotEventIds) ? $this->SelectedBallotEventIds : null;
    }
    /**
     * Set SelectedBallotEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedBallotEventIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setSelectedBallotEventIds($selectedBallotEventIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedBallotEventIds) && !is_string($selectedBallotEventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedBallotEventIds, true), gettype($selectedBallotEventIds)), __LINE__);
        }
        if (is_null($selectedBallotEventIds) || (is_array($selectedBallotEventIds) && empty($selectedBallotEventIds))) {
            unset($this->SelectedBallotEventIds);
        } else {
            $this->SelectedBallotEventIds = $selectedBallotEventIds;
        }
        return $this;
    }
    /**
     * Get SelectedClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedClientTypeIds()
    {
        return isset($this->SelectedClientTypeIds) ? $this->SelectedClientTypeIds : null;
    }
    /**
     * Set SelectedClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedClientTypeIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessBallotEventFilterApplicantsParameters_Request
     */
    public function setSelectedClientTypeIds($selectedClientTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedClientTypeIds) && !is_string($selectedClientTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedClientTypeIds, true), gettype($selectedClientTypeIds)), __LINE__);
        }
        if (is_null($selectedClientTypeIds) || (is_array($selectedClientTypeIds) && empty($selectedClientTypeIds))) {
            unset($this->SelectedClientTypeIds);
        } else {
            $this->SelectedClientTypeIds = $selectedClientTypeIds;
        }
        return $this;
    }
}
