<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ImportHallVersion.AreaMapping
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ImportHallVersion_AreaMapping extends AnyEntity
{
    /**
     * The Capacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Capacity;
    /**
     * The GAMaxCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GAMaxCapacity;
    /**
     * The IdInDataFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInDataFile;
    /**
     * The OriginalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OriginalName;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingType;
    /**
     * The TargetAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetAreaId;
    /**
     * Constructor method for BizAction.Ticketing.ImportHallVersion.AreaMapping
     * @uses BizAction_Ticketing_ImportHallVersion_AreaMapping::setCapacity()
     * @uses BizAction_Ticketing_ImportHallVersion_AreaMapping::setGAMaxCapacity()
     * @uses BizAction_Ticketing_ImportHallVersion_AreaMapping::setIdInDataFile()
     * @uses BizAction_Ticketing_ImportHallVersion_AreaMapping::setOriginalName()
     * @uses BizAction_Ticketing_ImportHallVersion_AreaMapping::setSeatingType()
     * @uses BizAction_Ticketing_ImportHallVersion_AreaMapping::setTargetAreaId()
     * @param int $capacity
     * @param int $gAMaxCapacity
     * @param int $idInDataFile
     * @param \patest\StructType\GlobalString $originalName
     * @param string $seatingType
     * @param string $targetAreaId
     */
    public function __construct($capacity = null, $gAMaxCapacity = null, $idInDataFile = null, \patest\StructType\GlobalString $originalName = null, $seatingType = null, $targetAreaId = null)
    {
        $this
            ->setCapacity($capacity)
            ->setGAMaxCapacity($gAMaxCapacity)
            ->setIdInDataFile($idInDataFile)
            ->setOriginalName($originalName)
            ->setSeatingType($seatingType)
            ->setTargetAreaId($targetAreaId);
    }
    /**
     * Get Capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCapacity()
    {
        return isset($this->Capacity) ? $this->Capacity : null;
    }
    /**
     * Set Capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $capacity
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        if (is_null($capacity) || (is_array($capacity) && empty($capacity))) {
            unset($this->Capacity);
        } else {
            $this->Capacity = $capacity;
        }
        return $this;
    }
    /**
     * Get GAMaxCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGAMaxCapacity()
    {
        return isset($this->GAMaxCapacity) ? $this->GAMaxCapacity : null;
    }
    /**
     * Set GAMaxCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gAMaxCapacity
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public function setGAMaxCapacity($gAMaxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($gAMaxCapacity) && !(is_int($gAMaxCapacity) || ctype_digit($gAMaxCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gAMaxCapacity, true), gettype($gAMaxCapacity)), __LINE__);
        }
        if (is_null($gAMaxCapacity) || (is_array($gAMaxCapacity) && empty($gAMaxCapacity))) {
            unset($this->GAMaxCapacity);
        } else {
            $this->GAMaxCapacity = $gAMaxCapacity;
        }
        return $this;
    }
    /**
     * Get IdInDataFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInDataFile()
    {
        return isset($this->IdInDataFile) ? $this->IdInDataFile : null;
    }
    /**
     * Set IdInDataFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInDataFile
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public function setIdInDataFile($idInDataFile = null)
    {
        // validation for constraint: int
        if (!is_null($idInDataFile) && !(is_int($idInDataFile) || ctype_digit($idInDataFile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInDataFile, true), gettype($idInDataFile)), __LINE__);
        }
        if (is_null($idInDataFile) || (is_array($idInDataFile) && empty($idInDataFile))) {
            unset($this->IdInDataFile);
        } else {
            $this->IdInDataFile = $idInDataFile;
        }
        return $this;
    }
    /**
     * Get OriginalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOriginalName()
    {
        return isset($this->OriginalName) ? $this->OriginalName : null;
    }
    /**
     * Set OriginalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $originalName
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public function setOriginalName(\patest\StructType\GlobalString $originalName = null)
    {
        if (is_null($originalName) || (is_array($originalName) && empty($originalName))) {
            unset($this->OriginalName);
        } else {
            $this->OriginalName = $originalName;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingType()
    {
        return isset($this->SeatingType) ? $this->SeatingType : null;
    }
    /**
     * Set SeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($seatingType) || (is_array($seatingType) && empty($seatingType))) {
            unset($this->SeatingType);
        } else {
            $this->SeatingType = $seatingType;
        }
        return $this;
    }
    /**
     * Get TargetAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAreaId()
    {
        return isset($this->TargetAreaId) ? $this->TargetAreaId : null;
    }
    /**
     * Set TargetAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAreaId
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public function setTargetAreaId($targetAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($targetAreaId) && !is_string($targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAreaId, true), gettype($targetAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetAreaId, true)), __LINE__);
        }
        if (is_null($targetAreaId) || (is_array($targetAreaId) && empty($targetAreaId))) {
            unset($this->TargetAreaId);
        } else {
            $this->TargetAreaId = $targetAreaId;
        }
        return $this;
    }
}
