<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.EditBallotApplication.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_EditBallotApplication_Request extends AnyEntity
{
    /**
     * The BallotEventMaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BallotEventMaxPrice;
    /**
     * The BallotEventMinPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BallotEventMinPrice;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The BallotMinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotMinSeats;
    /**
     * The BallotNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotNumber;
    /**
     * The BallotRunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotRunMode;
    /**
     * The BallotVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotVersion;
    /**
     * The ClearSectionAndGroupedSectionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ClearSectionAndGroupedSectionIds;
    /**
     * The ClientApplication
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_BallotClientApplication
     */
    public $ClientApplication;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CloseOnSuccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CloseOnSuccess;
    /**
     * The CollectCCData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CollectCCData;
    /**
     * The ConsiderOtherSections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ConsiderOtherSections;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The DoesAssignRelatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoesAssignRelatedClients;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The HasWarning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasWarning;
    /**
     * The IgnoreQtyValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IgnoreQtyValidation;
    /**
     * The IsClientValidToApply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClientValidToApply;
    /**
     * The IsPaymentConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPaymentConfirmed;
    /**
     * The MaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MaxPrice;
    /**
     * The MinPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MinPrice;
    /**
     * The OwnerAssignmentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerAssignmentData;
    /**
     * The PaymentMethodDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodDetails;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PreviousOwnerAssignmentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviousOwnerAssignmentData;
    /**
     * The ScaledModeExposedToFans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScaledModeExposedToFans;
    /**
     * The SendEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendEmail;
    /**
     * The ValidationErrorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationErrorText;
    /**
     * The WarningMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarningMessage;
    /**
     * Constructor method for BizAction.Ticketing.EditBallotApplication.Request
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotEventMaxPrice()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotEventMinPrice()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotId()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotMinSeats()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotNumber()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotRunMode()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setBallotVersion()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setClearSectionAndGroupedSectionIds()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setClientApplication()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setClientId()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setCloseOnSuccess()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setCollectCCData()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setConsiderOtherSections()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setCrmId()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setDoesAssignRelatedClients()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setEventId()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setHasWarning()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setIgnoreQtyValidation()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setIsClientValidToApply()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setIsPaymentConfirmed()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setMaxPrice()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setMinPrice()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setOwnerAssignmentData()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setPaymentMethodDetails()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setPaymentMethodId()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setPreviousOwnerAssignmentData()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setScaledModeExposedToFans()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setSendEmail()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setValidationErrorText()
     * @uses BizAction_Ticketing_EditBallotApplication_Request::setWarningMessage()
     * @param float $ballotEventMaxPrice
     * @param float $ballotEventMinPrice
     * @param string $ballotId
     * @param int $ballotMinSeats
     * @param int $ballotNumber
     * @param string $ballotRunMode
     * @param string $ballotVersion
     * @param bool $clearSectionAndGroupedSectionIds
     * @param \patest\StructType\Ticketing_BallotClientApplication $clientApplication
     * @param string $clientId
     * @param bool $closeOnSuccess
     * @param bool $collectCCData
     * @param bool $considerOtherSections
     * @param string $crmId
     * @param bool $doesAssignRelatedClients
     * @param string $eventId
     * @param bool $hasWarning
     * @param bool $ignoreQtyValidation
     * @param bool $isClientValidToApply
     * @param bool $isPaymentConfirmed
     * @param \patest\StructType\Money $maxPrice
     * @param \patest\StructType\Money $minPrice
     * @param string $ownerAssignmentData
     * @param string $paymentMethodDetails
     * @param string $paymentMethodId
     * @param string $previousOwnerAssignmentData
     * @param bool $scaledModeExposedToFans
     * @param bool $sendEmail
     * @param string $validationErrorText
     * @param string $warningMessage
     */
    public function __construct($ballotEventMaxPrice = null, $ballotEventMinPrice = null, $ballotId = null, $ballotMinSeats = null, $ballotNumber = null, $ballotRunMode = null, $ballotVersion = null, $clearSectionAndGroupedSectionIds = null, \patest\StructType\Ticketing_BallotClientApplication $clientApplication = null, $clientId = null, $closeOnSuccess = null, $collectCCData = null, $considerOtherSections = null, $crmId = null, $doesAssignRelatedClients = null, $eventId = null, $hasWarning = null, $ignoreQtyValidation = null, $isClientValidToApply = null, $isPaymentConfirmed = null, \patest\StructType\Money $maxPrice = null, \patest\StructType\Money $minPrice = null, $ownerAssignmentData = null, $paymentMethodDetails = null, $paymentMethodId = null, $previousOwnerAssignmentData = null, $scaledModeExposedToFans = null, $sendEmail = null, $validationErrorText = null, $warningMessage = null)
    {
        $this
            ->setBallotEventMaxPrice($ballotEventMaxPrice)
            ->setBallotEventMinPrice($ballotEventMinPrice)
            ->setBallotId($ballotId)
            ->setBallotMinSeats($ballotMinSeats)
            ->setBallotNumber($ballotNumber)
            ->setBallotRunMode($ballotRunMode)
            ->setBallotVersion($ballotVersion)
            ->setClearSectionAndGroupedSectionIds($clearSectionAndGroupedSectionIds)
            ->setClientApplication($clientApplication)
            ->setClientId($clientId)
            ->setCloseOnSuccess($closeOnSuccess)
            ->setCollectCCData($collectCCData)
            ->setConsiderOtherSections($considerOtherSections)
            ->setCrmId($crmId)
            ->setDoesAssignRelatedClients($doesAssignRelatedClients)
            ->setEventId($eventId)
            ->setHasWarning($hasWarning)
            ->setIgnoreQtyValidation($ignoreQtyValidation)
            ->setIsClientValidToApply($isClientValidToApply)
            ->setIsPaymentConfirmed($isPaymentConfirmed)
            ->setMaxPrice($maxPrice)
            ->setMinPrice($minPrice)
            ->setOwnerAssignmentData($ownerAssignmentData)
            ->setPaymentMethodDetails($paymentMethodDetails)
            ->setPaymentMethodId($paymentMethodId)
            ->setPreviousOwnerAssignmentData($previousOwnerAssignmentData)
            ->setScaledModeExposedToFans($scaledModeExposedToFans)
            ->setSendEmail($sendEmail)
            ->setValidationErrorText($validationErrorText)
            ->setWarningMessage($warningMessage);
    }
    /**
     * Get BallotEventMaxPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBallotEventMaxPrice()
    {
        return isset($this->BallotEventMaxPrice) ? $this->BallotEventMaxPrice : null;
    }
    /**
     * Set BallotEventMaxPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ballotEventMaxPrice
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotEventMaxPrice($ballotEventMaxPrice = null)
    {
        // validation for constraint: float
        if (!is_null($ballotEventMaxPrice) && !(is_float($ballotEventMaxPrice) || is_numeric($ballotEventMaxPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ballotEventMaxPrice, true), gettype($ballotEventMaxPrice)), __LINE__);
        }
        if (is_null($ballotEventMaxPrice) || (is_array($ballotEventMaxPrice) && empty($ballotEventMaxPrice))) {
            unset($this->BallotEventMaxPrice);
        } else {
            $this->BallotEventMaxPrice = $ballotEventMaxPrice;
        }
        return $this;
    }
    /**
     * Get BallotEventMinPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBallotEventMinPrice()
    {
        return isset($this->BallotEventMinPrice) ? $this->BallotEventMinPrice : null;
    }
    /**
     * Set BallotEventMinPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ballotEventMinPrice
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotEventMinPrice($ballotEventMinPrice = null)
    {
        // validation for constraint: float
        if (!is_null($ballotEventMinPrice) && !(is_float($ballotEventMinPrice) || is_numeric($ballotEventMinPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ballotEventMinPrice, true), gettype($ballotEventMinPrice)), __LINE__);
        }
        if (is_null($ballotEventMinPrice) || (is_array($ballotEventMinPrice) && empty($ballotEventMinPrice))) {
            unset($this->BallotEventMinPrice);
        } else {
            $this->BallotEventMinPrice = $ballotEventMinPrice;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get BallotMinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotMinSeats()
    {
        return isset($this->BallotMinSeats) ? $this->BallotMinSeats : null;
    }
    /**
     * Set BallotMinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotMinSeats
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotMinSeats($ballotMinSeats = null)
    {
        // validation for constraint: int
        if (!is_null($ballotMinSeats) && !(is_int($ballotMinSeats) || ctype_digit($ballotMinSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotMinSeats, true), gettype($ballotMinSeats)), __LINE__);
        }
        if (is_null($ballotMinSeats) || (is_array($ballotMinSeats) && empty($ballotMinSeats))) {
            unset($this->BallotMinSeats);
        } else {
            $this->BallotMinSeats = $ballotMinSeats;
        }
        return $this;
    }
    /**
     * Get BallotNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotNumber()
    {
        return isset($this->BallotNumber) ? $this->BallotNumber : null;
    }
    /**
     * Set BallotNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotNumber
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotNumber($ballotNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ballotNumber) && !(is_int($ballotNumber) || ctype_digit($ballotNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotNumber, true), gettype($ballotNumber)), __LINE__);
        }
        if (is_null($ballotNumber) || (is_array($ballotNumber) && empty($ballotNumber))) {
            unset($this->BallotNumber);
        } else {
            $this->BallotNumber = $ballotNumber;
        }
        return $this;
    }
    /**
     * Get BallotRunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotRunMode()
    {
        return isset($this->BallotRunMode) ? $this->BallotRunMode : null;
    }
    /**
     * Set BallotRunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotRunMode::valueIsValid()
     * @uses \patest\EnumType\BallotRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotRunMode
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotRunMode($ballotRunMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotRunMode::valueIsValid($ballotRunMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotRunMode', is_array($ballotRunMode) ? implode(', ', $ballotRunMode) : var_export($ballotRunMode, true), implode(', ', \patest\EnumType\BallotRunMode::getValidValues())), __LINE__);
        }
        if (is_null($ballotRunMode) || (is_array($ballotRunMode) && empty($ballotRunMode))) {
            unset($this->BallotRunMode);
        } else {
            $this->BallotRunMode = $ballotRunMode;
        }
        return $this;
    }
    /**
     * Get BallotVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotVersion()
    {
        return isset($this->BallotVersion) ? $this->BallotVersion : null;
    }
    /**
     * Set BallotVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotVersion::valueIsValid()
     * @uses \patest\EnumType\BallotVersion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotVersion
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setBallotVersion($ballotVersion = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotVersion::valueIsValid($ballotVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotVersion', is_array($ballotVersion) ? implode(', ', $ballotVersion) : var_export($ballotVersion, true), implode(', ', \patest\EnumType\BallotVersion::getValidValues())), __LINE__);
        }
        if (is_null($ballotVersion) || (is_array($ballotVersion) && empty($ballotVersion))) {
            unset($this->BallotVersion);
        } else {
            $this->BallotVersion = $ballotVersion;
        }
        return $this;
    }
    /**
     * Get ClearSectionAndGroupedSectionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClearSectionAndGroupedSectionIds()
    {
        return isset($this->ClearSectionAndGroupedSectionIds) ? $this->ClearSectionAndGroupedSectionIds : null;
    }
    /**
     * Set ClearSectionAndGroupedSectionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $clearSectionAndGroupedSectionIds
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setClearSectionAndGroupedSectionIds($clearSectionAndGroupedSectionIds = null)
    {
        // validation for constraint: boolean
        if (!is_null($clearSectionAndGroupedSectionIds) && !is_bool($clearSectionAndGroupedSectionIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clearSectionAndGroupedSectionIds, true), gettype($clearSectionAndGroupedSectionIds)), __LINE__);
        }
        if (is_null($clearSectionAndGroupedSectionIds) || (is_array($clearSectionAndGroupedSectionIds) && empty($clearSectionAndGroupedSectionIds))) {
            unset($this->ClearSectionAndGroupedSectionIds);
        } else {
            $this->ClearSectionAndGroupedSectionIds = $clearSectionAndGroupedSectionIds;
        }
        return $this;
    }
    /**
     * Get ClientApplication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_BallotClientApplication|null
     */
    public function getClientApplication()
    {
        return isset($this->ClientApplication) ? $this->ClientApplication : null;
    }
    /**
     * Set ClientApplication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_BallotClientApplication $clientApplication
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setClientApplication(\patest\StructType\Ticketing_BallotClientApplication $clientApplication = null)
    {
        if (is_null($clientApplication) || (is_array($clientApplication) && empty($clientApplication))) {
            unset($this->ClientApplication);
        } else {
            $this->ClientApplication = $clientApplication;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CloseOnSuccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCloseOnSuccess()
    {
        return isset($this->CloseOnSuccess) ? $this->CloseOnSuccess : null;
    }
    /**
     * Set CloseOnSuccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $closeOnSuccess
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setCloseOnSuccess($closeOnSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($closeOnSuccess) && !is_bool($closeOnSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closeOnSuccess, true), gettype($closeOnSuccess)), __LINE__);
        }
        if (is_null($closeOnSuccess) || (is_array($closeOnSuccess) && empty($closeOnSuccess))) {
            unset($this->CloseOnSuccess);
        } else {
            $this->CloseOnSuccess = $closeOnSuccess;
        }
        return $this;
    }
    /**
     * Get CollectCCData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCollectCCData()
    {
        return isset($this->CollectCCData) ? $this->CollectCCData : null;
    }
    /**
     * Set CollectCCData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $collectCCData
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setCollectCCData($collectCCData = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectCCData) && !is_bool($collectCCData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collectCCData, true), gettype($collectCCData)), __LINE__);
        }
        if (is_null($collectCCData) || (is_array($collectCCData) && empty($collectCCData))) {
            unset($this->CollectCCData);
        } else {
            $this->CollectCCData = $collectCCData;
        }
        return $this;
    }
    /**
     * Get ConsiderOtherSections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getConsiderOtherSections()
    {
        return isset($this->ConsiderOtherSections) ? $this->ConsiderOtherSections : null;
    }
    /**
     * Set ConsiderOtherSections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $considerOtherSections
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setConsiderOtherSections($considerOtherSections = null)
    {
        // validation for constraint: boolean
        if (!is_null($considerOtherSections) && !is_bool($considerOtherSections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($considerOtherSections, true), gettype($considerOtherSections)), __LINE__);
        }
        if (is_null($considerOtherSections) || (is_array($considerOtherSections) && empty($considerOtherSections))) {
            unset($this->ConsiderOtherSections);
        } else {
            $this->ConsiderOtherSections = $considerOtherSections;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get DoesAssignRelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoesAssignRelatedClients()
    {
        return isset($this->DoesAssignRelatedClients) ? $this->DoesAssignRelatedClients : null;
    }
    /**
     * Set DoesAssignRelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doesAssignRelatedClients
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setDoesAssignRelatedClients($doesAssignRelatedClients = null)
    {
        // validation for constraint: boolean
        if (!is_null($doesAssignRelatedClients) && !is_bool($doesAssignRelatedClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doesAssignRelatedClients, true), gettype($doesAssignRelatedClients)), __LINE__);
        }
        if (is_null($doesAssignRelatedClients) || (is_array($doesAssignRelatedClients) && empty($doesAssignRelatedClients))) {
            unset($this->DoesAssignRelatedClients);
        } else {
            $this->DoesAssignRelatedClients = $doesAssignRelatedClients;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get HasWarning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasWarning()
    {
        return isset($this->HasWarning) ? $this->HasWarning : null;
    }
    /**
     * Set HasWarning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasWarning
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setHasWarning($hasWarning = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasWarning) && !is_bool($hasWarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasWarning, true), gettype($hasWarning)), __LINE__);
        }
        if (is_null($hasWarning) || (is_array($hasWarning) && empty($hasWarning))) {
            unset($this->HasWarning);
        } else {
            $this->HasWarning = $hasWarning;
        }
        return $this;
    }
    /**
     * Get IgnoreQtyValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIgnoreQtyValidation()
    {
        return isset($this->IgnoreQtyValidation) ? $this->IgnoreQtyValidation : null;
    }
    /**
     * Set IgnoreQtyValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ignoreQtyValidation
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setIgnoreQtyValidation($ignoreQtyValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreQtyValidation) && !is_bool($ignoreQtyValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreQtyValidation, true), gettype($ignoreQtyValidation)), __LINE__);
        }
        if (is_null($ignoreQtyValidation) || (is_array($ignoreQtyValidation) && empty($ignoreQtyValidation))) {
            unset($this->IgnoreQtyValidation);
        } else {
            $this->IgnoreQtyValidation = $ignoreQtyValidation;
        }
        return $this;
    }
    /**
     * Get IsClientValidToApply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClientValidToApply()
    {
        return isset($this->IsClientValidToApply) ? $this->IsClientValidToApply : null;
    }
    /**
     * Set IsClientValidToApply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClientValidToApply
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setIsClientValidToApply($isClientValidToApply = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClientValidToApply) && !is_bool($isClientValidToApply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClientValidToApply, true), gettype($isClientValidToApply)), __LINE__);
        }
        if (is_null($isClientValidToApply) || (is_array($isClientValidToApply) && empty($isClientValidToApply))) {
            unset($this->IsClientValidToApply);
        } else {
            $this->IsClientValidToApply = $isClientValidToApply;
        }
        return $this;
    }
    /**
     * Get IsPaymentConfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPaymentConfirmed()
    {
        return isset($this->IsPaymentConfirmed) ? $this->IsPaymentConfirmed : null;
    }
    /**
     * Set IsPaymentConfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPaymentConfirmed
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setIsPaymentConfirmed($isPaymentConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentConfirmed) && !is_bool($isPaymentConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaymentConfirmed, true), gettype($isPaymentConfirmed)), __LINE__);
        }
        if (is_null($isPaymentConfirmed) || (is_array($isPaymentConfirmed) && empty($isPaymentConfirmed))) {
            unset($this->IsPaymentConfirmed);
        } else {
            $this->IsPaymentConfirmed = $isPaymentConfirmed;
        }
        return $this;
    }
    /**
     * Get MaxPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMaxPrice()
    {
        return isset($this->MaxPrice) ? $this->MaxPrice : null;
    }
    /**
     * Set MaxPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $maxPrice
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setMaxPrice(\patest\StructType\Money $maxPrice = null)
    {
        if (is_null($maxPrice) || (is_array($maxPrice) && empty($maxPrice))) {
            unset($this->MaxPrice);
        } else {
            $this->MaxPrice = $maxPrice;
        }
        return $this;
    }
    /**
     * Get MinPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMinPrice()
    {
        return isset($this->MinPrice) ? $this->MinPrice : null;
    }
    /**
     * Set MinPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $minPrice
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setMinPrice(\patest\StructType\Money $minPrice = null)
    {
        if (is_null($minPrice) || (is_array($minPrice) && empty($minPrice))) {
            unset($this->MinPrice);
        } else {
            $this->MinPrice = $minPrice;
        }
        return $this;
    }
    /**
     * Get OwnerAssignmentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerAssignmentData()
    {
        return isset($this->OwnerAssignmentData) ? $this->OwnerAssignmentData : null;
    }
    /**
     * Set OwnerAssignmentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerAssignmentData
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setOwnerAssignmentData($ownerAssignmentData = null)
    {
        // validation for constraint: string
        if (!is_null($ownerAssignmentData) && !is_string($ownerAssignmentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerAssignmentData, true), gettype($ownerAssignmentData)), __LINE__);
        }
        if (is_null($ownerAssignmentData) || (is_array($ownerAssignmentData) && empty($ownerAssignmentData))) {
            unset($this->OwnerAssignmentData);
        } else {
            $this->OwnerAssignmentData = $ownerAssignmentData;
        }
        return $this;
    }
    /**
     * Get PaymentMethodDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodDetails()
    {
        return isset($this->PaymentMethodDetails) ? $this->PaymentMethodDetails : null;
    }
    /**
     * Set PaymentMethodDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodDetails
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setPaymentMethodDetails($paymentMethodDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodDetails) && !is_string($paymentMethodDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodDetails, true), gettype($paymentMethodDetails)), __LINE__);
        }
        if (is_null($paymentMethodDetails) || (is_array($paymentMethodDetails) && empty($paymentMethodDetails))) {
            unset($this->PaymentMethodDetails);
        } else {
            $this->PaymentMethodDetails = $paymentMethodDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PreviousOwnerAssignmentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousOwnerAssignmentData()
    {
        return isset($this->PreviousOwnerAssignmentData) ? $this->PreviousOwnerAssignmentData : null;
    }
    /**
     * Set PreviousOwnerAssignmentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousOwnerAssignmentData
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setPreviousOwnerAssignmentData($previousOwnerAssignmentData = null)
    {
        // validation for constraint: string
        if (!is_null($previousOwnerAssignmentData) && !is_string($previousOwnerAssignmentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousOwnerAssignmentData, true), gettype($previousOwnerAssignmentData)), __LINE__);
        }
        if (is_null($previousOwnerAssignmentData) || (is_array($previousOwnerAssignmentData) && empty($previousOwnerAssignmentData))) {
            unset($this->PreviousOwnerAssignmentData);
        } else {
            $this->PreviousOwnerAssignmentData = $previousOwnerAssignmentData;
        }
        return $this;
    }
    /**
     * Get ScaledModeExposedToFans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScaledModeExposedToFans()
    {
        return isset($this->ScaledModeExposedToFans) ? $this->ScaledModeExposedToFans : null;
    }
    /**
     * Set ScaledModeExposedToFans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scaledModeExposedToFans
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setScaledModeExposedToFans($scaledModeExposedToFans = null)
    {
        // validation for constraint: boolean
        if (!is_null($scaledModeExposedToFans) && !is_bool($scaledModeExposedToFans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scaledModeExposedToFans, true), gettype($scaledModeExposedToFans)), __LINE__);
        }
        if (is_null($scaledModeExposedToFans) || (is_array($scaledModeExposedToFans) && empty($scaledModeExposedToFans))) {
            unset($this->ScaledModeExposedToFans);
        } else {
            $this->ScaledModeExposedToFans = $scaledModeExposedToFans;
        }
        return $this;
    }
    /**
     * Get SendEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendEmail()
    {
        return isset($this->SendEmail) ? $this->SendEmail : null;
    }
    /**
     * Set SendEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendEmail
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        if (is_null($sendEmail) || (is_array($sendEmail) && empty($sendEmail))) {
            unset($this->SendEmail);
        } else {
            $this->SendEmail = $sendEmail;
        }
        return $this;
    }
    /**
     * Get ValidationErrorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationErrorText()
    {
        return isset($this->ValidationErrorText) ? $this->ValidationErrorText : null;
    }
    /**
     * Set ValidationErrorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationErrorText
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setValidationErrorText($validationErrorText = null)
    {
        // validation for constraint: string
        if (!is_null($validationErrorText) && !is_string($validationErrorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationErrorText, true), gettype($validationErrorText)), __LINE__);
        }
        if (is_null($validationErrorText) || (is_array($validationErrorText) && empty($validationErrorText))) {
            unset($this->ValidationErrorText);
        } else {
            $this->ValidationErrorText = $validationErrorText;
        }
        return $this;
    }
    /**
     * Get WarningMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarningMessage()
    {
        return isset($this->WarningMessage) ? $this->WarningMessage : null;
    }
    /**
     * Set WarningMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warningMessage
     * @return \patest\StructType\BizAction_Ticketing_EditBallotApplication_Request
     */
    public function setWarningMessage($warningMessage = null)
    {
        // validation for constraint: string
        if (!is_null($warningMessage) && !is_string($warningMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningMessage, true), gettype($warningMessage)), __LINE__);
        }
        if (is_null($warningMessage) || (is_array($warningMessage) && empty($warningMessage))) {
            unset($this->WarningMessage);
        } else {
            $this->WarningMessage = $warningMessage;
        }
        return $this;
    }
}
