<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.CreateBallotSectionVirtualPriceTypes.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CreateBallotSectionVirtualPriceTypes_Request extends AnyEntity
{
    /**
     * The BallotSectionVirtualPriceTypeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceTypeDetail
     */
    public $BallotSectionVirtualPriceTypeDetails;
    /**
     * The ExistBallotEventSectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExistBallotEventSectionId;
    /**
     * Constructor method for
     * BizAction.Ticketing.CreateBallotSectionVirtualPriceTypes.Request
     * @uses BizAction_Ticketing_CreateBallotSectionVirtualPriceTypes_Request::setBallotSectionVirtualPriceTypeDetails()
     * @uses BizAction_Ticketing_CreateBallotSectionVirtualPriceTypes_Request::setExistBallotEventSectionId()
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceTypeDetail $ballotSectionVirtualPriceTypeDetails
     * @param string $existBallotEventSectionId
     */
    public function __construct(\patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceTypeDetail $ballotSectionVirtualPriceTypeDetails = null, $existBallotEventSectionId = null)
    {
        $this
            ->setBallotSectionVirtualPriceTypeDetails($ballotSectionVirtualPriceTypeDetails)
            ->setExistBallotEventSectionId($existBallotEventSectionId);
    }
    /**
     * Get BallotSectionVirtualPriceTypeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceTypeDetail|null
     */
    public function getBallotSectionVirtualPriceTypeDetails()
    {
        return isset($this->BallotSectionVirtualPriceTypeDetails) ? $this->BallotSectionVirtualPriceTypeDetails : null;
    }
    /**
     * Set BallotSectionVirtualPriceTypeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceTypeDetail $ballotSectionVirtualPriceTypeDetails
     * @return \patest\StructType\BizAction_Ticketing_CreateBallotSectionVirtualPriceTypes_Request
     */
    public function setBallotSectionVirtualPriceTypeDetails(\patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceTypeDetail $ballotSectionVirtualPriceTypeDetails = null)
    {
        if (is_null($ballotSectionVirtualPriceTypeDetails) || (is_array($ballotSectionVirtualPriceTypeDetails) && empty($ballotSectionVirtualPriceTypeDetails))) {
            unset($this->BallotSectionVirtualPriceTypeDetails);
        } else {
            $this->BallotSectionVirtualPriceTypeDetails = $ballotSectionVirtualPriceTypeDetails;
        }
        return $this;
    }
    /**
     * Get ExistBallotEventSectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExistBallotEventSectionId()
    {
        return isset($this->ExistBallotEventSectionId) ? $this->ExistBallotEventSectionId : null;
    }
    /**
     * Set ExistBallotEventSectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $existBallotEventSectionId
     * @return \patest\StructType\BizAction_Ticketing_CreateBallotSectionVirtualPriceTypes_Request
     */
    public function setExistBallotEventSectionId($existBallotEventSectionId = null)
    {
        // validation for constraint: string
        if (!is_null($existBallotEventSectionId) && !is_string($existBallotEventSectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existBallotEventSectionId, true), gettype($existBallotEventSectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($existBallotEventSectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $existBallotEventSectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($existBallotEventSectionId, true)), __LINE__);
        }
        if (is_null($existBallotEventSectionId) || (is_array($existBallotEventSectionId) && empty($existBallotEventSectionId))) {
            unset($this->ExistBallotEventSectionId);
        } else {
            $this->ExistBallotEventSectionId = $existBallotEventSectionId;
        }
        return $this;
    }
}
