<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.CopyRestrictionsFromHallVersionToSeatingPlan.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request extends AnyEntity
{
    /**
     * The CopyAllocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyAllocations;
    /**
     * The CopyLocks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyLocks;
    /**
     * The HallVersionEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HallVersionEvents
     */
    public $HallVersionEvents;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The HallVersionSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HallVersionSeries
     */
    public $HallVersionSeries;
    /**
     * The RemoveCurrentRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RemoveCurrentRestrictions;
    /**
     * The SeatingPlanType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingPlanType;
    /**
     * Constructor method for
     * BizAction.Ticketing.CopyRestrictionsFromHallVersionToSeatingPlan.Request
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setCopyAllocations()
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setCopyLocks()
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setHallVersionEvents()
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setHallVersionId()
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setHallVersionSeries()
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setRemoveCurrentRestrictions()
     * @uses BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request::setSeatingPlanType()
     * @param bool $copyAllocations
     * @param bool $copyLocks
     * @param \patest\StructType\HallVersionEvents $hallVersionEvents
     * @param string $hallVersionId
     * @param \patest\StructType\HallVersionSeries $hallVersionSeries
     * @param bool $removeCurrentRestrictions
     * @param string $seatingPlanType
     */
    public function __construct($copyAllocations = null, $copyLocks = null, \patest\StructType\HallVersionEvents $hallVersionEvents = null, $hallVersionId = null, \patest\StructType\HallVersionSeries $hallVersionSeries = null, $removeCurrentRestrictions = null, $seatingPlanType = null)
    {
        $this
            ->setCopyAllocations($copyAllocations)
            ->setCopyLocks($copyLocks)
            ->setHallVersionEvents($hallVersionEvents)
            ->setHallVersionId($hallVersionId)
            ->setHallVersionSeries($hallVersionSeries)
            ->setRemoveCurrentRestrictions($removeCurrentRestrictions)
            ->setSeatingPlanType($seatingPlanType);
    }
    /**
     * Get CopyAllocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyAllocations()
    {
        return isset($this->CopyAllocations) ? $this->CopyAllocations : null;
    }
    /**
     * Set CopyAllocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyAllocations
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setCopyAllocations($copyAllocations = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyAllocations) && !is_bool($copyAllocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyAllocations, true), gettype($copyAllocations)), __LINE__);
        }
        if (is_null($copyAllocations) || (is_array($copyAllocations) && empty($copyAllocations))) {
            unset($this->CopyAllocations);
        } else {
            $this->CopyAllocations = $copyAllocations;
        }
        return $this;
    }
    /**
     * Get CopyLocks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyLocks()
    {
        return isset($this->CopyLocks) ? $this->CopyLocks : null;
    }
    /**
     * Set CopyLocks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyLocks
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setCopyLocks($copyLocks = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyLocks) && !is_bool($copyLocks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyLocks, true), gettype($copyLocks)), __LINE__);
        }
        if (is_null($copyLocks) || (is_array($copyLocks) && empty($copyLocks))) {
            unset($this->CopyLocks);
        } else {
            $this->CopyLocks = $copyLocks;
        }
        return $this;
    }
    /**
     * Get HallVersionEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HallVersionEvents|null
     */
    public function getHallVersionEvents()
    {
        return isset($this->HallVersionEvents) ? $this->HallVersionEvents : null;
    }
    /**
     * Set HallVersionEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\HallVersionEvents $hallVersionEvents
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setHallVersionEvents(\patest\StructType\HallVersionEvents $hallVersionEvents = null)
    {
        if (is_null($hallVersionEvents) || (is_array($hallVersionEvents) && empty($hallVersionEvents))) {
            unset($this->HallVersionEvents);
        } else {
            $this->HallVersionEvents = $hallVersionEvents;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get HallVersionSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HallVersionSeries|null
     */
    public function getHallVersionSeries()
    {
        return isset($this->HallVersionSeries) ? $this->HallVersionSeries : null;
    }
    /**
     * Set HallVersionSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\HallVersionSeries $hallVersionSeries
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setHallVersionSeries(\patest\StructType\HallVersionSeries $hallVersionSeries = null)
    {
        if (is_null($hallVersionSeries) || (is_array($hallVersionSeries) && empty($hallVersionSeries))) {
            unset($this->HallVersionSeries);
        } else {
            $this->HallVersionSeries = $hallVersionSeries;
        }
        return $this;
    }
    /**
     * Get RemoveCurrentRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRemoveCurrentRestrictions()
    {
        return isset($this->RemoveCurrentRestrictions) ? $this->RemoveCurrentRestrictions : null;
    }
    /**
     * Set RemoveCurrentRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $removeCurrentRestrictions
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setRemoveCurrentRestrictions($removeCurrentRestrictions = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeCurrentRestrictions) && !is_bool($removeCurrentRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removeCurrentRestrictions, true), gettype($removeCurrentRestrictions)), __LINE__);
        }
        if (is_null($removeCurrentRestrictions) || (is_array($removeCurrentRestrictions) && empty($removeCurrentRestrictions))) {
            unset($this->RemoveCurrentRestrictions);
        } else {
            $this->RemoveCurrentRestrictions = $removeCurrentRestrictions;
        }
        return $this;
    }
    /**
     * Get SeatingPlanType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanType()
    {
        return isset($this->SeatingPlanType) ? $this->SeatingPlanType : null;
    }
    /**
     * Set SeatingPlanType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanOwnerType::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanOwnerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingPlanType
     * @return \patest\StructType\BizAction_Ticketing_CopyRestrictionsFromHallVersionToSeatingPlan_Request
     */
    public function setSeatingPlanType($seatingPlanType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanOwnerType::valueIsValid($seatingPlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanOwnerType', is_array($seatingPlanType) ? implode(', ', $seatingPlanType) : var_export($seatingPlanType, true), implode(', ', \patest\EnumType\SeatingPlanOwnerType::getValidValues())), __LINE__);
        }
        if (is_null($seatingPlanType) || (is_array($seatingPlanType) && empty($seatingPlanType))) {
            unset($this->SeatingPlanType);
        } else {
            $this->SeatingPlanType = $seatingPlanType;
        }
        return $this;
    }
}
