<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.CopyHallVersion.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CopyHallVersion_Request extends AnyEntity
{
    /**
     * The FromHallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FromHallVersionId;
    /**
     * The NewHallVersionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NewHallVersionName;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * Constructor method for BizAction.Ticketing.CopyHallVersion.Request
     * @uses BizAction_Ticketing_CopyHallVersion_Request::setFromHallVersionId()
     * @uses BizAction_Ticketing_CopyHallVersion_Request::setNewHallVersionName()
     * @uses BizAction_Ticketing_CopyHallVersion_Request::setOrganizationUnitId()
     * @param string $fromHallVersionId
     * @param \patest\StructType\GlobalString $newHallVersionName
     * @param string $organizationUnitId
     */
    public function __construct($fromHallVersionId = null, \patest\StructType\GlobalString $newHallVersionName = null, $organizationUnitId = null)
    {
        $this
            ->setFromHallVersionId($fromHallVersionId)
            ->setNewHallVersionName($newHallVersionName)
            ->setOrganizationUnitId($organizationUnitId);
    }
    /**
     * Get FromHallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromHallVersionId()
    {
        return isset($this->FromHallVersionId) ? $this->FromHallVersionId : null;
    }
    /**
     * Set FromHallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromHallVersionId
     * @return \patest\StructType\BizAction_Ticketing_CopyHallVersion_Request
     */
    public function setFromHallVersionId($fromHallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($fromHallVersionId) && !is_string($fromHallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromHallVersionId, true), gettype($fromHallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fromHallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fromHallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fromHallVersionId, true)), __LINE__);
        }
        if (is_null($fromHallVersionId) || (is_array($fromHallVersionId) && empty($fromHallVersionId))) {
            unset($this->FromHallVersionId);
        } else {
            $this->FromHallVersionId = $fromHallVersionId;
        }
        return $this;
    }
    /**
     * Get NewHallVersionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNewHallVersionName()
    {
        return isset($this->NewHallVersionName) ? $this->NewHallVersionName : null;
    }
    /**
     * Set NewHallVersionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $newHallVersionName
     * @return \patest\StructType\BizAction_Ticketing_CopyHallVersion_Request
     */
    public function setNewHallVersionName(\patest\StructType\GlobalString $newHallVersionName = null)
    {
        if (is_null($newHallVersionName) || (is_array($newHallVersionName) && empty($newHallVersionName))) {
            unset($this->NewHallVersionName);
        } else {
            $this->NewHallVersionName = $newHallVersionName;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizAction_Ticketing_CopyHallVersion_Request
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
}
