<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.CancelTicketResaleRequest.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CancelTicketResaleRequest_Request extends AnyEntity
{
    /**
     * The ResaleRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResaleRequestId;
    /**
     * The ResaleRequestIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ResaleRequestIds
     */
    public $ResaleRequestIds;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketIds
     */
    public $TicketIds;
    /**
     * Constructor method for BizAction.Ticketing.CancelTicketResaleRequest.Request
     * @uses BizAction_Ticketing_CancelTicketResaleRequest_Request::setResaleRequestId()
     * @uses BizAction_Ticketing_CancelTicketResaleRequest_Request::setResaleRequestIds()
     * @uses BizAction_Ticketing_CancelTicketResaleRequest_Request::setTicketIds()
     * @param string $resaleRequestId
     * @param \patest\StructType\ResaleRequestIds $resaleRequestIds
     * @param \patest\StructType\TicketIds $ticketIds
     */
    public function __construct($resaleRequestId = null, \patest\StructType\ResaleRequestIds $resaleRequestIds = null, \patest\StructType\TicketIds $ticketIds = null)
    {
        $this
            ->setResaleRequestId($resaleRequestId)
            ->setResaleRequestIds($resaleRequestIds)
            ->setTicketIds($ticketIds);
    }
    /**
     * Get ResaleRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleRequestId()
    {
        return isset($this->ResaleRequestId) ? $this->ResaleRequestId : null;
    }
    /**
     * Set ResaleRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resaleRequestId
     * @return \patest\StructType\BizAction_Ticketing_CancelTicketResaleRequest_Request
     */
    public function setResaleRequestId($resaleRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($resaleRequestId) && !is_string($resaleRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resaleRequestId, true), gettype($resaleRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resaleRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resaleRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resaleRequestId, true)), __LINE__);
        }
        if (is_null($resaleRequestId) || (is_array($resaleRequestId) && empty($resaleRequestId))) {
            unset($this->ResaleRequestId);
        } else {
            $this->ResaleRequestId = $resaleRequestId;
        }
        return $this;
    }
    /**
     * Get ResaleRequestIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ResaleRequestIds|null
     */
    public function getResaleRequestIds()
    {
        return isset($this->ResaleRequestIds) ? $this->ResaleRequestIds : null;
    }
    /**
     * Set ResaleRequestIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ResaleRequestIds $resaleRequestIds
     * @return \patest\StructType\BizAction_Ticketing_CancelTicketResaleRequest_Request
     */
    public function setResaleRequestIds(\patest\StructType\ResaleRequestIds $resaleRequestIds = null)
    {
        if (is_null($resaleRequestIds) || (is_array($resaleRequestIds) && empty($resaleRequestIds))) {
            unset($this->ResaleRequestIds);
        } else {
            $this->ResaleRequestIds = $resaleRequestIds;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketIds|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketIds $ticketIds
     * @return \patest\StructType\BizAction_Ticketing_CancelTicketResaleRequest_Request
     */
    public function setTicketIds(\patest\StructType\TicketIds $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
}
