<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.CallOverSeatInventory.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CallOverSeatInventory_Request extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The InventoryProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryProviderId;
    /**
     * The InventoryTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryTypeId;
    /**
     * The LiabilityStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LiabilityStatusId;
    /**
     * The SalesStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesStatus;
    /**
     * The SeatLumps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeatInventoryLump
     */
    public $SeatLumps;
    /**
     * Constructor method for BizAction.Ticketing.CallOverSeatInventory.Request
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setAreaId()
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setEventId()
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setInventoryProviderId()
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setInventoryTypeId()
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setLiabilityStatusId()
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setSalesStatus()
     * @uses BizAction_Ticketing_CallOverSeatInventory_Request::setSeatLumps()
     * @param string $areaId
     * @param string $eventId
     * @param string $inventoryProviderId
     * @param string $inventoryTypeId
     * @param string $liabilityStatusId
     * @param string $salesStatus
     * @param \patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps
     */
    public function __construct($areaId = null, $eventId = null, $inventoryProviderId = null, $inventoryTypeId = null, $liabilityStatusId = null, $salesStatus = null, \patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps = null)
    {
        $this
            ->setAreaId($areaId)
            ->setEventId($eventId)
            ->setInventoryProviderId($inventoryProviderId)
            ->setInventoryTypeId($inventoryTypeId)
            ->setLiabilityStatusId($liabilityStatusId)
            ->setSalesStatus($salesStatus)
            ->setSeatLumps($seatLumps);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get InventoryProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryProviderId()
    {
        return isset($this->InventoryProviderId) ? $this->InventoryProviderId : null;
    }
    /**
     * Set InventoryProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryProviderId
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setInventoryProviderId($inventoryProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryProviderId) && !is_string($inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryProviderId, true), gettype($inventoryProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryProviderId, true)), __LINE__);
        }
        if (is_null($inventoryProviderId) || (is_array($inventoryProviderId) && empty($inventoryProviderId))) {
            unset($this->InventoryProviderId);
        } else {
            $this->InventoryProviderId = $inventoryProviderId;
        }
        return $this;
    }
    /**
     * Get InventoryTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryTypeId()
    {
        return isset($this->InventoryTypeId) ? $this->InventoryTypeId : null;
    }
    /**
     * Set InventoryTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryTypeId
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setInventoryTypeId($inventoryTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryTypeId) && !is_string($inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryTypeId, true), gettype($inventoryTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryTypeId, true)), __LINE__);
        }
        if (is_null($inventoryTypeId) || (is_array($inventoryTypeId) && empty($inventoryTypeId))) {
            unset($this->InventoryTypeId);
        } else {
            $this->InventoryTypeId = $inventoryTypeId;
        }
        return $this;
    }
    /**
     * Get LiabilityStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiabilityStatusId()
    {
        return isset($this->LiabilityStatusId) ? $this->LiabilityStatusId : null;
    }
    /**
     * Set LiabilityStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liabilityStatusId
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setLiabilityStatusId($liabilityStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusId) && !is_string($liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusId, true), gettype($liabilityStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($liabilityStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($liabilityStatusId, true)), __LINE__);
        }
        if (is_null($liabilityStatusId) || (is_array($liabilityStatusId) && empty($liabilityStatusId))) {
            unset($this->LiabilityStatusId);
        } else {
            $this->LiabilityStatusId = $liabilityStatusId;
        }
        return $this;
    }
    /**
     * Get SalesStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesStatus()
    {
        return isset($this->SalesStatus) ? $this->SalesStatus : null;
    }
    /**
     * Set SalesStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatSalesStatus::valueIsValid()
     * @uses \patest\EnumType\SeatSalesStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesStatus
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setSalesStatus($salesStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatSalesStatus::valueIsValid($salesStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatSalesStatus', is_array($salesStatus) ? implode(', ', $salesStatus) : var_export($salesStatus, true), implode(', ', \patest\EnumType\SeatSalesStatus::getValidValues())), __LINE__);
        }
        if (is_null($salesStatus) || (is_array($salesStatus) && empty($salesStatus))) {
            unset($this->SalesStatus);
        } else {
            $this->SalesStatus = $salesStatus;
        }
        return $this;
    }
    /**
     * Get SeatLumps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeatInventoryLump|null
     */
    public function getSeatLumps()
    {
        return isset($this->SeatLumps) ? $this->SeatLumps : null;
    }
    /**
     * Set SeatLumps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps
     * @return \patest\StructType\BizAction_Ticketing_CallOverSeatInventory_Request
     */
    public function setSeatLumps(\patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps = null)
    {
        if (is_null($seatLumps) || (is_array($seatLumps) && empty($seatLumps))) {
            unset($this->SeatLumps);
        } else {
            $this->SeatLumps = $seatLumps;
        }
        return $this;
    }
}
