<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.AwayGameTicketAllotment.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AwayGameTicketAllotment_Request extends AnyEntity
{
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AwayTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AwayGameTicketAllotmentRow
     */
    public $AwayTickets;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CrmName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmName;
    /**
     * The DisplayByAllocationStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayByAllocationStatus;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The FromTravelGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromTravelGroup;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AwayGameTicketTotalsRow
     */
    public $Totals;
    /**
     * The ToTravelGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToTravelGroup;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TravelGroupMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TravelGroupMode;
    /**
     * The TravelGroupThresholdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelGroupThresholdDate;
    /**
     * Constructor method for BizAction.Ticketing.AwayGameTicketAllotment.Request
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setArea()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setAreaId()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setAwayTickets()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setCrmId()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setCrmName()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setDisplayByAllocationStatus()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setEventId()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setFromDate()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setFromTravelGroup()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setRow()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setSeat()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setToDate()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setTotals()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setToTravelGroup()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setTransactionNumber()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setTravelGroupMode()
     * @uses BizAction_Ticketing_AwayGameTicketAllotment_Request::setTravelGroupThresholdDate()
     * @param string $area
     * @param string $areaId
     * @param \patest\StructType\RecordSetOfTicketing_AwayGameTicketAllotmentRow $awayTickets
     * @param string $crmId
     * @param string $crmName
     * @param int $displayByAllocationStatus
     * @param string $eventId
     * @param string $fromDate
     * @param int $fromTravelGroup
     * @param string $row
     * @param string $seat
     * @param string $toDate
     * @param \patest\StructType\RecordSetOfTicketing_AwayGameTicketTotalsRow $totals
     * @param int $toTravelGroup
     * @param int $transactionNumber
     * @param int $travelGroupMode
     * @param string $travelGroupThresholdDate
     */
    public function __construct($area = null, $areaId = null, \patest\StructType\RecordSetOfTicketing_AwayGameTicketAllotmentRow $awayTickets = null, $crmId = null, $crmName = null, $displayByAllocationStatus = null, $eventId = null, $fromDate = null, $fromTravelGroup = null, $row = null, $seat = null, $toDate = null, \patest\StructType\RecordSetOfTicketing_AwayGameTicketTotalsRow $totals = null, $toTravelGroup = null, $transactionNumber = null, $travelGroupMode = null, $travelGroupThresholdDate = null)
    {
        $this
            ->setArea($area)
            ->setAreaId($areaId)
            ->setAwayTickets($awayTickets)
            ->setCrmId($crmId)
            ->setCrmName($crmName)
            ->setDisplayByAllocationStatus($displayByAllocationStatus)
            ->setEventId($eventId)
            ->setFromDate($fromDate)
            ->setFromTravelGroup($fromTravelGroup)
            ->setRow($row)
            ->setSeat($seat)
            ->setToDate($toDate)
            ->setTotals($totals)
            ->setToTravelGroup($toTravelGroup)
            ->setTransactionNumber($transactionNumber)
            ->setTravelGroupMode($travelGroupMode)
            ->setTravelGroupThresholdDate($travelGroupThresholdDate);
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AwayTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AwayGameTicketAllotmentRow|null
     */
    public function getAwayTickets()
    {
        return isset($this->AwayTickets) ? $this->AwayTickets : null;
    }
    /**
     * Set AwayTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AwayGameTicketAllotmentRow $awayTickets
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setAwayTickets(\patest\StructType\RecordSetOfTicketing_AwayGameTicketAllotmentRow $awayTickets = null)
    {
        if (is_null($awayTickets) || (is_array($awayTickets) && empty($awayTickets))) {
            unset($this->AwayTickets);
        } else {
            $this->AwayTickets = $awayTickets;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CrmName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmName()
    {
        return isset($this->CrmName) ? $this->CrmName : null;
    }
    /**
     * Set CrmName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmName
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setCrmName($crmName = null)
    {
        // validation for constraint: string
        if (!is_null($crmName) && !is_string($crmName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmName, true), gettype($crmName)), __LINE__);
        }
        if (is_null($crmName) || (is_array($crmName) && empty($crmName))) {
            unset($this->CrmName);
        } else {
            $this->CrmName = $crmName;
        }
        return $this;
    }
    /**
     * Get DisplayByAllocationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayByAllocationStatus()
    {
        return isset($this->DisplayByAllocationStatus) ? $this->DisplayByAllocationStatus : null;
    }
    /**
     * Set DisplayByAllocationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayByAllocationStatus
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setDisplayByAllocationStatus($displayByAllocationStatus = null)
    {
        // validation for constraint: int
        if (!is_null($displayByAllocationStatus) && !(is_int($displayByAllocationStatus) || ctype_digit($displayByAllocationStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayByAllocationStatus, true), gettype($displayByAllocationStatus)), __LINE__);
        }
        if (is_null($displayByAllocationStatus) || (is_array($displayByAllocationStatus) && empty($displayByAllocationStatus))) {
            unset($this->DisplayByAllocationStatus);
        } else {
            $this->DisplayByAllocationStatus = $displayByAllocationStatus;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromTravelGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromTravelGroup()
    {
        return isset($this->FromTravelGroup) ? $this->FromTravelGroup : null;
    }
    /**
     * Set FromTravelGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromTravelGroup
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setFromTravelGroup($fromTravelGroup = null)
    {
        // validation for constraint: int
        if (!is_null($fromTravelGroup) && !(is_int($fromTravelGroup) || ctype_digit($fromTravelGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTravelGroup, true), gettype($fromTravelGroup)), __LINE__);
        }
        if (is_null($fromTravelGroup) || (is_array($fromTravelGroup) && empty($fromTravelGroup))) {
            unset($this->FromTravelGroup);
        } else {
            $this->FromTravelGroup = $fromTravelGroup;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AwayGameTicketTotalsRow|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AwayGameTicketTotalsRow $totals
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setTotals(\patest\StructType\RecordSetOfTicketing_AwayGameTicketTotalsRow $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
    /**
     * Get ToTravelGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToTravelGroup()
    {
        return isset($this->ToTravelGroup) ? $this->ToTravelGroup : null;
    }
    /**
     * Set ToTravelGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toTravelGroup
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setToTravelGroup($toTravelGroup = null)
    {
        // validation for constraint: int
        if (!is_null($toTravelGroup) && !(is_int($toTravelGroup) || ctype_digit($toTravelGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTravelGroup, true), gettype($toTravelGroup)), __LINE__);
        }
        if (is_null($toTravelGroup) || (is_array($toTravelGroup) && empty($toTravelGroup))) {
            unset($this->ToTravelGroup);
        } else {
            $this->ToTravelGroup = $toTravelGroup;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TravelGroupMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTravelGroupMode()
    {
        return isset($this->TravelGroupMode) ? $this->TravelGroupMode : null;
    }
    /**
     * Set TravelGroupMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $travelGroupMode
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setTravelGroupMode($travelGroupMode = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroupMode) && !(is_int($travelGroupMode) || ctype_digit($travelGroupMode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroupMode, true), gettype($travelGroupMode)), __LINE__);
        }
        if (is_null($travelGroupMode) || (is_array($travelGroupMode) && empty($travelGroupMode))) {
            unset($this->TravelGroupMode);
        } else {
            $this->TravelGroupMode = $travelGroupMode;
        }
        return $this;
    }
    /**
     * Get TravelGroupThresholdDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelGroupThresholdDate()
    {
        return isset($this->TravelGroupThresholdDate) ? $this->TravelGroupThresholdDate : null;
    }
    /**
     * Set TravelGroupThresholdDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelGroupThresholdDate
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTicketAllotment_Request
     */
    public function setTravelGroupThresholdDate($travelGroupThresholdDate = null)
    {
        // validation for constraint: string
        if (!is_null($travelGroupThresholdDate) && !is_string($travelGroupThresholdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelGroupThresholdDate, true), gettype($travelGroupThresholdDate)), __LINE__);
        }
        if (is_null($travelGroupThresholdDate) || (is_array($travelGroupThresholdDate) && empty($travelGroupThresholdDate))) {
            unset($this->TravelGroupThresholdDate);
        } else {
            $this->TravelGroupThresholdDate = $travelGroupThresholdDate;
        }
        return $this;
    }
}
